/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.metaserver.GetNodesRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class GetNodesRequestHandler
extends AbstractServerHandler<GetNodesRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"META-CONNECT");
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, GetNodesRequest getNodesRequest) {
        NodeChangeResult nodeChangeResult;
        try {
            nodeChangeResult = this.metaServerRegistry.getAllNodes(getNodesRequest.getNodeType());
            LOGGER.info("Get {} change node list {} success!from {}", new Object[]{getNodesRequest.getNodeType(), nodeChangeResult, channel.getRemoteAddress()});
        }
        catch (Exception e) {
            LOGGER.error("Get node list error!", (Throwable)e);
            throw new RuntimeException("Get node list error!", e);
        }
        return nodeChangeResult;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return GetNodesRequest.class;
    }
}

