/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.remoting;

import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.SyncUserProcessor;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.model.ConfiguratorData;
import com.alipay.sofa.registry.client.provider.DefaultConfigurator;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.task.ObserverHandler;
import com.alipay.sofa.registry.core.model.ReceivedConfigData;
import com.alipay.sofa.registry.core.model.Result;
import java.util.List;
import org.slf4j.Logger;

public class ReceivedConfigDataProcessor
extends SyncUserProcessor<ReceivedConfigData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedConfigDataProcessor.class);
    private RegisterCache registerCache;
    private ObserverHandler observerHandler;

    public ReceivedConfigDataProcessor(RegisterCache registerCache, ObserverHandler observerHandler) {
        this.registerCache = registerCache;
        this.observerHandler = observerHandler;
    }

    public Object handleRequest(BizContext bizCtx, ReceivedConfigData request) {
        Result result = new Result();
        result.setSuccess(true);
        if (null == request) {
            return result;
        }
        List<String> registIds = request.getConfiguratorRegistIds();
        try {
            ConfiguratorData configuratorData = new ConfiguratorData();
            configuratorData.setDataBox(request.getDataBox());
            configuratorData.setVersion(request.getVersion());
            for (String registId : registIds) {
                Configurator configurator = this.registerCache.getConfiguratorByRegistId(registId);
                if (null == configurator) continue;
                if (configurator instanceof DefaultConfigurator) {
                    ((DefaultConfigurator)configurator).putConfiguratorData(configuratorData);
                    try {
                        this.observerHandler.notify(configurator);
                    }
                    catch (Exception e) {
                        LOGGER.error("[received] add configurator notify task error, dataId: {}, registId: {}", new Object[]{configurator.getDataId(), configurator.getRegistId(), e});
                    }
                    continue;
                }
                LOGGER.warn("[received] ignore unknown configurator type: {}", (Object)configurator.getClass().getName());
            }
            LOGGER.info("[received] receive configurator data save success, dataId: {} version: {} data:{} registIds:{}", new Object[]{request.getDataId(), request.getVersion(), request.getDataBox(), registIds});
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage("");
            LOGGER.info("[received] receive configurator data save failed, dataId: {} version: {} data:{}", new Object[]{request.getDataId(), request.getVersion(), request.getDataBox(), e});
        }
        return result;
    }

    public String interest() {
        return ReceivedConfigData.class.getName();
    }
}

