/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfig;

public class DefaultRegistryClientConfigBuilder {
    private String env;
    private String instanceId;
    private String zone = "DEFAULT_ZONE";
    private String registryEndpoint;
    private int registryEndpointPort = 9603;
    private String dataCenter = "DefaultDataCenter";
    private String appName;
    private int connectTimeout = 3000;
    private int socketTimeout = 3000;
    private int invokeTimeout = 1000;
    private int recheckInterval = 500;
    private int observerThreadCoreSize = 5;
    private int observerThreadMaxSize = 10;
    private int observerThreadQueueLength = 1000;
    private int observerCallbackTimeout = 5000;
    private int syncConfigRetryInterval = 30000;
    private String accessKey;
    private String secretKey;
    private String algorithm = "HmacSHA256";
    private long authCacheInterval = 300000L;
    private boolean eventBusEnable = true;

    public static DefaultRegistryClientConfigBuilder start() {
        return new DefaultRegistryClientConfigBuilder();
    }

    public DefaultRegistryClientConfigBuilder setEnv(String env) {
        this.env = env;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setZone(String zone) {
        this.zone = zone;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setRegistryEndpoint(String registryEndpoint) {
        this.registryEndpoint = registryEndpoint;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setRegistryEndpointPort(int registryEndpointPort) {
        this.registryEndpointPort = registryEndpointPort;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setObserverThreadCoreSize(int observerThreadCoreSize) {
        this.observerThreadCoreSize = observerThreadCoreSize;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setObserverThreadMaxSize(int observerThreadMaxSize) {
        this.observerThreadMaxSize = observerThreadMaxSize;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setObserverThreadQueueLength(int observerThreadQueueLength) {
        this.observerThreadQueueLength = observerThreadQueueLength;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setObserverCallbackTimeout(int observerCallbackTimeout) {
        this.observerCallbackTimeout = observerCallbackTimeout;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setInvokeTimeout(int invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setRecheckInterval(int recheckInterval) {
        this.recheckInterval = recheckInterval;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setSyncConfigRetryInterval(int syncConfigRetryInterval) {
        this.syncConfigRetryInterval = syncConfigRetryInterval;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setAuthCacheInterval(long authCacheInterval) {
        this.authCacheInterval = authCacheInterval;
        return this;
    }

    public DefaultRegistryClientConfigBuilder setEventBusEnable(boolean eventBusEnable) {
        this.eventBusEnable = eventBusEnable;
        return this;
    }

    public DefaultRegistryClientConfig build() {
        return new DefaultRegistryClientConfig(this.env, this.instanceId, this.zone, this.registryEndpoint, this.registryEndpointPort, this.dataCenter, this.appName, this.connectTimeout, this.socketTimeout, this.invokeTimeout, this.recheckInterval, this.observerThreadCoreSize, this.observerThreadMaxSize, this.observerThreadQueueLength, this.observerCallbackTimeout, this.syncConfigRetryInterval, this.accessKey, this.secretKey, this.algorithm, this.authCacheInterval, this.eventBusEnable);
    }
}

