/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.log.BoltLoggerFactory;
import java.lang.ref.SoftReference;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class Url {
    private String originUrl;
    private String ip;
    private int port;
    private String uniqueKey;
    private int connectTimeout;
    private byte protocol;
    private byte version = 1;
    private int connNum;
    private boolean connWarmup;
    private Properties properties;
    public static ConcurrentHashMap<String, SoftReference<Url>> parsedUrls = new ConcurrentHashMap();
    public static volatile boolean isCollected = false;
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");

    protected Url(String originUrl) {
        this.originUrl = originUrl;
    }

    public Url(String ip, int port) {
        this(ip + ':' + port);
        this.ip = ip;
        this.port = port;
        this.uniqueKey = this.originUrl;
    }

    public Url(String originUrl, String ip, int port) {
        this(originUrl);
        this.ip = ip;
        this.port = port;
        this.uniqueKey = ip + ':' + port;
    }

    public Url(String originUrl, String ip, int port, Properties properties) {
        this(originUrl, ip, port);
        this.properties = properties;
    }

    public Url(String originUrl, String ip, int port, String uniqueKey, Properties properties) {
        this(originUrl, ip, port);
        this.uniqueKey = uniqueKey;
        this.properties = properties;
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("Illegal value of connection number [" + this.connNum + "], must be a positive integer].");
        }
        this.connectTimeout = connectTimeout;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    public int getConnNum() {
        return this.connNum;
    }

    public void setConnNum(int connNum) {
        if (connNum <= 0 || connNum > 1000000) {
            throw new IllegalArgumentException("Illegal value of connection number [" + connNum + "], must be an integer between [" + 1 + ", " + 1000000 + "].");
        }
        this.connNum = connNum;
    }

    public boolean isConnWarmup() {
        return this.connWarmup;
    }

    public void setConnWarmup(boolean connWarmup) {
        this.connWarmup = connWarmup;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Url url = (Url)obj;
        return this.getOriginUrl().equals(url.getOriginUrl());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getOriginUrl() == null ? 0 : this.getOriginUrl().hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Origin url [").append(this.originUrl).append("], Unique key [").append(this.uniqueKey).append("].");
        return sb.toString();
    }

    protected void finalize() {
        try {
            isCollected = true;
            parsedUrls.remove(this.getOriginUrl());
        }
        catch (Exception e) {
            logger.error("Exception occurred when do finalize for Url [{}].", (Object)this.getOriginUrl(), (Object)e);
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }
}

