/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebAppStatValue;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.http.stat.WebURIStatValue;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import com.alibaba.druid.util.LRUCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WebAppStat {
    private static final Log LOG = LogFactory.getLog(WebAppStat.class);
    public static final int DEFAULT_MAX_STAT_URI_COUNT = 1000;
    public static final int DEFAULT_MAX_STAT_SESSION_COUNT = 1000;
    private static final ThreadLocal<WebAppStat> currentLocal = new ThreadLocal();
    private volatile int maxStatUriCount = 1000;
    private volatile int maxStatSessionCount = 1000;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong sessionCount = new AtomicLong(0L);
    private final AtomicLong jdbcFetchRowCount = new AtomicLong();
    private final AtomicLong jdbcUpdateCount = new AtomicLong();
    private final AtomicLong jdbcExecuteCount = new AtomicLong();
    private final AtomicLong jdbcExecuteTimeNano = new AtomicLong();
    private final AtomicLong jdbcCommitCount = new AtomicLong();
    private final AtomicLong jdbcRollbackCount = new AtomicLong();
    private final ConcurrentMap<String, WebURIStat> uriStatMap = new ConcurrentHashMap<String, WebURIStat>(16, 0.75f, 1);
    private final LRUCache<String, WebSessionStat> sessionStatMap;
    private final ReadWriteLock sessionStatLock = new ReentrantReadWriteLock();
    private final AtomicLong uriStatMapFullCount = new AtomicLong();
    private final AtomicLong uriSessionMapFullCount = new AtomicLong();
    private final AtomicLong osMacOSXCount = new AtomicLong(0L);
    private final AtomicLong osWindowsCount = new AtomicLong(0L);
    private final AtomicLong osLinuxCount = new AtomicLong(0L);
    private final AtomicLong osSymbianCount = new AtomicLong(0L);
    private final AtomicLong osFreeBSDCount = new AtomicLong(0L);
    private final AtomicLong osOpenBSDCount = new AtomicLong(0L);
    private final AtomicLong osAndroidCount = new AtomicLong(0L);
    private final AtomicLong osWindows98Count = new AtomicLong();
    private final AtomicLong osWindowsXPCount = new AtomicLong();
    private final AtomicLong osWindows2000Count = new AtomicLong();
    private final AtomicLong osWindowsVistaCount = new AtomicLong();
    private final AtomicLong osWindows7Count = new AtomicLong();
    private final AtomicLong osWindows8Count = new AtomicLong();
    private final AtomicLong osAndroid15Count = new AtomicLong(0L);
    private final AtomicLong osAndroid16Count = new AtomicLong(0L);
    private final AtomicLong osAndroid20Count = new AtomicLong(0L);
    private final AtomicLong osAndroid21Count = new AtomicLong(0L);
    private final AtomicLong osAndroid22Count = new AtomicLong(0L);
    private final AtomicLong osAndroid23Count = new AtomicLong(0L);
    private final AtomicLong osAndroid30Count = new AtomicLong(0L);
    private final AtomicLong osAndroid31Count = new AtomicLong(0L);
    private final AtomicLong osAndroid32Count = new AtomicLong(0L);
    private final AtomicLong osAndroid40Count = new AtomicLong(0L);
    private final AtomicLong osAndroid41Count = new AtomicLong(0L);
    private final AtomicLong osAndroid42Count = new AtomicLong(0L);
    private final AtomicLong osAndroid43Count = new AtomicLong(0L);
    private final AtomicLong osLinuxUbuntuCount = new AtomicLong(0L);
    private final AtomicLong browserIECount = new AtomicLong(0L);
    private final AtomicLong browserFirefoxCount = new AtomicLong(0L);
    private final AtomicLong browserChromeCount = new AtomicLong(0L);
    private final AtomicLong browserSafariCount = new AtomicLong(0L);
    private final AtomicLong browserOperaCount = new AtomicLong(0L);
    private final AtomicLong browserIE5Count = new AtomicLong(0L);
    private final AtomicLong browserIE6Count = new AtomicLong(0L);
    private final AtomicLong browserIE7Count = new AtomicLong(0L);
    private final AtomicLong browserIE8Count = new AtomicLong(0L);
    private final AtomicLong browserIE9Count = new AtomicLong(0L);
    private final AtomicLong browserIE10Count = new AtomicLong(0L);
    private final AtomicLong browser360SECount = new AtomicLong(0L);
    private final AtomicLong deviceAndroidCount = new AtomicLong(0L);
    private final AtomicLong deviceIpadCount = new AtomicLong(0L);
    private final AtomicLong deviceIphoneCount = new AtomicLong(0L);
    private final AtomicLong deviceWindowsPhoneCount = new AtomicLong(0L);
    private final AtomicLong botCount = new AtomicLong();
    private final AtomicLong botBaiduCount = new AtomicLong();
    private final AtomicLong botYoudaoCount = new AtomicLong();
    private final AtomicLong botGoogleCount = new AtomicLong();
    private final AtomicLong botMsnCount = new AtomicLong();
    private final AtomicLong botBingCount = new AtomicLong();
    private final AtomicLong botSosoCount = new AtomicLong();
    private final AtomicLong botSogouCount = new AtomicLong();
    private final AtomicLong botYahooCount = new AtomicLong();
    private String contextPath;

    public static WebAppStat current() {
        return currentLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.concurrentMax.set(0);
        this.requestCount.set(0L);
        this.requestCount.set(0L);
        this.sessionCount.set(0L);
        this.jdbcFetchRowCount.set(0L);
        this.jdbcUpdateCount.set(0L);
        this.jdbcExecuteCount.set(0L);
        this.jdbcExecuteTimeNano.set(0L);
        this.jdbcCommitCount.set(0L);
        this.jdbcRollbackCount.set(0L);
        this.sessionStatLock.readLock().lock();
        try {
            for (Map.Entry entry : this.sessionStatMap.entrySet()) {
                ((WebSessionStat)entry.getValue()).reset();
            }
            this.sessionStatMap.clear();
        }
        finally {
            this.sessionStatLock.readLock().unlock();
        }
        this.uriStatMap.clear();
        this.uriStatMapFullCount.set(0L);
        this.uriSessionMapFullCount.set(0L);
        this.osMacOSXCount.set(0L);
        this.osWindowsCount.set(0L);
        this.osLinuxCount.set(0L);
        this.osSymbianCount.set(0L);
        this.osOpenBSDCount.set(0L);
        this.osFreeBSDCount.set(0L);
        this.osAndroidCount.set(0L);
        this.osWindows98Count.set(0L);
        this.osWindowsXPCount.set(0L);
        this.osWindows2000Count.set(0L);
        this.osWindowsVistaCount.set(0L);
        this.osWindows7Count.set(0L);
        this.osWindows8Count.set(0L);
        this.osLinuxUbuntuCount.set(0L);
        this.osAndroid15Count.set(0L);
        this.osAndroid16Count.set(0L);
        this.osAndroid20Count.set(0L);
        this.osAndroid21Count.set(0L);
        this.osAndroid22Count.set(0L);
        this.osAndroid23Count.set(0L);
        this.osAndroid30Count.set(0L);
        this.osAndroid31Count.set(0L);
        this.osAndroid32Count.set(0L);
        this.osAndroid40Count.set(0L);
        this.osAndroid41Count.set(0L);
        this.osAndroid42Count.set(0L);
        this.osAndroid43Count.set(0L);
        this.browserIE6Count.set(0L);
        this.browserIE7Count.set(0L);
        this.browserIE8Count.set(0L);
        this.browserIE9Count.set(0L);
        this.browserIE10Count.set(0L);
        this.browserIECount.set(0L);
        this.browserFirefoxCount.set(0L);
        this.browserChromeCount.set(0L);
        this.browserSafariCount.set(0L);
        this.browserOperaCount.set(0L);
        this.browser360SECount.set(0L);
        this.deviceAndroidCount.set(0L);
        this.deviceIpadCount.set(0L);
        this.deviceIphoneCount.set(0L);
        this.deviceWindowsPhoneCount.set(0L);
    }

    public WebAppStat() {
        this(null);
    }

    public WebAppStat(String contextPath) {
        this(contextPath, 1000);
    }

    public WebAppStat(String contextPath, int maxStatSessionCount) {
        this.contextPath = contextPath;
        this.maxStatSessionCount = maxStatSessionCount;
        this.sessionStatMap = new LRUCache(maxStatSessionCount);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = this.runningCount.incrementAndGet();
        while (running > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, running)) {
        }
        this.requestCount.incrementAndGet();
    }

    public WebURIStat getURIStat(String uri) {
        return this.getURIStat(uri, false);
    }

    public WebURIStat getURIStat(String uri, boolean create) {
        WebURIStat uriStat = (WebURIStat)this.uriStatMap.get(uri);
        if (uriStat != null) {
            return uriStat;
        }
        if (!create) {
            return null;
        }
        if (this.uriStatMap.size() >= this.getMaxStatUriCount()) {
            long fullCount = this.uriStatMapFullCount.getAndIncrement();
            if (fullCount == 0L) {
                LOG.error("uriSessionMapFullCount is full");
            }
            return null;
        }
        if (uriStat == null) {
            this.uriStatMap.putIfAbsent(uri, new WebURIStat(uri));
            uriStat = (WebURIStat)this.uriStatMap.get(uri);
        }
        return uriStat;
    }

    public WebSessionStat getSessionStat(String sessionId) {
        return this.getSessionStat(sessionId, false);
    }

    public Map<String, Object> getSessionStatData(String sessionId) {
        WebSessionStat sessionStat = (WebSessionStat)this.sessionStatMap.get(sessionId);
        if (sessionStat == null) {
            return null;
        }
        return sessionStat.getStatData();
    }

    public Map<String, Object> getURIStatData(String uri) {
        WebURIStat uriStat = this.getURIStat(uri);
        if (uriStat == null) {
            return null;
        }
        return uriStat.getStatData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSessionStat getSessionStat(String sessionId, boolean create) {
        WebSessionStat uriStat;
        this.sessionStatLock.readLock().lock();
        try {
            uriStat = (WebSessionStat)this.sessionStatMap.get(sessionId);
            if (uriStat != null) {
                WebSessionStat webSessionStat = uriStat;
                return webSessionStat;
            }
        }
        finally {
            this.sessionStatLock.readLock().unlock();
        }
        if (!create) {
            return null;
        }
        this.sessionStatLock.writeLock().lock();
        try {
            uriStat = (WebSessionStat)this.sessionStatMap.get(sessionId);
            if (uriStat == null) {
                long fullCount;
                if (this.sessionStatMap.size() >= this.getMaxStatSessionCount() && (fullCount = this.uriSessionMapFullCount.getAndIncrement()) == 0L) {
                    LOG.error("sessionStatMap is full");
                }
                WebSessionStat newStat = new WebSessionStat(sessionId);
                this.sessionStatMap.put(sessionId, newStat);
                WebSessionStat webSessionStat = newStat;
                return webSessionStat;
            }
            WebSessionStat webSessionStat = uriStat;
            return webSessionStat;
        }
        finally {
            this.sessionStatLock.writeLock().unlock();
        }
    }

    public void afterInvoke(Throwable error, long nanoSpan) {
        this.runningCount.decrementAndGet();
        currentLocal.set(null);
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.addJdbcExecuteCount(requestStat.getJdbcExecuteCount());
            this.addJdbcFetchRowCount(requestStat.getJdbcFetchRowCount());
            this.addJdbcUpdateCount(requestStat.getJdbcUpdateCount());
            this.addJdbcCommitCount(requestStat.getJdbcCommitCount());
            this.addJdbcRollbackCount(requestStat.getJdbcRollbackCount());
            this.addJdbcExecuteTimeNano(requestStat.getJdbcExecuteTimeNano());
        }
    }

    public void incrementSessionCount() {
        this.sessionCount.incrementAndGet();
    }

    public long getSessionCount() {
        return this.sessionCount.get();
    }

    public void addJdbcFetchRowCount(long delta) {
        this.jdbcFetchRowCount.addAndGet(delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount.get();
    }

    public void addJdbcUpdateCount(long updateCount) {
        this.jdbcUpdateCount.addAndGet(updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount.get();
    }

    public void incrementJdbcExecuteCount() {
        this.jdbcExecuteCount.incrementAndGet();
    }

    public void addJdbcExecuteCount(long executeCount) {
        this.jdbcExecuteCount.addAndGet(executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount.get();
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano.get();
    }

    public void addJdbcExecuteTimeNano(long nano) {
        this.jdbcExecuteTimeNano.addAndGet(nano);
    }

    public void incrementJdbcCommitCount() {
        this.jdbcCommitCount.incrementAndGet();
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount.get();
    }

    public void addJdbcCommitCount(long commitCount) {
        this.jdbcCommitCount.addAndGet(commitCount);
    }

    public void incrementJdbcRollbackCount() {
        this.jdbcRollbackCount.incrementAndGet();
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount.get();
    }

    public void addJdbcRollbackCount(long rollbackCount) {
        this.jdbcRollbackCount.addAndGet(rollbackCount);
    }

    public int getMaxStatUriCount() {
        return this.maxStatUriCount;
    }

    public void setMaxStatUriCount(int maxStatUriCount) {
        this.maxStatUriCount = maxStatUriCount;
    }

    public int getMaxStatSessionCount() {
        return this.maxStatSessionCount;
    }

    public void setMaxStatSessionCount(int maxStatSessionCount) {
        this.maxStatSessionCount = maxStatSessionCount;
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public long getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getRequestCount() {
        return this.requestCount.get();
    }

    public Map<String, Object> getStatData() {
        return this.getStatValue(false).getStatData();
    }

    public List<WebURIStatValue> getURIStatValueList(boolean reset) {
        ArrayList<WebURIStatValue> list = new ArrayList<WebURIStatValue>(this.uriStatMap.size());
        for (WebURIStat uriStat : this.uriStatMap.values()) {
            WebURIStatValue statValue = uriStat.getValue(reset);
            if (statValue.getRunningCount() == 0 && statValue.getRequestCount() == 0L) continue;
            list.add(statValue);
        }
        return list;
    }

    public List<Map<String, Object>> getURIStatDataList() {
        ArrayList<Map<String, Object>> uriStatDataList = new ArrayList<Map<String, Object>>(this.uriStatMap.size());
        for (WebURIStat uriStat : this.uriStatMap.values()) {
            Map<String, Object> uriStatData = uriStat.getStatData();
            int runningCount = ((Number)uriStatData.get("RunningCount")).intValue();
            long requestCount = (Long)uriStatData.get("RequestCount");
            if (runningCount == 0 && requestCount == 0L) continue;
            uriStatDataList.add(uriStatData);
        }
        return uriStatDataList;
    }

    public List<Map<String, Object>> getSessionStatDataList() {
        ArrayList<Map<String, Object>> sessionStatDataList = new ArrayList<Map<String, Object>>(this.sessionStatMap.size());
        for (WebSessionStat sessionStat : Collections.unmodifiableCollection(this.sessionStatMap.values())) {
            Map<String, Object> sessionStatData = sessionStat.getStatData();
            int runningCount = ((Number)sessionStatData.get("RunningCount")).intValue();
            long requestCount = (Long)sessionStatData.get("RequestCount");
            if (runningCount == 0 && requestCount == 0L) continue;
            sessionStatDataList.add(sessionStatData);
        }
        return sessionStatDataList;
    }

    public void computeUserAgent(String userAgent) {
        boolean isJava;
        boolean isOpera;
        int tmp;
        if (userAgent == null || userAgent.length() == 0) {
            return;
        }
        int MOZILLA_COMPATIBLE_OFFSET = 25;
        boolean is360SE = userAgent.endsWith("360SE)");
        if (is360SE) {
            this.browser360SECount.incrementAndGet();
        }
        boolean isIE = userAgent.startsWith("MSIE", 25);
        int iePrefixIndex = 30;
        boolean isGoogleToolbar = false;
        if (!isIE && (isGoogleToolbar = userAgent.startsWith("GoogleToolbar", 25)) && (tmp = userAgent.indexOf("IE ")) != -1) {
            isIE = true;
            iePrefixIndex = tmp + 3;
        }
        if (isIE) {
            this.browserIECount.incrementAndGet();
            int v1 = 32;
            int v2 = 32;
            if (userAgent.length() > iePrefixIndex + 1) {
                v1 = userAgent.charAt(iePrefixIndex);
                v2 = userAgent.charAt(iePrefixIndex + 1);
            } else if (userAgent.length() > iePrefixIndex) {
                v1 = userAgent.charAt(iePrefixIndex);
            }
            switch (v1) {
                case 53: {
                    this.browserIE5Count.incrementAndGet();
                    break;
                }
                case 54: {
                    this.browserIE6Count.incrementAndGet();
                    break;
                }
                case 55: {
                    this.browserIE7Count.incrementAndGet();
                    break;
                }
                case 56: {
                    this.browserIE8Count.incrementAndGet();
                    break;
                }
                case 57: {
                    this.browserIE9Count.incrementAndGet();
                    break;
                }
                case 49: {
                    if (v2 != 48) break;
                    this.browserIE10Count.incrementAndGet();
                    break;
                }
            }
            this.osWindowsCount.incrementAndGet();
            this.computeUserAgentIEWindowsVersion(userAgent);
            if (userAgent.indexOf("Windows Phone") != -1) {
                this.deviceWindowsPhoneCount.incrementAndGet();
            }
            return;
        }
        boolean isWindows = false;
        boolean isMac = false;
        boolean isIpad = false;
        boolean isIPhone = false;
        boolean isLinux = false;
        boolean isX11 = false;
        boolean isBSD = false;
        if (userAgent.startsWith("Windows", 13)) {
            isWindows = true;
        } else if (userAgent.startsWith("Macintosh", 13)) {
            isMac = true;
        } else if (userAgent.startsWith("iPad", 13)) {
            isIpad = true;
            isMac = true;
        } else if (userAgent.startsWith("iPhone", 13)) {
            isIPhone = true;
            isMac = true;
        } else if (userAgent.startsWith("Linux", 13)) {
            isLinux = true;
        } else if (userAgent.startsWith("X11", 13)) {
            isX11 = true;
        }
        boolean isAndroid = false;
        if (isWindows) {
            isWindows = true;
            this.osWindowsCount.incrementAndGet();
            if (userAgent.indexOf("Windows Phone") != -1) {
                this.deviceWindowsPhoneCount.incrementAndGet();
            }
        } else if (isMac) {
            isMac = true;
            this.osMacOSXCount.incrementAndGet();
            if (isIpad && userAgent.indexOf("iPad") != -1) {
                this.deviceIpadCount.incrementAndGet();
            } else if (isIPhone || userAgent.indexOf("iPhone") != -1) {
                this.deviceIphoneCount.incrementAndGet();
            }
        } else if (isLinux) {
            this.osLinuxCount.incrementAndGet();
            isAndroid = this.computeUserAgentAndroid(userAgent);
        } else if (userAgent.indexOf("Symbian") != -1) {
            this.osSymbianCount.incrementAndGet();
        } else if (userAgent.indexOf("Ubuntu") != -1) {
            this.osLinuxCount.incrementAndGet();
            this.osLinuxUbuntuCount.incrementAndGet();
            isLinux = true;
        }
        if (isX11) {
            if (userAgent.indexOf("OpenBSD") != -1) {
                this.osOpenBSDCount.incrementAndGet();
                isBSD = true;
            } else if (userAgent.indexOf("FreeBSD") != -1) {
                this.osFreeBSDCount.incrementAndGet();
                isBSD = true;
            } else if (!isLinux && userAgent.indexOf("Linux") != -1) {
                this.osLinuxCount.incrementAndGet();
                isLinux = true;
            }
        }
        if (isOpera = userAgent.startsWith("Opera")) {
            if (userAgent.indexOf("Windows") != -1) {
                this.osWindowsCount.incrementAndGet();
            } else if (userAgent.indexOf("Linux") != -1) {
                this.osWindowsCount.incrementAndGet();
            } else if (userAgent.indexOf("Macintosh") != -1) {
                this.osMacOSXCount.incrementAndGet();
            }
            this.browserOperaCount.incrementAndGet();
            return;
        }
        if (isWindows) {
            this.computeUserAgentFirefoxWindowsVersion(userAgent);
        }
        if (isWindows || isMac || isLinux || isBSD) {
            if (userAgent.indexOf("Chrome") != -1) {
                this.browserChromeCount.incrementAndGet();
                return;
            }
            if (!isAndroid && userAgent.indexOf("Safari") != -1) {
                this.browserSafariCount.incrementAndGet();
                return;
            }
            if (userAgent.indexOf("Firefox") != -1) {
                this.browserFirefoxCount.incrementAndGet();
                return;
            }
        }
        if (userAgent.startsWith("User-Agent: ")) {
            String rest = userAgent.substring("User-Agent: ".length());
            this.computeUserAgent(rest);
        }
        if (isJava = userAgent.startsWith("Java")) {
            this.botCount.incrementAndGet();
        }
        if (userAgent.startsWith("msnbot")) {
            this.botCount.incrementAndGet();
            this.botMsnCount.incrementAndGet();
        } else if (userAgent.startsWith("Sosospider+")) {
            this.botCount.incrementAndGet();
            this.botSosoCount.incrementAndGet();
        } else if (userAgent.startsWith("Sogou")) {
            this.botCount.incrementAndGet();
            this.botSogouCount.incrementAndGet();
        } else if (userAgent.startsWith("HuaweiSymantecSpider")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Yeti/")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("mahonie")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("findlinks")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Updownerbot")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("DoCoMo/")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Crawl")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("SkimBot")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("YoudaoBot", 25)) {
            this.botCount.incrementAndGet();
            this.botYoudaoCount.incrementAndGet();
        } else if (userAgent.startsWith("bingbot", 25)) {
            this.botCount.incrementAndGet();
            this.botBingCount.incrementAndGet();
        } else if (userAgent.startsWith("Googlebot", 25)) {
            this.botCount.incrementAndGet();
            this.botGoogleCount.incrementAndGet();
        } else if (userAgent.startsWith("Baiduspider", 25)) {
            this.botCount.incrementAndGet();
            this.botBaiduCount.incrementAndGet();
        } else if (userAgent.startsWith("MJ12bot", 25)) {
            this.botCount.incrementAndGet();
            this.botBaiduCount.incrementAndGet();
        } else if (userAgent.startsWith("Mail.RU/", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Yahoo!", 25)) {
            this.botCount.incrementAndGet();
            this.botYahooCount.incrementAndGet();
        } else if (userAgent.startsWith("KaloogaBot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("YandexBot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Ezooms/", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("Exabot/", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("AhrefsBot/", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("YodaoBot/", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("BeetleBot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("archive.org_bot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("aiHitBot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.startsWith("EventGuruBot", 25)) {
            this.botCount.incrementAndGet();
        } else if (userAgent.equals("Mozilla/5.0 ()")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.equals("\"Mozilla/5.0")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.equals("Mozilla")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.equals("-")) {
            this.botCount.incrementAndGet();
        } else if (userAgent.indexOf("Spider") != -1 || userAgent.indexOf("spider") != -1) {
            this.botCount.incrementAndGet();
        } else if (userAgent.indexOf("crawl") != -1 || userAgent.indexOf("Crawl") != -1) {
            this.botCount.incrementAndGet();
        } else if (userAgent.indexOf("Bot") != -1 || userAgent.indexOf("bot") != -1) {
            this.botCount.incrementAndGet();
        }
    }

    private void computeUserAgentFirefoxWindowsVersion(String userAgent) {
        if (userAgent.startsWith("Windows NT 5.1", 13)) {
            this.osWindowsXPCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 5.1", 25)) {
            this.osWindowsXPCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.0", 13)) {
            this.osWindowsVistaCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.1", 13)) {
            this.osWindows7Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.2", 13)) {
            this.osWindows8Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 5.0", 13)) {
            this.osWindows2000Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 5.0", 25)) {
            this.osWindows2000Count.incrementAndGet();
        }
    }

    private void computeUserAgentIEWindowsVersion(String userAgent) {
        if (userAgent.startsWith("Windows NT 5.1", 35)) {
            this.osWindowsXPCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 5.0", 35)) {
            this.osWindows2000Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 5.0", 36)) {
            this.osWindows2000Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.0", 35)) {
            this.osWindowsVistaCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.1", 35)) {
            this.osWindows7Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows NT 6.2", 36)) {
            this.osWindows8Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows 98", 36)) {
            this.osWindows98Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows 98", 35)) {
            this.osWindows98Count.incrementAndGet();
        } else if (userAgent.startsWith("Windows XP", 35)) {
            this.osWindowsXPCount.incrementAndGet();
        } else if (userAgent.startsWith("Windows XP", 34)) {
            this.osWindowsXPCount.incrementAndGet();
        }
    }

    private boolean computeUserAgentAndroid(String userAgent) {
        boolean isAndroid = userAgent.startsWith("Android", 23);
        int toffset = 31;
        if (!isAndroid) {
            isAndroid = userAgent.startsWith("Android", 20);
            toffset = 28;
        }
        if (isAndroid) {
            this.osAndroidCount.incrementAndGet();
            this.deviceAndroidCount.incrementAndGet();
            if (userAgent.startsWith("1.5", toffset)) {
                this.osAndroid15Count.incrementAndGet();
            } else if (userAgent.startsWith("1.6", toffset)) {
                this.osAndroid16Count.incrementAndGet();
            } else if (userAgent.startsWith("2.0", toffset)) {
                this.osAndroid20Count.incrementAndGet();
            } else if (userAgent.startsWith("2.1", toffset)) {
                this.osAndroid21Count.incrementAndGet();
            } else if (userAgent.startsWith("2.2", toffset)) {
                this.osAndroid22Count.incrementAndGet();
            } else if (userAgent.startsWith("2.3.3", toffset)) {
                this.osAndroid23Count.incrementAndGet();
            } else if (userAgent.startsWith("2.3.4", toffset)) {
                this.osAndroid23Count.incrementAndGet();
            } else if (userAgent.startsWith("3.0", toffset)) {
                this.osAndroid30Count.incrementAndGet();
            } else if (userAgent.startsWith("3.1", toffset)) {
                this.osAndroid31Count.incrementAndGet();
            } else if (userAgent.startsWith("3.2", toffset)) {
                this.osAndroid32Count.incrementAndGet();
            } else if (userAgent.startsWith("4.0", toffset)) {
                this.osAndroid40Count.incrementAndGet();
            } else if (userAgent.startsWith("4.1", toffset)) {
                this.osAndroid41Count.incrementAndGet();
            } else if (userAgent.startsWith("4.2", toffset)) {
                this.osAndroid42Count.incrementAndGet();
            } else if (userAgent.startsWith("4.3", toffset)) {
                this.osAndroid43Count.incrementAndGet();
            }
            return true;
        }
        return false;
    }

    public long getOSMacOSXCount() {
        return this.osMacOSXCount.get();
    }

    public long getOSWindowsCount() {
        return this.osWindowsCount.get();
    }

    public long getOSLinuxCount() {
        return this.osLinuxCount.get();
    }

    public long getOSSymbianCount() {
        return this.osSymbianCount.get();
    }

    public long getOSFreeBSDCount() {
        return this.osFreeBSDCount.get();
    }

    public long getOSOpenBSDCount() {
        return this.osOpenBSDCount.get();
    }

    public long getOSAndroidCount() {
        return this.osAndroidCount.get();
    }

    public long getOSWindows98Count() {
        return this.osWindows98Count.get();
    }

    public long getOSWindowsXPCount() {
        return this.osWindowsXPCount.get();
    }

    public long getOSWindows2000Count() {
        return this.osWindows2000Count.get();
    }

    public long getOSWindowsVistaCount() {
        return this.osWindowsVistaCount.get();
    }

    public long getOSWindows7Count() {
        return this.osWindows7Count.get();
    }

    public long getOSWindows8Count() {
        return this.osWindows8Count.get();
    }

    public long getOSAndroid15Count() {
        return this.osAndroid15Count.get();
    }

    public long getOSAndroid16Count() {
        return this.osAndroid16Count.get();
    }

    public long getOSAndroid20Count() {
        return this.osAndroid20Count.get();
    }

    public long getOSAndroid21Count() {
        return this.osAndroid21Count.get();
    }

    public long getOSAndroid22Count() {
        return this.osAndroid22Count.get();
    }

    public long getOSAndroid23Count() {
        return this.osAndroid23Count.get();
    }

    public long getOSAndroid30Count() {
        return this.osAndroid30Count.get();
    }

    public long getOSAndroid31Count() {
        return this.osAndroid31Count.get();
    }

    public long getOSAndroid32Count() {
        return this.osAndroid32Count.get();
    }

    public long getOSAndroid40Count() {
        return this.osAndroid40Count.get();
    }

    public long getOSAndroid41Count() {
        return this.osAndroid41Count.get();
    }

    public long getOSAndroid42Count() {
        return this.osAndroid42Count.get();
    }

    public long getOSAndroid43Count() {
        return this.osAndroid43Count.get();
    }

    public long getOSLinuxUbuntuCount() {
        return this.osLinuxUbuntuCount.get();
    }

    public long getBrowserIECount() {
        return this.browserIECount.get();
    }

    public long getBrowserFirefoxCount() {
        return this.browserFirefoxCount.get();
    }

    public long getBrowserChromeCount() {
        return this.browserChromeCount.get();
    }

    public long getBrowserSafariCount() {
        return this.browserSafariCount.get();
    }

    public long getBrowserOperaCount() {
        return this.browserOperaCount.get();
    }

    public long getBrowserIE5Count() {
        return this.browserIE5Count.get();
    }

    public long getBrowserIE6Count() {
        return this.browserIE6Count.get();
    }

    public long getBrowserIE7Count() {
        return this.browserIE7Count.get();
    }

    public long getBrowserIE8Count() {
        return this.browserIE8Count.get();
    }

    public long getBrowserIE9Count() {
        return this.browserIE9Count.get();
    }

    public long getBrowserIE10Count() {
        return this.browserIE10Count.get();
    }

    public long getBrowser360SECount() {
        return this.browser360SECount.get();
    }

    public long getDeviceAndroidCount() {
        return this.deviceAndroidCount.get();
    }

    public long getDeviceIpadCount() {
        return this.deviceIpadCount.get();
    }

    public long getDeviceIphoneCount() {
        return this.deviceIphoneCount.get();
    }

    public long getDeviceWindowsPhoneCount() {
        return this.deviceWindowsPhoneCount.get();
    }

    public long getBotCount() {
        return this.botCount.get();
    }

    public long getBotBaiduCount() {
        return this.botBaiduCount.get();
    }

    public long getBotYoudaoCount() {
        return this.botYoudaoCount.get();
    }

    public long getBotGoogleCount() {
        return this.botGoogleCount.get();
    }

    public long getBotMsnCount() {
        return this.botMsnCount.get();
    }

    public long getBotBingCount() {
        return this.botBingCount.get();
    }

    public long getBotSosoCount() {
        return this.botSosoCount.get();
    }

    public long getBotSogouCount() {
        return this.botSogouCount.get();
    }

    public long getBotYahooCount() {
        return this.botYahooCount.get();
    }

    public WebAppStatValue getStatValue(boolean reset) {
        WebAppStatValue val = new WebAppStatValue();
        val.setContextPath(this.contextPath);
        val.setRunningCount(this.getRunningCount());
        val.concurrentMax = JdbcSqlStatUtils.get(this.concurrentMax, reset);
        val.requestCount = JdbcSqlStatUtils.get(this.requestCount, reset);
        val.sessionCount = JdbcSqlStatUtils.get(this.sessionCount, reset);
        val.jdbcFetchRowCount = JdbcSqlStatUtils.get(this.jdbcFetchRowCount, reset);
        val.jdbcUpdateCount = JdbcSqlStatUtils.get(this.jdbcUpdateCount, reset);
        val.jdbcExecuteCount = JdbcSqlStatUtils.get(this.jdbcExecuteCount, reset);
        val.jdbcExecuteTimeNano = JdbcSqlStatUtils.get(this.jdbcExecuteTimeNano, reset);
        val.jdbcCommitCount = JdbcSqlStatUtils.get(this.jdbcCommitCount, reset);
        val.jdbcRollbackCount = JdbcSqlStatUtils.get(this.jdbcRollbackCount, reset);
        val.osMacOSXCount = JdbcSqlStatUtils.get(this.osMacOSXCount, reset);
        val.osWindowsCount = JdbcSqlStatUtils.get(this.osWindowsCount, reset);
        val.osLinuxCount = JdbcSqlStatUtils.get(this.osLinuxCount, reset);
        val.osSymbianCount = JdbcSqlStatUtils.get(this.osSymbianCount, reset);
        val.osFreeBSDCount = JdbcSqlStatUtils.get(this.osFreeBSDCount, reset);
        val.osOpenBSDCount = JdbcSqlStatUtils.get(this.osOpenBSDCount, reset);
        val.osAndroidCount = JdbcSqlStatUtils.get(this.osAndroidCount, reset);
        val.osWindows98Count = JdbcSqlStatUtils.get(this.osWindows98Count, reset);
        val.osWindowsXPCount = JdbcSqlStatUtils.get(this.osWindowsXPCount, reset);
        val.osWindows2000Count = JdbcSqlStatUtils.get(this.osWindows2000Count, reset);
        val.osWindowsVistaCount = JdbcSqlStatUtils.get(this.osWindowsVistaCount, reset);
        val.osWindows7Count = JdbcSqlStatUtils.get(this.osWindows7Count, reset);
        val.osWindows8Count = JdbcSqlStatUtils.get(this.osWindows8Count, reset);
        val.osAndroid15Count = JdbcSqlStatUtils.get(this.osAndroid15Count, reset);
        val.osAndroid16Count = JdbcSqlStatUtils.get(this.osAndroid16Count, reset);
        val.osAndroid20Count = JdbcSqlStatUtils.get(this.osAndroid20Count, reset);
        val.osAndroid21Count = JdbcSqlStatUtils.get(this.osAndroid21Count, reset);
        val.osAndroid22Count = JdbcSqlStatUtils.get(this.osAndroid22Count, reset);
        val.osAndroid23Count = JdbcSqlStatUtils.get(this.osAndroid23Count, reset);
        val.osAndroid30Count = JdbcSqlStatUtils.get(this.osAndroid30Count, reset);
        val.osAndroid31Count = JdbcSqlStatUtils.get(this.osAndroid31Count, reset);
        val.osAndroid32Count = JdbcSqlStatUtils.get(this.osAndroid32Count, reset);
        val.osAndroid40Count = JdbcSqlStatUtils.get(this.osAndroid40Count, reset);
        val.osAndroid41Count = JdbcSqlStatUtils.get(this.osAndroid41Count, reset);
        val.osAndroid42Count = JdbcSqlStatUtils.get(this.osAndroid42Count, reset);
        val.osAndroid43Count = JdbcSqlStatUtils.get(this.osAndroid43Count, reset);
        val.osLinuxUbuntuCount = JdbcSqlStatUtils.get(this.osLinuxUbuntuCount, reset);
        val.browserIECount = JdbcSqlStatUtils.get(this.browserIECount, reset);
        val.browserFirefoxCount = JdbcSqlStatUtils.get(this.browserFirefoxCount, reset);
        val.browserChromeCount = JdbcSqlStatUtils.get(this.browserChromeCount, reset);
        val.browserSafariCount = JdbcSqlStatUtils.get(this.browserSafariCount, reset);
        val.browserOperaCount = JdbcSqlStatUtils.get(this.browserOperaCount, reset);
        val.browserIE5Count = JdbcSqlStatUtils.get(this.browserIE5Count, reset);
        val.browserIE6Count = JdbcSqlStatUtils.get(this.browserIE6Count, reset);
        val.browserIE7Count = JdbcSqlStatUtils.get(this.browserIE7Count, reset);
        val.browserIE8Count = JdbcSqlStatUtils.get(this.browserIE8Count, reset);
        val.browserIE9Count = JdbcSqlStatUtils.get(this.browserIE9Count, reset);
        val.browserIE10Count = JdbcSqlStatUtils.get(this.browserIE10Count, reset);
        val.browser360SECount = JdbcSqlStatUtils.get(this.browser360SECount, reset);
        val.deviceAndroidCount = JdbcSqlStatUtils.get(this.deviceAndroidCount, reset);
        val.deviceIpadCount = JdbcSqlStatUtils.get(this.deviceIpadCount, reset);
        val.deviceIphoneCount = JdbcSqlStatUtils.get(this.deviceIphoneCount, reset);
        val.deviceWindowsPhoneCount = JdbcSqlStatUtils.get(this.deviceWindowsPhoneCount, reset);
        val.botCount = JdbcSqlStatUtils.get(this.botCount, reset);
        val.botBaiduCount = JdbcSqlStatUtils.get(this.botBaiduCount, reset);
        val.botYoudaoCount = JdbcSqlStatUtils.get(this.botYoudaoCount, reset);
        val.botGoogleCount = JdbcSqlStatUtils.get(this.botGoogleCount, reset);
        val.botMsnCount = JdbcSqlStatUtils.get(this.botMsnCount, reset);
        val.botBingCount = JdbcSqlStatUtils.get(this.botBingCount, reset);
        val.botSosoCount = JdbcSqlStatUtils.get(this.botSosoCount, reset);
        val.botSogouCount = JdbcSqlStatUtils.get(this.botSogouCount, reset);
        val.botYahooCount = JdbcSqlStatUtils.get(this.botYahooCount, reset);
        return val;
    }
}

