/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.utils;

import com.taobao.spas.sdk.common.config.SpasConfigLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpasHttpClient {
    private static int CONN_TIMEOUT_DEFAULT = 3000;
    private static int READ_TIMEOUT_DEFAULT = 10000;
    private static int connTimeout = CONN_TIMEOUT_DEFAULT;
    private static int readTimeout = READ_TIMEOUT_DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPostJson(String url, Map<String, String> properties, String content, String charset) throws IOException {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes());
            out.flush();
            int respCode = conn.getResponseCode();
            InputStream in = respCode >= 200 && respCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            StringBuilder sb = new StringBuilder("");
            if (in != null) {
                String line;
                reader = new BufferedReader(new InputStreamReader(in, charset));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            HttpResult httpResult = new HttpResult(respCode, sb.toString());
            return httpResult;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    static {
        connTimeout = Integer.valueOf(SpasConfigLoader.getProperty("spas.http.conn.timeout", String.valueOf(CONN_TIMEOUT_DEFAULT)));
        readTimeout = Integer.valueOf(SpasConfigLoader.getProperty("spas.http.read.timeout", String.valueOf(READ_TIMEOUT_DEFAULT)));
    }

    public static class HttpResult {
        public final int code;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }
}

