/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.sec;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DESedeUtils {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final String ALGORITHM = "DESede";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private Cipher cipher = null;
    private int opmode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init(int mode, String key) {
        Key secKey;
        block13: {
            if (this.opmode != 0) {
                return true;
            }
            if (mode != 1 && mode != 2) {
                return false;
            }
            if (key == null || key.isEmpty()) {
                return false;
            }
            try {
                this.cipher = Cipher.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (NoSuchPaddingException e) {
                e.printStackTrace();
            }
            finally {
                if (this.cipher != null) break block13;
                return false;
            }
        }
        if ((secKey = DESedeUtils.getSecKey(key)) == null) {
            return false;
        }
        try {
            this.cipher.init(mode, secKey, new SecureRandom());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return false;
        }
        this.opmode = mode;
        return true;
    }

    private static Key getSecKey(String key) {
        SecretKey securekey = null;
        try {
            byte[] material = Arrays.copyOf(Base64.decodeBase64((byte[])key.getBytes(UTF8)), 24);
            DESedeKeySpec keySpec = new DESedeKeySpec(material);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            securekey = keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return securekey;
    }

    public synchronized String encrypt(String data) {
        if (this.opmode != 1) {
            return null;
        }
        if (data == null) {
            return null;
        }
        byte[] encData = null;
        try {
            encData = this.cipher.doFinal(data.getBytes(UTF8));
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        if (encData == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])encData), UTF8);
    }

    public synchronized String decrypt(String data) {
        if (this.opmode != 2) {
            return null;
        }
        if (data == null) {
            return null;
        }
        byte[] decData = null;
        try {
            decData = this.cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes(UTF8)));
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        if (decData == null) {
            return null;
        }
        return new String(decData, UTF8);
    }
}

