/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.config;

import com.taobao.spas.sdk.common.log.SpasLogCode;
import com.taobao.spas.sdk.common.log.SpasLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SpasConfigLoader {
    private static final String CONFIG_PATH = "/home/admin/spas_conf/global";
    private static final String APP_CONFIG_FORMAT = "spas_app_config_%s.%s";
    private static Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static ConcurrentHashMap<String, Map<String, String>> appProperties = new ConcurrentHashMap();

    public static void init() {
    }

    public static String getProperty(String key) {
        String value = properties.get(key);
        if (value == null && (value = System.getProperty(key)) != null) {
            properties.put(key, value);
        }
        return value;
    }

    public static String getProperty(String key, String def) {
        String value = SpasConfigLoader.getProperty(key);
        return value != null ? value : def;
    }

    public static String getAppProperty(String appName, String key) {
        String value;
        if (appName == null) {
            return SpasConfigLoader.getProperty(key);
        }
        Map<String, String> props = appProperties.get(appName);
        String string = value = props != null ? props.get(key) : null;
        if (value == null) {
            value = System.getProperty(String.format(APP_CONFIG_FORMAT, appName, key));
            if (value != null) {
                SpasConfigLoader.setAppProperty(appName, key, value);
            } else {
                value = SpasConfigLoader.getProperty(key);
            }
        }
        return value;
    }

    public static String getAppProperty(String appName, String key, String def) {
        String value = SpasConfigLoader.getAppProperty(appName, key);
        return value != null ? value : def;
    }

    public static void setProperty(String key, String value) {
        properties.put(key, value);
    }

    public static void setAppProperty(String appName, String key, String value) {
        Map<String, String> old;
        Map<String, String> props = appProperties.get(appName);
        if (props == null && (old = appProperties.putIfAbsent(appName, props = new ConcurrentHashMap<String, String>())) != null) {
            props = old;
        }
        props.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean disabled = "Y".equalsIgnoreCase(System.getProperty("spas.config.disable"));
        if (!disabled) {
            Properties properties = new Properties();
            FileInputStream globalConfigIS = null;
            try {
                globalConfigIS = new FileInputStream(CONFIG_PATH);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (globalConfigIS != null) {
                try {
                    properties.load(globalConfigIS);
                }
                catch (IOException e) {
                    SpasLogger.error(SpasLogCode.SPAS0105, "Unable to load properties from /home/admin/spas_conf/global:" + e.getMessage());
                }
                finally {
                    try {
                        globalConfigIS.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                Properties currentProperties = System.getProperties();
                Object old = currentProperties.get(property.getKey());
                if (old != null) continue;
                System.setProperty(property.getKey().toString(), property.getValue().toString());
                SpasLogger.info("Set property " + property.getKey() + "=" + property.getValue());
            }
        }
    }
}

