/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.client.identity;

import com.taobao.spas.sdk.client.CredentialListener;
import com.taobao.spas.sdk.client.identity.CredentialWatcher;
import com.taobao.spas.sdk.client.identity.Credentials;
import com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.taobao.spas.sdk.common.identity.SpasCredentialLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class CredentialService
implements SpasCredentialLoader {
    private static ConcurrentHashMap<String, CredentialService> instances = new ConcurrentHashMap();
    private Credentials credentials = new Credentials();
    private CredentialWatcher watcher;
    private CredentialListener listener;

    private CredentialService(String appName) {
        if (appName == null) {
            appName = SpasConfigLoader.getProperty("project.name");
        }
        this.watcher = new CredentialWatcher(appName, this);
    }

    public static CredentialService getInstance() {
        return CredentialService.getInstance(null);
    }

    public static CredentialService getInstance(String appName) {
        CredentialService previous;
        String key = appName != null ? appName : "";
        CredentialService instance = instances.get(key);
        if (instance == null && (previous = instances.putIfAbsent(key, instance = new CredentialService(appName))) != null) {
            instance = previous;
        }
        return instance;
    }

    public Credentials getCredential() {
        Credentials localCredential = this.credentials;
        if (localCredential.valid()) {
            return localCredential;
        }
        return this.credentials;
    }

    public void setCredential(Credentials credential) {
        boolean changed = this.credentials != credential && (this.credentials == null || !this.credentials.identical(credential));
        this.credentials = credential;
        if (changed && this.listener != null) {
            this.listener.onUpdateCredential();
        }
    }

    public void registerCredentialListener(CredentialListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void setAccessKey(String accessKey) {
        this.credentials.setAccessKey(accessKey);
    }

    @Deprecated
    public void setSecretKey(String secretKey) {
        this.credentials.setSecretKey(secretKey);
    }

    @Deprecated
    public String getAccessKey() {
        return this.credentials.getAccessKey();
    }

    @Deprecated
    public String getSecretKey() {
        return this.credentials.getSecretKey();
    }
}

