/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.githubreleases4j;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class GithubUser {
    @NotNull
    private final JSONObject contents;

    protected static GithubUser of(@NotNull JSONObject contents) {
        return new GithubUser(contents);
    }

    private GithubUser(@NotNull JSONObject contents) {
        this.contents = contents;
    }

    @NotNull
    protected JSONObject getContents() {
        return this.contents;
    }

    public int getID() {
        return this.getContents().getInt("id");
    }

    @NotNull
    public String getLoginID() {
        return this.getContents().getString("login");
    }

    @NotNull
    public String getNodeID() {
        return this.getContents().getString("node_id");
    }

    @Nullable
    public String getAvatarURL() {
        return this.getContents().getString("avatar_url");
    }

    @Nullable
    public String getGravatarID() {
        return this.getContents().getString("gravatar_id");
    }

    @NotNull
    public String getURL() {
        return this.getContents().getString("url");
    }

    @NotNull
    public String getProfileURL() {
        return this.getContents().getString("html_url");
    }

    @NotNull
    public String getFollowersURL() {
        return this.getContents().getString("followers_url");
    }

    @NotNull
    public String getFollowingURL() {
        return this.getContents().getString("following_url");
    }

    @NotNull
    public String getFollowingURL(@NotNull String otherUsername) {
        return this.getFollowingURL().replace("{/other_user}", "/" + otherUsername);
    }

    @NotNull
    public String getGistsURL() {
        return this.getContents().getString("gists_url");
    }

    @NotNull
    public String getGistsURL(int gistID) {
        return this.getGistsURL().replace("{/gist_id}", "/" + gistID);
    }

    @NotNull
    public String getStarredURL() {
        return this.getContents().getString("starred_url");
    }

    @NotNull
    public String getStarredURL(@NotNull String owner, @NotNull String repo) {
        return this.getStarredURL().replace("{/owner}{/repo}", "/" + owner + "/" + repo);
    }

    @NotNull
    public String getSubscriptionsURL() {
        return this.getContents().getString("subscriptions_url");
    }

    @NotNull
    public String getOrganizationsURL() {
        return this.getContents().getString("organizations_url");
    }

    @NotNull
    public String getReposURL() {
        return this.getContents().getString("repos_url");
    }

    @NotNull
    public String getEventsURL() {
        return this.getContents().getString("events_url");
    }

    @NotNull
    public String getEventsURL(String privacy) {
        return this.getEventsURL().replace("{/privacy}", "/" + privacy);
    }

    @NotNull
    public String getReceivedEventsURL() {
        return this.getContents().getString("received_events_url");
    }

    @NotNull
    public String getType() {
        return this.getContents().getString("type");
    }

    public boolean isSiteAdmin() {
        return this.getContents().getBoolean("site_admin");
    }

    public String toString() {
        return this.getContents().toString();
    }
}

