/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.githubreleases4j;

import cc.carm.lib.githubreleases4j.GitHubHttpUtils;
import cc.carm.lib.githubreleases4j.GithubRelease;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class GithubReleases4J {
    public static String GITHUB_URL = "https://github.com";
    public static String GITHUB_API_URL = "https://api.github.com";
    public static SimpleDateFormat GH_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private GithubReleases4J() {
    }

    @NotNull
    public static List<GithubRelease> listReleases(@NotNull String owner, @NotNull String repository, @Nullable String token) {
        try {
            JSONArray releasesArray = GitHubHttpUtils.getArray(GithubReleases4J.buildURL("%s/repos/%s/%s/releases", GITHUB_API_URL, owner, repository), token);
            return IntStream.range(0, releasesArray.length()).mapToObj(releasesArray::getJSONObject).map(releaseJSON -> GithubRelease.of(owner, repository, token, releaseJSON)).collect(Collectors.toList());
        }
        catch (IOException e) {
            return new ArrayList<GithubRelease>();
        }
    }

    @NotNull
    public static List<GithubRelease> listReleases(@NotNull String owner, @NotNull String repository) {
        return GithubReleases4J.listReleases(owner, repository, null);
    }

    @Nullable
    public static GithubRelease getRelease(@NotNull String owner, @NotNull String repository, @NotNull String releaseID, @Nullable String token) {
        try {
            JSONObject releaseJSON = GitHubHttpUtils.getObject(GithubReleases4J.buildURL("%s/repos/%s/%s/releases/%s", GITHUB_API_URL, owner, repository, releaseID), token);
            return GithubRelease.of(owner, repository, token, releaseJSON);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static GithubRelease getRelease(@NotNull String owner, @NotNull String repository, @NotNull String releaseID) {
        return GithubReleases4J.getRelease(owner, repository, releaseID, null);
    }

    @Nullable
    public static GithubRelease getReleaseByTag(@NotNull String owner, @NotNull String repository, @NotNull String tagName, @Nullable String token) {
        return GithubReleases4J.getRelease(owner, repository, "tags/" + tagName, token);
    }

    @Nullable
    public static GithubRelease getReleaseByTag(@NotNull String owner, @NotNull String repository, @NotNull String tagName) {
        return GithubReleases4J.getReleaseByTag(owner, repository, tagName, null);
    }

    @Nullable
    public static GithubRelease getLatestRelease(@NotNull String owner, @NotNull String repository, @Nullable String token) {
        return GithubReleases4J.getRelease(owner, repository, "latest", token);
    }

    @Nullable
    public static GithubRelease getLatestRelease(@NotNull String owner, @NotNull String repository) {
        return GithubReleases4J.getLatestRelease(owner, repository, null);
    }

    @Nullable
    public static Integer getVersionBehind(@NotNull String owner, @NotNull String repository, @Nullable String token, @NotNull String currentTagName) {
        List<GithubRelease> releases = GithubReleases4J.listReleases(owner, repository, token);
        if (releases.isEmpty()) {
            return null;
        }
        int i = 0;
        for (GithubRelease release : releases) {
            if (release.getTagName().equalsIgnoreCase(currentTagName)) break;
            ++i;
        }
        if (i == releases.size()) {
            return -1;
        }
        return i;
    }

    @Nullable
    public static Integer getVersionBehind(@NotNull String owner, @NotNull String repository, @NotNull String currentTagName) {
        return GithubReleases4J.getVersionBehind(owner, repository, null, currentTagName);
    }

    @NotNull
    public static String getReleasesURL(@NotNull String owner, @NotNull String repository) {
        return GithubReleases4J.buildURL("%s/%s/%s/releases", GITHUB_URL, owner, repository);
    }

    @NotNull
    public static String getLatestReleaseURL(@NotNull String owner, @NotNull String repository) {
        return GithubReleases4J.getReleasesURL(owner, repository) + "/latest";
    }

    @NotNull
    public static String getReleaseURLByTag(@NotNull String owner, @NotNull String repository, @NotNull String releaseTagName) {
        return GithubReleases4J.getReleasesURL(owner, repository) + "/tag/" + releaseTagName;
    }

    private static String buildURL(@NotNull String url, Object ... params) {
        return String.format(url, params);
    }

    @Contract(value="null->null")
    @Nullable
    protected static Date parseDate(@Nullable String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return GH_TIME_FORMAT.parse(dateString);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

