/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.web.filter;

import com.ifourthwall.web.security.shiro.AuthToken;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.dao.InvalidResourceUsageException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuthFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(ShiroAuthFilter.class);

    public String getAuthcScheme() {
        return "";
    }

    public String getAuthzScheme() {
        return "";
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthToken authToken = new AuthToken(((HttpServletRequest)request).getHeader("Authorization"), ((HttpServletRequest)request).getRequestURI());
        try {
            this.getSubject(request, response).login((AuthenticationToken)authToken);
        }
        catch (AuthenticationException e) {
            HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
            if (StringUtils.equals((CharSequence)((Object)((Object)e)).getClass().getName(), (CharSequence)IncorrectCredentialsException.class.getName()) || e.getCause() != null && StringUtils.equals((CharSequence)e.getCause().getClass().getName(), (CharSequence)IncorrectCredentialsException.class.getName())) {
                log.debug("Authentication required: sending 401 Authentication challenge response.");
                httpResponse.setStatus(401);
            } else if (StringUtils.equals((CharSequence)((Object)((Object)e)).getClass().getName(), (CharSequence)InvalidResourceUsageException.class.getName()) || e.getCause() != null && StringUtils.equals((CharSequence)e.getCause().getClass().getName(), (CharSequence)InvalidResourceUsageException.class.getName())) {
                httpResponse.setStatus(403);
            } else {
                log.error("SHIRO\u62e6\u622a\u672a\u77e5\u9519\u8bef", (Throwable)e);
                httpResponse.setStatus(400);
            }
            String authcHeader = this.getAuthcScheme() + " realm=\"" + this.getApplicationName() + "\"";
            httpResponse.setHeader("WWW-Authenticate", authcHeader);
            return false;
        }
        return true;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return super.isAccessAllowed(request, response, mappedValue);
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return super.isLoginAttempt(request, response);
    }

    protected boolean sendChallenge(ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        if (httpResponse.getStatus() < 0) {
            httpResponse.setStatus(401);
            String authcHeader = this.getAuthcScheme() + " realm=\"" + this.getApplicationName() + "\"";
            httpResponse.setHeader("WWW-Authenticate", authcHeader);
        }
        return false;
    }
}

