/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.web;

import com.ifourthwall.common.CacheKeyDecorator;
import com.ifourthwall.common.base.provider.IFWProviderUser;
import com.ifourthwall.common.security.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ProviderArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(ProviderArgumentResolver.class);
    private RedisTemplate redisTemplate;

    public ProviderArgumentResolver(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        log.info("enter supportsParameter..");
        return parameter.getParameterType().equals(IFWProviderUser.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String origToken = servletRequest.getHeader("Authorization");
        String token = TokenUtils.getTokenFromBasicToken((String)origToken);
        IFWProviderUser userInfo = (IFWProviderUser)this.redisTemplate.opsForValue().get((Object)CacheKeyDecorator.getProviderUserInfoKey((String)token));
        if (userInfo != null) {
            return userInfo;
        }
        log.warn("\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6provicer\u7528\u6237\u4fe1\u606f,token: {}", (Object)token);
        return new IFWProviderUser();
    }
}

