/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.oss.minio.config;

import com.ifourthwall.oss.core.OSSOperator;
import com.ifourthwall.oss.minio.MinioOSSOperator;
import com.ifourthwall.oss.minio.config.MinioOSSProperties;
import io.minio.MinioClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ifw.oss.minio.config", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={MinioOSSProperties.class})
public class MinioOSSConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OSSOperator.class})
    public OSSOperator ossOperator(MinioOSSProperties minioOSSProperties) {
        MinioClient minioClient = MinioClient.builder().endpoint(minioOSSProperties.getEndpoint()).credentials(minioOSSProperties.getAccessKey(), minioOSSProperties.getSecretKey()).build();
        return new MinioOSSOperator(minioClient, minioOSSProperties);
    }
}

