/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.oss.aliyun;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.ifourthwall.oss.aliyun.config.AliyunOSSProperties;
import com.ifourthwall.oss.core.OSSOperator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliyunOperator
implements OSSOperator {
    private static final Logger log = LoggerFactory.getLogger(AliyunOperator.class);
    private OSS ossClient;
    private AliyunOSSProperties aliyunOSSProperties;

    public boolean uploadFile(MultipartFile multipartFile, String objectPath) {
        boolean responseResult = false;
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunOSSProperties.getBucketName(), objectPath, (InputStream)new ByteArrayInputStream(multipartFile.getBytes()));
            this.ossClient.putObject(putObjectRequest);
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("uoloadFile success");
        return responseResult;
    }

    public OSS getOssClient() {
        OSS ossClientSTS = null;
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)"Sts", (String)this.aliyunOSSProperties.getStsEndpoint());
            DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)this.aliyunOSSProperties.getAccessKeyId(), (String)this.aliyunOSSProperties.getAccessKeySecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(this.aliyunOSSProperties.getRoleArn());
            request.setRoleSessionName(this.aliyunOSSProperties.getRoleSessionName());
            request.setPolicy(this.aliyunOSSProperties.getPolicy());
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            String stsAccessKeyId = response.getCredentials().getAccessKeyId();
            String stsAccessKeySecret = response.getCredentials().getAccessKeySecret();
            String stsSecurityToken = response.getCredentials().getSecurityToken();
            ossClientSTS = new OSSClientBuilder().build(this.aliyunOSSProperties.getEndpoint(), stsAccessKeyId, stsAccessKeySecret, stsSecurityToken);
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return ossClientSTS;
    }

    public String downloadFile(String objectPath) {
        String responseResult = null;
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)"Sts", (String)this.aliyunOSSProperties.getStsEndpoint());
            DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)this.aliyunOSSProperties.getAccessKeyId(), (String)this.aliyunOSSProperties.getAccessKeySecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(this.aliyunOSSProperties.getRoleArn());
            request.setRoleSessionName(this.aliyunOSSProperties.getRoleSessionName());
            request.setPolicy(this.aliyunOSSProperties.getPolicy());
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            String stsAccessKeyId = response.getCredentials().getAccessKeyId();
            String stsAccessKeySecret = response.getCredentials().getAccessKeySecret();
            String stsSecurityToken = response.getCredentials().getSecurityToken();
            OSS ossClientSTS = new OSSClientBuilder().build(this.aliyunOSSProperties.getEndpoint(), stsAccessKeyId, stsAccessKeySecret, stsSecurityToken);
            String exprationProperty = this.aliyunOSSProperties.getExpiration();
            Date expiration = new Date(System.currentTimeMillis() + (long)Integer.parseInt(exprationProperty) * 1000L);
            URL url = ossClientSTS.generatePresignedUrl(this.aliyunOSSProperties.getBucketName(), objectPath, expiration);
            responseResult = url.toString();
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        log.info("Aliyun_OSS_downloadFile_success");
        return responseResult;
    }

    public boolean removeFile(List<String> objectPaths) {
        boolean responseResult = false;
        try {
            this.ossClient.deleteObjects(new DeleteObjectsRequest(this.aliyunOSSProperties.getBucketName()).withKeys(objectPaths));
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        log.info("Aliyun_OSS_removeFile_success");
        return responseResult;
    }

    public boolean createDir(String objectPath) {
        boolean responseResult = false;
        try {
            String content = "";
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunOSSProperties.getBucketName(), objectPath, (InputStream)new ByteArrayInputStream(content.getBytes()));
            this.ossClient.putObject(putObjectRequest);
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        log.info("Aliyun_OSS_removeFile_success");
        return responseResult;
    }

    public List<Map<String, Object>> getListObject(String objectPath, String marker) {
        ArrayList<Map<String, Object>> responseResult = new ArrayList<Map<String, Object>>();
        try {
            HashMap<String, Object> itemMap;
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.aliyunOSSProperties.getBucketName());
            listObjectsRequest.setPrefix(objectPath);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setMaxKeys(Integer.valueOf(200));
            if (!StringUtils.isBlank((CharSequence)marker)) {
                listObjectsRequest.setMarker(marker);
            }
            ObjectListing objectListing = this.ossClient.listObjects(listObjectsRequest);
            List objectSummaries = objectListing.getObjectSummaries();
            List commonPrefixes = objectListing.getCommonPrefixes();
            String nextMarker = objectListing.getNextMarker();
            if (!CollectionUtils.isEmpty((Collection)commonPrefixes)) {
                for (String item : commonPrefixes) {
                    itemMap = new HashMap<String, Object>();
                    itemMap.put("objectName", item);
                    itemMap.put("objectType", "1");
                    itemMap.put("objectSize", null);
                    itemMap.put("objectLastModified", null);
                    itemMap.put("objectUrl", null);
                    responseResult.add(itemMap);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)objectSummaries)) {
                for (String item : objectSummaries) {
                    itemMap = new HashMap();
                    itemMap.put("objectName", item.getKey());
                    itemMap.put("objectType", "2");
                    itemMap.put("objectSize", item.getSize());
                    itemMap.put("objectLastModified", item.getLastModified());
                    itemMap.put("objectUrl", "https://" + this.aliyunOSSProperties.getBucketName() + ".oss-cn-shanghai.aliyuncs.com/" + item.getKey());
                    responseResult.add(itemMap);
                }
            }
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        log.info("Aliyun_OSS_removeFile_success");
        return responseResult;
    }

    public boolean removeDir(String objectPath) {
        boolean responseResult = false;
        try {
            String nextMarker = null;
            ObjectListing objectListing = null;
            do {
                ListObjectsRequest listObjectsRequest;
                if ((objectListing = this.ossClient.listObjects(listObjectsRequest = new ListObjectsRequest(this.aliyunOSSProperties.getBucketName()).withPrefix(objectPath).withMarker(nextMarker))).getObjectSummaries().size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>();
                    for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                        keys.add(s.getKey());
                    }
                    DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.aliyunOSSProperties.getBucketName()).withKeys(keys).withEncodingType("url");
                    DeleteObjectsResult deleteObjectsResult = this.ossClient.deleteObjects(deleteObjectsRequest);
                    List deletedObjects = deleteObjectsResult.getDeletedObjects();
                    try {
                        for (String obj : deletedObjects) {
                            String string = URLDecoder.decode(obj, "UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        log.info("Aliyun_OSS_removeDir_success");
        return responseResult;
    }

    public String completeObjectPath(String objectPath) {
        String responseResult = objectPath;
        if (!objectPath.endsWith("/")) {
            responseResult = objectPath + "/";
        }
        return responseResult;
    }

    public AliyunOperator(OSS ossClient, AliyunOSSProperties aliyunOSSProperties) {
        this.ossClient = ossClient;
        this.aliyunOSSProperties = aliyunOSSProperties;
    }
}

