/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka.config;

import com.ifourthwall.kafka.IFWKafkaClient;
import com.ifourthwall.kafka.config.IFWKafkaProducerProperty;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.spring.TracingProducerFactory;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.kafka.producer", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={IFWKafkaProducerProperty.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@AutoConfigureOrder(value=-2147480648)
public class IFWKafkaProducerConfig {
    private static final Logger log = LoggerFactory.getLogger(IFWKafkaProducerConfig.class);
    @Autowired
    private IFWKafkaProducerProperty ifwKafkaProducerProperty;
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void initKafkaProducer() {
        if (CollectionUtils.isEmpty(this.ifwKafkaProducerProperty.getConfig())) {
            throw new IllegalArgumentException("\u672a\u627e\u5230kafka\u751f\u4ea7\u8005\u914d\u7f6e");
        }
        this.ifwKafkaProducerProperty.getConfig().forEach(ifwKafkaProperties -> {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("bootstrap.servers", ifwKafkaProperties.getBootstrapServers());
            props.put("key.serializer", StringSerializer.class);
            props.put("value.serializer", StringSerializer.class);
            TracingProducerFactory producerFactory = !StringUtils.equals((CharSequence)this.environment.getProperty("ifw.monitor.config.enable"), (CharSequence)"false") ? new TracingProducerFactory((ProducerFactory)new DefaultKafkaProducerFactory(props), (Tracer)this.applicationContext.getBean(Tracer.class)) : new DefaultKafkaProducerFactory(props);
            this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{KafkaTemplate.class, ifwKafkaProperties.getKafkaTopic()}), KafkaTemplate.class, () -> IFWKafkaProducerConfig.lambda$null$0((ProducerFactory)producerFactory), new BeanDefinitionCustomizer[0]);
            this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{NewTopic.class, ifwKafkaProperties.getKafkaTopic()}), NewTopic.class, () -> new NewTopic(ifwKafkaProperties.getKafkaTopic(), ifwKafkaProperties.getNumPartition(), ifwKafkaProperties.getReplicationFactor()), new BeanDefinitionCustomizer[0]);
            String beanName = StringUtils.joinWith((String)"-", (Object[])new Object[]{"IFWKafkaClient", ifwKafkaProperties.getKafkaTopic()});
            log.info("\u6ce8\u518cproducer bean {}\u6210\u529f", (Object)beanName);
            this.applicationContext.registerBean(beanName, IFWKafkaClient.class, () -> {
                String KafkaTemplateBeanName = StringUtils.joinWith((String)"-", (Object[])new Object[]{KafkaTemplate.class, ifwKafkaProperties.getKafkaTopic()});
                Object kafkaTemplate = this.applicationContext.getBean(KafkaTemplateBeanName);
                if (kafkaTemplate == null) {
                    throw new IllegalStateException("\u672a\u627e\u5230name:" + KafkaTemplateBeanName + "\u5bf9\u5e94\u7684Bean");
                }
                return new IFWKafkaClient((KafkaTemplate<String, Object>)((KafkaTemplate)kafkaTemplate), ifwKafkaProperties.getKafkaTopic());
            }, new BeanDefinitionCustomizer[0]);
        });
    }

    private static /* synthetic */ KafkaTemplate lambda$null$0(ProducerFactory producerFactory) {
        return new KafkaTemplate(producerFactory);
    }
}

