/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.common;

import org.apache.commons.lang3.StringUtils;

public class CacheKeyDecorator {
    public static final String OWNED_RESOURCES = "modules";
    public static final String FUZZY_MATCH_SUFFIX = "*";
    public static final String SPLIT_SYMBOL = ":";
    public static final String USER_CACHE_PREFIX = "user";
    public static final String PROVIDER_USER_CACHE_PREFIX = "user:provider";
    public static final String AUTH_CACHE_PREFIX = "auth";
    public static final String EMAIL_CACHE_PREFIX = "email";
    public static final String PHONE_CACHE_PREFIX = "phone";

    public static String getEmailAuthenticationKey(String email) {
        return StringUtils.joinWith((String)SPLIT_SYMBOL, (Object[])new Object[]{AUTH_CACHE_PREFIX, EMAIL_CACHE_PREFIX, email});
    }

    public static String getPhoneAuthenticationKey(String phone) {
        return StringUtils.joinWith((String)SPLIT_SYMBOL, (Object[])new Object[]{AUTH_CACHE_PREFIX, PHONE_CACHE_PREFIX, phone});
    }

    public static String getUserInfoKey(String token) {
        return StringUtils.joinWith((String)SPLIT_SYMBOL, (Object[])new Object[]{AUTH_CACHE_PREFIX, USER_CACHE_PREFIX, token});
    }

    public static String getProviderUserInfoKey(String token) {
        return StringUtils.joinWith((String)SPLIT_SYMBOL, (Object[])new Object[]{AUTH_CACHE_PREFIX, PROVIDER_USER_CACHE_PREFIX, token});
    }

    public static String getModulesAuthenticationKey(String userId) {
        return StringUtils.joinWith((String)SPLIT_SYMBOL, (Object[])new Object[]{AUTH_CACHE_PREFIX, OWNED_RESOURCES, userId});
    }
}

