/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.camera.aliyun.config;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ifourthwall.camera.aliyun.AliyunCameraOperation;
import com.ifourthwall.camera.aliyun.AliyunCameraTemplate;
import com.ifourthwall.camera.core.CameraTemplate;
import com.ifourthwall.camera.core.IFWCameraOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ifw.camera.aliyun.operation", name={"enable"}, havingValue="true", matchIfMissing=false)
public class AliyunCameraConfiguration {
    @Value(value="${ifw.camera.aliyun.operation.regionId}")
    private String regionId;
    @Value(value="${ifw.camera.aliyun.operation.accessKeyId}")
    private String accessKeyId;
    @Value(value="${ifw.camera.aliyun.operation.secret}")
    private String secret;

    @Bean
    public IAcsClient iAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.regionId, (String)this.accessKeyId, (String)this.secret);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    @Bean
    public IFWCameraOperation aliyunCameraOperation() {
        return new AliyunCameraOperation();
    }

    @Bean
    public CameraTemplate cameraTemplate(IFWCameraOperation cameraOperation) {
        return new AliyunCameraTemplate(cameraOperation);
    }
}

