/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.aop.aop;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestIdAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestIdAspect.class);
    @Autowired
    private HttpServletRequest request;

    @Before(value="execution(* com.ifourthwall..*Controller.*(..))")
    public void logRequestId(JoinPoint joinPoint) {
        String requestId = this.request.getHeader("requestId");
        if (requestId != null) {
            log.info("RequestId: " + requestId);
        } else {
            log.info("No RequestId found in headers.");
        }
    }
}

