/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.aop.aop;

import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Aspect
@Component
public class TraceIdAspect {
    @Around(value="execution(* com.ifourthwall..*Controller.*(..))")
    public Object addTraceId(ProceedingJoinPoint joinPoint) throws Throwable {
        String traceId = TraceContext.traceId();
        Object result = joinPoint.proceed();
        if (result instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)result;
            HttpHeaders headers = new HttpHeaders();
            headers.add("traceId", traceId);
            return new ResponseEntity(responseEntity.getBody(), (MultiValueMap)headers, responseEntity.getStatusCode());
        }
        return result;
    }
}

