/*
 * Decompiled with CFR 0.152.
 */
package com.dbm.iot.data.protocol;

import com.dbm.iot.data.protocol.DataUtils;
import com.dbm.iot.data.protocol.model.mekon.MekonDeviceMessage;
import com.dbm.iot.data.protocol.model.mekon.device._0;
import com.dbm.iot.data.protocol.model.mekon.device._1;
import com.dbm.iot.data.protocol.model.mekon.device._10;
import com.dbm.iot.data.protocol.model.mekon.device._105;
import com.dbm.iot.data.protocol.model.mekon.device._11;
import com.dbm.iot.data.protocol.model.mekon.device._12;
import com.dbm.iot.data.protocol.model.mekon.device._13;
import com.dbm.iot.data.protocol.model.mekon.device._14;
import com.dbm.iot.data.protocol.model.mekon.device._15;
import com.dbm.iot.data.protocol.model.mekon.device._16;
import com.dbm.iot.data.protocol.model.mekon.device._17;
import com.dbm.iot.data.protocol.model.mekon.device._18;
import com.dbm.iot.data.protocol.model.mekon.device._19;
import com.dbm.iot.data.protocol.model.mekon.device._2;
import com.dbm.iot.data.protocol.model.mekon.device._20;
import com.dbm.iot.data.protocol.model.mekon.device._21;
import com.dbm.iot.data.protocol.model.mekon.device._22;
import com.dbm.iot.data.protocol.model.mekon.device._23;
import com.dbm.iot.data.protocol.model.mekon.device._24;
import com.dbm.iot.data.protocol.model.mekon.device._25;
import com.dbm.iot.data.protocol.model.mekon.device._26;
import com.dbm.iot.data.protocol.model.mekon.device._27;
import com.dbm.iot.data.protocol.model.mekon.device._28;
import com.dbm.iot.data.protocol.model.mekon.device._29;
import com.dbm.iot.data.protocol.model.mekon.device._3;
import com.dbm.iot.data.protocol.model.mekon.device._30;
import com.dbm.iot.data.protocol.model.mekon.device._31;
import com.dbm.iot.data.protocol.model.mekon.device._32;
import com.dbm.iot.data.protocol.model.mekon.device._33;
import com.dbm.iot.data.protocol.model.mekon.device._34;
import com.dbm.iot.data.protocol.model.mekon.device._35;
import com.dbm.iot.data.protocol.model.mekon.device._36;
import com.dbm.iot.data.protocol.model.mekon.device._37;
import com.dbm.iot.data.protocol.model.mekon.device._38;
import com.dbm.iot.data.protocol.model.mekon.device._39;
import com.dbm.iot.data.protocol.model.mekon.device._4;
import com.dbm.iot.data.protocol.model.mekon.device._40;
import com.dbm.iot.data.protocol.model.mekon.device._41;
import com.dbm.iot.data.protocol.model.mekon.device._42;
import com.dbm.iot.data.protocol.model.mekon.device._43;
import com.dbm.iot.data.protocol.model.mekon.device._44;
import com.dbm.iot.data.protocol.model.mekon.device._46;
import com.dbm.iot.data.protocol.model.mekon.device._47;
import com.dbm.iot.data.protocol.model.mekon.device._48;
import com.dbm.iot.data.protocol.model.mekon.device._49;
import com.dbm.iot.data.protocol.model.mekon.device._5;
import com.dbm.iot.data.protocol.model.mekon.device._50;
import com.dbm.iot.data.protocol.model.mekon.device._51;
import com.dbm.iot.data.protocol.model.mekon.device._52;
import com.dbm.iot.data.protocol.model.mekon.device._53;
import com.dbm.iot.data.protocol.model.mekon.device._54;
import com.dbm.iot.data.protocol.model.mekon.device._55;
import com.dbm.iot.data.protocol.model.mekon.device._56;
import com.dbm.iot.data.protocol.model.mekon.device._57;
import com.dbm.iot.data.protocol.model.mekon.device._58;
import com.dbm.iot.data.protocol.model.mekon.device._59;
import com.dbm.iot.data.protocol.model.mekon.device._6;
import com.dbm.iot.data.protocol.model.mekon.device._60;
import com.dbm.iot.data.protocol.model.mekon.device._61;
import com.dbm.iot.data.protocol.model.mekon.device._62;
import com.dbm.iot.data.protocol.model.mekon.device._63;
import com.dbm.iot.data.protocol.model.mekon.device._64;
import com.dbm.iot.data.protocol.model.mekon.device._65;
import com.dbm.iot.data.protocol.model.mekon.device._66;
import com.dbm.iot.data.protocol.model.mekon.device._67;
import com.dbm.iot.data.protocol.model.mekon.device._68;
import com.dbm.iot.data.protocol.model.mekon.device._69;
import com.dbm.iot.data.protocol.model.mekon.device._7;
import com.dbm.iot.data.protocol.model.mekon.device._8;
import com.dbm.iot.data.protocol.model.mekon.device._81;
import com.dbm.iot.data.protocol.model.mekon.device._9;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MekonParser {
    public static MekonDeviceMessage parse(String hexMsg) {
        MekonParser.validateHeadAndTail(hexMsg);
        char[] hexChars = hexMsg.toCharArray();
        MekonDeviceMessage mekonDeviceMessage = new MekonDeviceMessage();
        mekonDeviceMessage.setCommandType(new String(hexChars, 4, 2));
        int frameLength = MekonParser.frameLength(hexChars);
        mekonDeviceMessage.setFrameLength(frameLength);
        mekonDeviceMessage.setEquipmentNumber(MekonParser.equipmentNumber(hexChars));
        mekonDeviceMessage.setPowerSupplyMode(MekonParser.powerSupplyMode(hexChars));
        mekonDeviceMessage.setBatteryLevel(MekonParser.batteryLevel(hexChars));
        mekonDeviceMessage.setRssi(MekonParser.rssi(hexChars));
        mekonDeviceMessage.setDeviceType(MekonParser.deviceType(hexChars));
        mekonDeviceMessage.setAlarmStatus(MekonParser.alarmStatus(hexChars));
        mekonDeviceMessage.setHex(MekonParser.data(hexChars, frameLength));
        return mekonDeviceMessage;
    }

    private static void validateHeadAndTail(String hexMsg) {
        if (hexMsg == null || !hexMsg.toUpperCase().startsWith("A55A") || !hexMsg.toUpperCase().endsWith("55AA")) {
            throw new IllegalArgumentException("meokon-lora\u62a5\u6587\u975e\u6807\u51c6\u62a5\u6587\uff0c\u5f53\u524d\u62a5\u6587\uff1a" + hexMsg);
        }
    }

    private static int frameLength(char[] hexChars) {
        return Integer.parseInt(new String(hexChars, 6, 2), 16);
    }

    private static String equipmentNumber(char[] hexChars) {
        StringBuilder str = new StringBuilder();
        if (hexChars[8] >= '3') {
            boolean j = false;
            for (int i = 0; i < 8; i += 2) {
                str.append((char)Integer.valueOf(new String(hexChars, 8 + i, 2), 16).intValue());
            }
        } else {
            str.append(Integer.valueOf(new String(hexChars, 8, 8), 16));
        }
        return str.toString();
    }

    public static int powerSupplyMode(char[] hexChars) {
        byte[] bits = DataUtils.hexTobitArray(new String(hexChars, 16, 2));
        return bits[0];
    }

    public static BigDecimal batteryLevel(char[] hexChars) {
        byte[] bits = DataUtils.hexTobitArray(new String(hexChars, 16, 2));
        return BigDecimal.valueOf(5L).multiply(BigDecimal.valueOf(Integer.parseInt("" + bits[3] + bits[4] + bits[5] + bits[6] + bits[7], 2)));
    }

    public static Integer rssi(char[] hexChars) {
        return Integer.parseInt(new String(hexChars, 18, 2), 16);
    }

    public static String deviceType(char[] hexChars) {
        return Integer.parseInt(new String(hexChars, 20, 2), 16) + "";
    }

    public static String alarmStatus(char[] hexChars) {
        byte[] bits = DataUtils.hexTobitArray(new String(hexChars, 22, 2));
        return bits[5] + "";
    }

    public static String data(char[] hexChars, int frameLength) {
        return new String(hexChars, 24, (frameLength - 16) * 2);
    }

    public static String crc16(char[] hexChars) {
        return null;
    }

    public static Map<String, Object> resolve(MekonDeviceMessage message) {
        HashMap<String, Object> collectValues = new HashMap<String, Object>();
        switch (message.getDeviceType()) {
            case "0": {
                _0 d0 = new _0(message.getHex());
                collectValues.put("lsb", d0.getLsb());
                collectValues.put("pressure", d0.getPressure());
                return collectValues;
            }
            case "1": {
                _1 d1 = new _1(message.getHex());
                collectValues.put("lsb", d1.getLsb());
                collectValues.put("pressure", d1.getPressure());
                return collectValues;
            }
            case "2": {
                _2 d2 = new _2(message.getHex());
                collectValues.put("lsb", d2.getLsb());
                collectValues.put("pressure", d2.getPressure());
                return collectValues;
            }
            case "3": {
                _3 d3 = new _3(message.getHex());
                collectValues.put("lsb", d3.getLsb());
                collectValues.put("pressure", d3.getPressure());
                return collectValues;
            }
            case "4": {
                _4 d4 = new _4(message.getHex());
                collectValues.put("lsb", d4.getLsb());
                collectValues.put("pressure", d4.getPressure());
                return collectValues;
            }
            case "5": {
                _5 d5 = new _5(message.getHex());
                collectValues.put("lsb", d5.getLsb());
                collectValues.put("pressure", d5.getPressure());
                return collectValues;
            }
            case "6": {
                _6 d6 = new _6(message.getHex());
                collectValues.put("lsb", d6.getLsb());
                collectValues.put("pressure", d6.getPressure());
                return collectValues;
            }
            case "7": {
                _7 d7 = new _7(message.getHex());
                collectValues.put("lsb", d7.getLsb());
                collectValues.put("pressure", d7.getPressure());
                return collectValues;
            }
            case "8": {
                _8 d8 = new _8(message.getHex());
                collectValues.put("lsb", d8.getLsb());
                collectValues.put("liquidLevel", d8.getLiquidLevel());
                return collectValues;
            }
            case "9": {
                _9 d9 = new _9(message.getHex());
                collectValues.put("lsb", d9.getLsb());
                collectValues.put("liquidLevel", d9.getLiquidLevel());
                return collectValues;
            }
            case "10": {
                _10 d10 = new _10(message.getHex());
                collectValues.put("lsb", d10.getLsb());
                collectValues.put("liquidLevel", d10.getLiquidLevel());
                return collectValues;
            }
            case "11": {
                _11 d11 = new _11(message.getHex());
                collectValues.put("lsb", d11.getLsb());
                collectValues.put("temperature", d11.getTemperature());
                return collectValues;
            }
            case "12": {
                _12 d12 = new _12(message.getHex());
                collectValues.put("lsb", d12.getLsb());
                collectValues.put("temperature", d12.getTemperature());
                return collectValues;
            }
            case "13": {
                _13 d13 = new _13(message.getHex());
                collectValues.put("lsb", d13.getLsb());
                collectValues.put("humidity", d13.getHumidity());
                return collectValues;
            }
            case "14": {
                _14 d14 = new _14(message.getHex());
                collectValues.put("lsb", d14.getLsb());
                collectValues.put("electricity", d14.getElectricity());
                return collectValues;
            }
            case "15": {
                _15 d15 = new _15(message.getHex());
                collectValues.put("lsb", d15.getLsb());
                collectValues.put("voltage", d15.getVoltage());
                return collectValues;
            }
            case "16": {
                _16 d16 = new _16(message.getHex());
                collectValues.put("diffLsb", d16.getDiffLsb());
                collectValues.put("staticLsb", d16.getStaticLsb());
                collectValues.put("diffPressure", d16.getDiffPressure());
                collectValues.put("staticPressure", d16.getStaticPressure());
                return collectValues;
            }
            case "17": {
                _17 d17 = new _17(message.getHex());
                collectValues.put("pressureLsb", d17.getPressureLsb());
                collectValues.put("temperatureLsb", d17.getTemperatureLsb());
                collectValues.put("pressure", d17.getPressure());
                collectValues.put("temperature", d17.getTemperature());
                return collectValues;
            }
            case "18": {
                _18 d18 = new _18(message.getHex());
                collectValues.put("temperatureLsb", d18.getTemperatureLsb());
                collectValues.put("humidityLsb", d18.getHumidityLsb());
                collectValues.put("temperature", d18.getTemperature());
                collectValues.put("humidity", d18.getHumidity());
                return collectValues;
            }
            case "19": {
                _19 d19 = new _19(message.getHex());
                collectValues.put("lsb", d19.getLsb());
                collectValues.put("vibration", d19.getVibration());
                return collectValues;
            }
            case "20": {
                _20 d20 = new _20(message.getHex());
                collectValues.put("lsb", d20.getLsb());
                collectValues.put("waterLogging", d20.getWaterLogging());
                return collectValues;
            }
            case "21": {
                _21 d21 = new _21(message.getHex());
                collectValues.put("inPressureLsb", d21.getInPressureLsb());
                collectValues.put("backPressureLsb", d21.getBackPressureLsb());
                collectValues.put("inPressure", d21.getInPressure());
                collectValues.put("backPressure", d21.getBackPressure());
                return collectValues;
            }
            case "22": {
                _22 d22 = new _22(message.getHex());
                collectValues.put("lsb", d22.getLsb());
                collectValues.put("pressure", d22.getPressure());
                return collectValues;
            }
            case "23": {
                _23 d23 = new _23(message.getHex());
                collectValues.put("lsb", d23.getLsb());
                collectValues.put("inclination", d23.getInclination());
                return collectValues;
            }
            case "24": {
                _24 d24 = new _24(message.getHex());
                collectValues.put("pressureLsb", d24.getPressureLsb());
                collectValues.put("inclinationLsb", d24.getInclinationLsb());
                collectValues.put("inclination", d24.getInclination());
                collectValues.put("pressure", d24.getPressure());
                return collectValues;
            }
            case "25": {
                _25 d25 = new _25(message.getHex());
                collectValues.put("temp1Lsb", d25.getTemp1Lsb());
                collectValues.put("temp2Lsb", d25.getTemp2Lsb());
                collectValues.put("temp1", d25.getTemp1());
                collectValues.put("temp2", d25.getTemp2());
                return collectValues;
            }
            case "26": {
                _26 d26 = new _26(message.getHex());
                collectValues.put("lsb", d26.getLsb());
                collectValues.put("gravity", d26.getGravity());
                return collectValues;
            }
            case "27": {
                _27 d27 = new _27(message.getHex());
                collectValues.put("positiveCumulativeFlowLsb", d27.getPositiveCumulativeFlowLsb());
                collectValues.put("netCumulativeFlowLsb", d27.getNetCumulativeFlowLsb());
                collectValues.put("instVelocity", d27.getInstVelocity());
                collectValues.put("instDelivery", d27.getInstDelivery());
                collectValues.put("positiveCumulativeFlow", d27.getPositiveCumulativeFlow());
                collectValues.put("netCumulativeFlow", d27.getNetCumulativeFlow());
                return collectValues;
            }
            case "28": {
                _28 d28 = new _28(message.getHex());
                collectValues.put("channel1", d28.getChannel1());
                collectValues.put("channel2", d28.getChannel2());
                collectValues.put("channel3", d28.getChannel3());
                collectValues.put("channel4", d28.getChannel4());
                collectValues.put("channel5", d28.getChannel5());
                collectValues.put("channel6", d28.getChannel6());
                collectValues.put("channel7", d28.getChannel7());
                collectValues.put("channel8", d28.getChannel8());
                collectValues.put("channel9", d28.getChannel9());
                collectValues.put("channel10", d28.getChannel10());
                collectValues.put("channel11", d28.getChannel11());
                collectValues.put("channel12", d28.getChannel12());
                collectValues.put("channel13", d28.getChannel13());
                collectValues.put("channel14", d28.getChannel14());
                collectValues.put("channel15", d28.getChannel15());
                collectValues.put("channel16", d28.getChannel16());
                return collectValues;
            }
            case "29": {
                _29 d29 = new _29(message.getHex());
                collectValues.put("liquidLevelLsb", d29.getLiquidLevelLsb());
                collectValues.put("supersonicLsb", d29.getSupersonicLsb());
                collectValues.put("equivalentValueLsb", d29.getEquivalentValueLsb());
                collectValues.put("liquidLevel", d29.getLiquidLevel());
                collectValues.put("supersonic", d29.getSupersonic());
                collectValues.put("equivalentValue", d29.getEquivalentValue());
                return collectValues;
            }
            case "30": {
                _30 d30 = new _30(message.getHex());
                collectValues.put("lsb", d30.getLsb());
                collectValues.put("ultrasonicLevel", d30.getUltrasonicLevel());
                return collectValues;
            }
            case "31": {
                _31 d31 = new _31(message.getHex());
                collectValues.put("lsb", d31.getLsb());
                collectValues.put("combustibleGas", d31.getCombustibleGas());
                return collectValues;
            }
            case "32": {
                _32 d32 = new _32(message.getHex());
                collectValues.put("longitude", d32.getLongitude());
                collectValues.put("latitude", d32.getLatitude());
                return collectValues;
            }
            case "33": {
                _33 d33 = new _33(message.getHex());
                collectValues.put("liquidLevelLsb", d33.getLiquidLevelLsb());
                collectValues.put("pressureLsb", d33.getPressureLsb());
                collectValues.put("liquidLevel", d33.getLiquidLevel());
                collectValues.put("pressure", d33.getPressure());
                return collectValues;
            }
            case "34": {
                _34 d34 = new _34(message.getHex());
                collectValues.put("lsb", d34.getLsb());
                collectValues.put("hydrantPressure", d34.getHydrantPressure());
                return collectValues;
            }
            case "35": {
                _35 d35 = new _35(message.getHex());
                collectValues.put("lsb", d35.getLsb());
                collectValues.put("diffPressure", d35.getDiffPressure());
                return collectValues;
            }
            case "36": {
                _36 d36 = new _36(message.getHex());
                collectValues.put("waterLoggingStatus", d36.getWaterLoggingStatus());
                collectValues.put("drownLidStatus", d36.getDrownLidStatus());
                collectValues.put("openLidStatus", d36.getOpenLidStatus());
                collectValues.put("strikeStatus", d36.getStrikeStatus());
                return collectValues;
            }
            case "37": {
                _37 d37 = new _37(message.getHex());
                collectValues.put("switchStatus", d37.getSwitchStatus());
                return collectValues;
            }
            case "38": {
                _38 d38 = new _38(message.getHex());
                collectValues.put("liquidLevelLsb", d38.getLiquidLevelLsb());
                collectValues.put("temperatureLsb", d38.getTemperatureLsb());
                collectValues.put("liquidLevel", d38.getLiquidLevel());
                collectValues.put("temperature", d38.getTemperature());
                return collectValues;
            }
            case "39": {
                _39 d39 = new _39(message.getHex());
                collectValues.put("temperatureLsb", d39.getTemperatureLsb());
                collectValues.put("temperature", d39.getTemperature());
                collectValues.put("switchStatus", d39.getSwitchStatus());
                return collectValues;
            }
            case "40": {
                _40 d40 = new _40(message.getHex());
                collectValues.put("lsb", d40.getLsb());
                collectValues.put("liquidLevel", d40.getLiquidLevel());
                return collectValues;
            }
            case "41": {
                _41 d41 = new _41(message.getHex());
                collectValues.put("lsb", d41.getLsb());
                collectValues.put("db", d41.getDb());
                return collectValues;
            }
            case "42": {
                _42 d42 = new _42(message.getHex());
                collectValues.put("lsb", d42.getLsb());
                collectValues.put("distance", d42.getDistance());
                return collectValues;
            }
            case "43": {
                _43 d43 = new _43(message.getHex());
                collectValues.put("channel1", d43.getChannel1());
                collectValues.put("channel2", d43.getChannel2());
                collectValues.put("channel3", d43.getChannel3());
                collectValues.put("channel4", d43.getChannel4());
                collectValues.put("channel5", d43.getChannel5());
                collectValues.put("channel6", d43.getChannel6());
                collectValues.put("channel7", d43.getChannel7());
                collectValues.put("channel8", d43.getChannel8());
                collectValues.put("channel9", d43.getChannel9());
                collectValues.put("channel10", d43.getChannel10());
                collectValues.put("channel11", d43.getChannel11());
                collectValues.put("channel12", d43.getChannel12());
                collectValues.put("channel13", d43.getChannel13());
                collectValues.put("channel14", d43.getChannel14());
                collectValues.put("channel15", d43.getChannel15());
                collectValues.put("channel16", d43.getChannel16());
                collectValues.put("channel17", d43.getChannel17());
                collectValues.put("channel18", d43.getChannel18());
                collectValues.put("channel19", d43.getChannel19());
                collectValues.put("channel20", d43.getChannel20());
                collectValues.put("channel21", d43.getChannel21());
                collectValues.put("channel22", d43.getChannel22());
                collectValues.put("channel23", d43.getChannel23());
                collectValues.put("channel24", d43.getChannel24());
                collectValues.put("channel25", d43.getChannel25());
                collectValues.put("channel26", d43.getChannel26());
                collectValues.put("channel27", d43.getChannel27());
                collectValues.put("channel28", d43.getChannel28());
                collectValues.put("channel29", d43.getChannel29());
                collectValues.put("channel30", d43.getChannel30());
                collectValues.put("channel31", d43.getChannel31());
                collectValues.put("channel32", d43.getChannel32());
                return collectValues;
            }
            case "44": {
                _44 d44 = new _44(message.getHex());
                collectValues.put("windSpeedLsb", d44.getWindSpeedLsb());
                collectValues.put("diffPressureLsb", d44.getDiffPressureLsb());
                collectValues.put("airflowLsb", d44.getAirflowLsb());
                collectValues.put("diffPressure", d44.getDiffPressure());
                collectValues.put("windSpeed", d44.getWindSpeed());
                collectValues.put("airflow", d44.getAirflow());
                return collectValues;
            }
            case "45": {
                return collectValues;
            }
            case "46": {
                _46 d46 = new _46(message.getHex());
                collectValues.put("lsb", d46.getLsb());
                collectValues.put("liquidLevel", d46.getLiquidLevel());
                return collectValues;
            }
            case "47": {
                _47 d47 = new _47(message.getHex());
                collectValues.put("lsb", d47.getLsb());
                collectValues.put("ph", d47.getPh());
                return collectValues;
            }
            case "48": {
                _48 d48 = new _48(message.getHex());
                collectValues.put("lsb", d48.getLsb());
                collectValues.put("conductivity", d48.getConductivity());
                return collectValues;
            }
            case "49": {
                _49 d49 = new _49(message.getHex());
                collectValues.put("liquidLevelLsb", d49.getLiquidLevelLsb());
                collectValues.put("inclinationLsb", d49.getInclinationLsb());
                collectValues.put("inclination", d49.getInclination());
                collectValues.put("liquidLevel", d49.getLiquidLevel());
                return collectValues;
            }
            case "50": {
                _50 d50 = new _50(message.getHex());
                collectValues.put("pressure1Lsb", d50.getPressure1Lsb());
                collectValues.put("pressure2Lsb", d50.getPressure2Lsb());
                collectValues.put("temperature1Lsb", d50.getTemperature1Lsb());
                collectValues.put("temperature2Lsb", d50.getTemperature2Lsb());
                collectValues.put("flowLsb", d50.getFlowLsb());
                collectValues.put("pressure1", d50.getPressure1());
                collectValues.put("pressure2", d50.getPressure2());
                collectValues.put("temperature1", d50.getTemperature1());
                collectValues.put("temperature2", d50.getTemperature2());
                collectValues.put("flow", d50.getFlow());
                return collectValues;
            }
            case "51": {
                _51 d51 = new _51(message.getHex());
                collectValues.put("lsb", d51.getLsb());
                collectValues.put("orp", d51.getOrp());
                return collectValues;
            }
            case "52": {
                _52 d52 = new _52(message.getHex());
                collectValues.put("lsb", d52.getLsb());
                collectValues.put("gravity", d52.getGravity());
                return collectValues;
            }
            case "53": {
                _53 d53 = new _53(message.getHex());
                collectValues.put("lsb", d53.getLsb());
                collectValues.put("totalFlow", d53.getTotalFlow());
                return collectValues;
            }
            case "54": {
                _54 d54 = new _54(message.getHex());
                collectValues.put("contentLsb", d54.getContentLsb());
                collectValues.put("phLsb", d54.getPhLsb());
                collectValues.put("temperatureLsb", d54.getTemperatureLsb());
                collectValues.put("content", d54.getContent());
                collectValues.put("ph", d54.getPh());
                collectValues.put("temperature", d54.getTemperature());
                return collectValues;
            }
            case "55": {
                _55 d55 = new _55(message.getHex());
                collectValues.put("codLsb", d55.getCodLsb());
                collectValues.put("turbidityLsb", d55.getTurbidityLsb());
                collectValues.put("temperatureLsb", d55.getTemperatureLsb());
                collectValues.put("cod", d55.getCod());
                collectValues.put("turbidity", d55.getTurbidity());
                collectValues.put("temperature", d55.getTemperature());
                return collectValues;
            }
            case "56": {
                _56 d56 = new _56(message.getHex());
                collectValues.put("contentLsb", d56.getContentLsb());
                collectValues.put("temperatureLsb", d56.getTemperatureLsb());
                collectValues.put("content", d56.getContent());
                collectValues.put("temperature", d56.getTemperature());
                collectValues.put("unit", d56.getUnit());
                return collectValues;
            }
            case "57": {
                _57 d57 = new _57(message.getHex());
                collectValues.put("lsb", d57.getLsb());
                collectValues.put("turbidity", d57.getTurbidity());
                return collectValues;
            }
            case "58": {
                _58 d58 = new _58(message.getHex());
                collectValues.put("pressureLsb", d58.getPressureLsb());
                collectValues.put("inclinationLsb", d58.getInclinationLsb());
                collectValues.put("flowLsb", d58.getFlowLsb());
                collectValues.put("temperatureLsb", d58.getTemperatureLsb());
                collectValues.put("pressure", d58.getPressure());
                collectValues.put("inclination", d58.getInclination());
                collectValues.put("flow", d58.getFlow());
                collectValues.put("temperature", d58.getTemperature());
                return collectValues;
            }
            case "59": {
                _59 d59 = new _59(message.getHex());
                collectValues.put("count", d59.getCount());
                return collectValues;
            }
            case "60": {
                _60 d60 = new _60(message.getHex());
                collectValues.put("kwhLsb", d60.getKwhLsb());
                collectValues.put("AVoltageLsb", d60.getAVoltageLsb());
                collectValues.put("BVoltageLsb", d60.getBVoltageLsb());
                collectValues.put("CVoltageLsb", d60.getCVoltageLsb());
                collectValues.put("AElectricityLsb", d60.getAElectricityLsb());
                collectValues.put("BElectricityLsb", d60.getBElectricityLsb());
                collectValues.put("CElectricityLsb", d60.getCElectricityLsb());
                collectValues.put("totalActivePowerLsb", d60.getTotalActivePowerLsb());
                collectValues.put("overallPowerFactorLsb", d60.getOverallPowerFactorLsb());
                collectValues.put("kwh", d60.getKwh());
                collectValues.put("AVoltage", d60.getAVoltage());
                collectValues.put("BVoltage", d60.getBVoltage());
                collectValues.put("CVoltage", d60.getCVoltage());
                collectValues.put("AElectricity", d60.getAElectricity());
                collectValues.put("BElectricity", d60.getBElectricity());
                collectValues.put("CElectricity", d60.getCElectricity());
                collectValues.put("totalActivePower", d60.getTotalActivePower());
                collectValues.put("overallPowerFactor", d60.getOverallPowerFactor());
                return collectValues;
            }
            case "61": {
                _61 d61 = new _61(message.getHex());
                collectValues.put("lsb", d61.getLsb());
                collectValues.put("pressure", d61.getPressure());
                return collectValues;
            }
            case "62": {
                _62 d62 = new _62(message.getHex());
                collectValues.put("vibrationWaveLsb", d62.getVibrationWaveLsb());
                collectValues.put("temperatureLsb", d62.getTemperatureLsb());
                collectValues.put("temperature", d62.getTemperature());
                collectValues.put("vibrationWave", d62.getVibrationWave());
                return collectValues;
            }
            case "63": {
                _63 d63 = new _63(message.getHex());
                collectValues.put("lsb", d63.getLsb());
                collectValues.put("liquidLevel", d63.getLiquidLevel());
                return collectValues;
            }
            case "64": {
                _64 d64 = new _64(message.getHex());
                collectValues.put("contentLsb", d64.getContentLsb());
                collectValues.put("temperatureLsb", d64.getTemperatureLsb());
                collectValues.put("content", d64.getContent());
                collectValues.put("temperature", d64.getTemperature());
                return collectValues;
            }
            case "65": {
                _65 d65 = new _65(message.getHex());
                collectValues.put("temperature1Lsb", d65.getTemperature1Lsb());
                collectValues.put("temperature2Lsb", d65.getTemperature2Lsb());
                collectValues.put("temperature3Lsb", d65.getTemperature3Lsb());
                collectValues.put("temperature1", d65.getTemperature1());
                collectValues.put("temperature2", d65.getTemperature2());
                collectValues.put("temperature3", d65.getTemperature3());
                return collectValues;
            }
            case "66": {
                _66 d66 = new _66(message.getHex());
                collectValues.put("pressure1Lsb", d66.getPressure1Lsb());
                collectValues.put("pressure2Lsb", d66.getPressure2Lsb());
                collectValues.put("pressure1", d66.getPressure1());
                collectValues.put("pressure2", d66.getPressure2());
                return collectValues;
            }
            case "67": {
                _67 d67 = new _67(message.getHex());
                collectValues.put("inclinationLsb", d67.getInclinationLsb());
                collectValues.put("waterLoggingLsb", d67.getWaterLoggingLsb());
                collectValues.put("waterLogging", d67.getWaterLogging());
                collectValues.put("inclination", d67.getInclination());
                return collectValues;
            }
            case "68": {
                _68 d68 = new _68(message.getHex());
                collectValues.put("phLsb", d68.getPhLsb());
                collectValues.put("temperatureLsb", d68.getTemperatureLsb());
                collectValues.put("ph", d68.getPh());
                collectValues.put("temperature", d68.getTemperature());
                return collectValues;
            }
            case "69": {
                _69 d69 = new _69(message.getHex());
                collectValues.put("conductivityLsb", d69.getConductivityLsb());
                collectValues.put("temperatureLsb", d69.getTemperatureLsb());
                collectValues.put("conductivity", d69.getConductivity());
                collectValues.put("temperature", d69.getTemperature());
                return collectValues;
            }
            case "81": {
                _81 d81 = new _81(message.getHex());
                collectValues.put("lsb", d81.getLsb());
                collectValues.put("gasStrength", d81.getGasStrength());
                return collectValues;
            }
            case "105": {
                _105 d105 = new _105(message.getHex());
                collectValues.put("tempLsb", d105.getTempLsb());
                collectValues.put("humidityLsb", d105.getHumidityLsb());
                collectValues.put("pm1_0Lsb", d105.getPm1_0Lsb());
                collectValues.put("pm2_5Lsb", d105.getPm2_5Lsb());
                collectValues.put("pm10Lsb", d105.getPm10Lsb());
                collectValues.put("co2Lsb", d105.getCo2Lsb());
                collectValues.put("coLsb", d105.getCoLsb());
                collectValues.put("nh3Lsb", d105.getNh3Lsb());
                collectValues.put("temp", d105.getTemp());
                collectValues.put("humidity", d105.getHumidity());
                collectValues.put("pm1_0", d105.getPm1_0());
                collectValues.put("pm2_5", d105.getPm2_5());
                collectValues.put("pm10", d105.getPm10());
                collectValues.put("co2", d105.getCo2());
                collectValues.put("co", d105.getCo());
                collectValues.put("nh3", d105.getNh3());
                return collectValues;
            }
        }
        return collectValues;
    }
}

