/*
 * Decompiled with CFR 0.152.
 */
package com.dbm.iot.data.protocol;

public class DataUtils {
    public static int hexStringToUnsignedInt(String hexString) {
        long longValue = Long.parseLong(hexString, 16);
        return (int)longValue;
    }

    public static Double hexStringToDouble(String hexString) {
        long longValue = Long.parseLong(hexString, 16);
        return Double.longBitsToDouble(longValue);
    }

    public static short hexStringToUnsignedShort(String hexString) {
        int intValue = Integer.parseInt(hexString, 16);
        return (short)intValue;
    }

    public static int[] shortToBinaryArray(short value) {
        int[] binaryArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            binaryArray[15 - i] = value >> i & 1;
        }
        return binaryArray;
    }

    public static int[] intToBitArray(int value) {
        int[] bitArray = new int[32];
        for (int i = 0; i < 32; ++i) {
            bitArray[31 - i] = value >> i & 1;
        }
        return bitArray;
    }

    public static byte[] hexTobitArray(String hexString) {
        String binaryString = DataUtils.hexStringToBinaryString(hexString);
        byte[] binaryArray = DataUtils.binaryStringToByteArray(binaryString);
        return binaryArray;
    }

    public static String hexStringToBinaryString(String hexString) {
        int intValue = Integer.parseInt(hexString, 16);
        String binaryString = Integer.toBinaryString(intValue);
        while (binaryString.length() < 8) {
            binaryString = "0" + binaryString;
        }
        return binaryString;
    }

    public static byte[] binaryStringToByteArray(String binaryString) {
        byte[] byteArray = new byte[binaryString.length()];
        for (int i = 0; i < binaryString.length(); ++i) {
            byteArray[i] = (byte)(binaryString.charAt(i) - 48);
        }
        return byteArray;
    }
}

