package com.ifourthwall.job.redis.scheduler.config;

import io.lettuce.core.internal.HostAndPort;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author: hao.dai
 * @Date: 2020/1/11 14:18
 * @Description:
 */
@ConfigurationProperties("ifw.job.config.redis.lettuce")
@Data
public class RedisSchedulerJobProperty implements InitializingBean {
    /**
     * Default timeout: 60 sec
     */
    public static final long DEFAULT_TIMEOUT = 60;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(DEFAULT_TIMEOUT);
    public static final int MAX_RETRIES_ON_CONNECTION_FAILURE = 3;
    private String applicationName;
    private String host;
    private String socket;
    private String sentinelMasterId;
    private int port;
    private int database;
    private String clientName;
    private String password;
    private boolean ssl = false;
    private boolean verifyPeer = true;
    private boolean startTls = false;
    private Duration timeout = DEFAULT_TIMEOUT_DURATION;
    private int pollingDelayMillis = 10000;
    private final List<HostAndPort> sentinels = new ArrayList<>();
    private int maxRetriesOnConnectionFailure = MAX_RETRIES_ON_CONNECTION_FAILURE;

    @Override
    public void afterPropertiesSet() throws Exception {
        throwException(StringUtils.isEmpty(host), acquireAllName("host") + "不能为空");
        throwException(StringUtils.isEmpty(password), acquireAllName("password") + "不能为空");
        throwException(StringUtils.isEmpty(host), acquireAllName("applicationName") + "不能为空");
    }

    private String acquireAllName(String propertyName) {
        return StringUtils.joinWith(".", "ifw.job.config.redis.lettuce", propertyName);
    }

    private void throwException(boolean isThrown, String message) {
        if (isThrown) {
            throw new IllegalArgumentException(message);
        }
    }
}
