package com.ifourthwall.job.redis.scheduler;

import com.github.davidmarquis.redisscheduler.TaskTriggerListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @Author: hao.dai
 * @Date: 2020/1/11 15:01
 * @Description:
 */
@Slf4j
public class IFWTaskTriggerListener implements TaskTriggerListener {

    private List<IFWJob> ifwJobs;
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    public IFWTaskTriggerListener(List<IFWJob> ifwJobs) {
        this.ifwJobs = ifwJobs;
    }

    @Override
    public void taskTriggered(final String taskId) {
        //异步执行task
        if (!CollectionUtils.isEmpty(ifwJobs)) {
            for (IFWJob ifwJob : ifwJobs) {
                if (StringUtils.equals(taskId, ifwJob.getTaskId())) {
                    executorService.submit(() -> {
                        try {
                            log.info("Start to execute task. The taskId is {}", taskId);
                            ifwJob.handle();
                            log.info("Succeed to execute task. The taskId is {}", taskId);
                        } catch (Exception e) {
                            log.warn("Failed to execute task. The taskId is {},the error message is {}", taskId, e.getMessage());
                        }
                    });
                }
            }
        }
    }
}
