/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.oss.aliyun.config;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.ifourthwall.oss.aliyun.AliyunOperator;
import com.ifourthwall.oss.aliyun.config.AliyunOSSProperties;
import com.ifourthwall.oss.core.OSSOperator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ifw.oss.aliyun.config", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={AliyunOSSProperties.class})
public class AliyunOSSConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OSSOperator.class})
    public OSSOperator ossOperator(AliyunOSSProperties aliyunOSSProperties) {
        OSS oss = new OSSClientBuilder().build(aliyunOSSProperties.getEndpoint(), aliyunOSSProperties.getAccessKeyId(), aliyunOSSProperties.getAccessKeySecret());
        return new AliyunOperator(oss, aliyunOSSProperties);
    }
}

