/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.message.sms;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.message.sms.SendSMSCallBack;
import com.ifourthwall.message.sms.config.SMSProperties;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSMSService {
    private static final Logger log = LoggerFactory.getLogger(SendSMSService.class);
    public static final String EN_COUNTRY_CODE = "+1";
    private Map<String, List<SMSProperties>> smsPropertiesMap;
    private List<SMSProperties> defaultSMSProperties;

    public SendSMSService(Map<String, List<SMSProperties>> smsPropertiesMap, List<SMSProperties> defaultSMSProperties) {
        this.smsPropertiesMap = smsPropertiesMap;
        this.defaultSMSProperties = defaultSMSProperties;
    }

    public boolean sendSMS(String phoneNos, String index, String messageJson) {
        return this.sendSMS(phoneNos, index, messageJson, null);
    }

    public boolean sendSMS(String phoneNos, String index, String messageJson, SendSMSCallBack sendSMSCallBack) {
        SMSProperties smsProperties = this.chooseSMSProperties(phoneNos, index);
        String finalPhoneNo = phoneNos.replace("+", "");
        DefaultProfile profile = DefaultProfile.getProfile((String)smsProperties.getRegionId(), (String)smsProperties.getAccessKeyId(), (String)smsProperties.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(smsProperties.getDomain());
        request.setVersion(smsProperties.getVersion());
        request.setAction(smsProperties.getAction());
        request.putQueryParameter("RegionId", smsProperties.getRegionId());
        request.putQueryParameter("PhoneNumbers", finalPhoneNo);
        request.putQueryParameter("SignName", new String(smsProperties.getSignature().getBytes()));
        request.putQueryParameter("TemplateCode", smsProperties.getTemplateCode());
        request.putQueryParameter("TemplateParam", messageJson);
        try {
            CommonResponse response;
            Map data;
            if (sendSMSCallBack != null) {
                sendSMSCallBack.beforeSend((IAcsClient)client, smsProperties, messageJson);
            }
            if ((data = (Map)JSONUtils.jacksonFromJson((String)(response = client.getCommonResponse(request)).getData(), Map.class)) != null && ((String)data.get("Code")).equals("OK")) {
                log.info("\u53d1\u9001\u4fe1\u606f\u6210\u529fok\uff1a" + finalPhoneNo + " message:" + messageJson + " return:" + response.getData());
                if (sendSMSCallBack != null) {
                    sendSMSCallBack.onSuccess(data);
                }
            } else {
                log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a" + finalPhoneNo + " message:" + messageJson + " return:" + response.getData());
                if (sendSMSCallBack != null) {
                    sendSMSCallBack.onFailed(data);
                }
            }
            return true;
        }
        catch (ClientException e) {
            log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a" + finalPhoneNo + " message:" + messageJson);
            log.error("ErrCode:" + e.getErrCode());
            log.error("ErrMsg:" + e.getErrMsg());
            log.error("RequestId:" + e.getRequestId());
            if (sendSMSCallBack != null) {
                sendSMSCallBack.onException(e);
            }
            return false;
        }
    }

    private SMSProperties chooseSMSProperties(String phoneNumbers, String index) {
        if (phoneNumbers != null && !phoneNumbers.equals("")) {
            String[] phoneNoArray = phoneNumbers.split(",");
            if (phoneNoArray != null) {
                List<SMSProperties> smsPropertiesList;
                SMSProperties smsProperties;
                for (String phoneNo : phoneNoArray) {
                    for (Map.Entry<String, List<SMSProperties>> template : this.smsPropertiesMap.entrySet()) {
                        List<SMSProperties> smsPropertiesList2;
                        SMSProperties smsProperties2;
                        if (!phoneNo.startsWith(template.getKey()) || (smsProperties2 = this.getMacthedSMSProperties(smsPropertiesList2 = template.getValue(), index)) == null) continue;
                        return smsProperties2;
                    }
                }
                if (phoneNumbers.contains("+") && this.smsPropertiesMap.containsKey(EN_COUNTRY_CODE) && (smsProperties = this.getMacthedSMSProperties(smsPropertiesList = this.smsPropertiesMap.get(EN_COUNTRY_CODE), index)) != null) {
                    return smsProperties;
                }
            }
            for (SMSProperties defaultSMSProperty : this.defaultSMSProperties) {
                if (!StringUtils.equals((CharSequence)defaultSMSProperty.getIndex(), (CharSequence)index)) continue;
                return defaultSMSProperty;
            }
        }
        throw new IllegalArgumentException("SMS\u53d1\u9001:index\u672a\u6307\u5b9a\u6216" + index + "\u4e0b\u672a\u6307\u5b9a\u9ed8\u8ba4\u6a21\u677f");
    }

    private SMSProperties getMacthedSMSProperties(List<SMSProperties> smsPropertiesList, String index) {
        SMSProperties defaultSMSProperties = null;
        SMSProperties matchedSMSProperties = null;
        for (SMSProperties smsProperties : smsPropertiesList) {
            if (smsProperties.isAsDefaultTemplate()) {
                defaultSMSProperties = smsProperties;
            }
            if (!StringUtils.equals((CharSequence)smsProperties.getIndex(), (CharSequence)index)) continue;
            matchedSMSProperties = smsProperties;
        }
        if (matchedSMSProperties != null) {
            return matchedSMSProperties;
        }
        return defaultSMSProperties;
    }
}

