/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.message.sms.aliyun.config;

import com.ifourthwall.message.sms.aliyun.AliyunSendSMSService;
import com.ifourthwall.message.sms.aliyun.config.AliyunSMSProperties;
import com.ifourthwall.message.sms.aliyun.config.AliyunSMSProperty;
import com.ifourthwall.message.sms.core.SendSMSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.sms.aliyun.config", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={AliyunSMSProperty.class})
public class AliyunSendSMSConfig {
    @Autowired
    private AliyunSMSProperty smsProperty;

    @Bean
    public SendSMSService sendSMSService() {
        if (CollectionUtils.isEmpty(this.smsProperty.getConfig())) {
            throw new IllegalArgumentException("sms\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        HashMap<String, List<AliyunSMSProperties>> smsPropertiesMap = new HashMap<String, List<AliyunSMSProperties>>();
        ArrayList<AliyunSMSProperties> defaultSMSProperties = new ArrayList<AliyunSMSProperties>();
        for (AliyunSMSProperties smsProperties : this.smsProperty.getConfig()) {
            ArrayList<AliyunSMSProperties> smsPropertiesList = (ArrayList<AliyunSMSProperties>)smsPropertiesMap.get(smsProperties.getCountryCode());
            if (CollectionUtils.isEmpty((Collection)smsPropertiesList)) {
                smsPropertiesList = new ArrayList<AliyunSMSProperties>();
                smsPropertiesList.add(smsProperties);
                smsPropertiesMap.put(smsProperties.getCountryCode(), smsPropertiesList);
            } else {
                smsPropertiesList.add(smsProperties);
            }
            if (!smsProperties.isAsDefaultTemplate() || !smsProperties.isDefaultSelected()) continue;
            defaultSMSProperties.add(smsProperties);
        }
        if (CollectionUtils.isEmpty(defaultSMSProperties)) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u6307\u5b9a\u9ed8\u8ba4\u6a21\u677f");
        }
        AliyunSendSMSService sendSMSService = new AliyunSendSMSService(smsPropertiesMap, defaultSMSProperties);
        return sendSMSService;
    }
}

