/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.message.email;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ifourthwall.message.email.SendEmailCallBack;
import com.ifourthwall.message.email.config.SendEmailProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEmailService {
    private static final Logger log = LoggerFactory.getLogger(SendEmailService.class);
    private SendEmailProperties sendEmailProperties;

    public SendEmailService(SendEmailProperties sendEmailProperties) {
        this.sendEmailProperties = sendEmailProperties;
    }

    public boolean sendEmail(String toAddress, String subject, String htmlBody, String tag) {
        return this.sendEmail(toAddress, subject, htmlBody, tag, null);
    }

    public boolean sendEmail(String toAddress, String subject, String htmlBody, String tag, SendEmailCallBack sendEmailCallBack) {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.sendEmailProperties.getRegionId(), (String)this.sendEmailProperties.getAccessKeyId(), (String)this.sendEmailProperties.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        SingleSendMailRequest request = new SingleSendMailRequest();
        request.setRegionId(this.sendEmailProperties.getRegionId());
        request.setAccountName(this.sendEmailProperties.getAcountName());
        request.setAddressType(Integer.valueOf(this.sendEmailProperties.getAddressType()));
        request.setReplyToAddress(Boolean.valueOf(this.sendEmailProperties.isReplyToAddress()));
        request.setToAddress(toAddress);
        request.setSubject(subject);
        request.setTagName(tag);
        request.setHtmlBody(htmlBody);
        try {
            if (sendEmailCallBack != null) {
                sendEmailCallBack.beforeSend(request, this.sendEmailProperties, profile);
            }
            SingleSendMailResponse response = (SingleSendMailResponse)client.getAcsResponse((AcsRequest)request);
            log.info("\u53d1\u9001Email\u6210\u529f: toAddress:" + toAddress + " subject:" + subject);
            if (sendEmailCallBack != null) {
                sendEmailCallBack.onSuccess(response, this.sendEmailProperties, profile);
            }
            return true;
        }
        catch (ClientException e) {
            log.warn("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0crequestId:{},code:{}\uff0c\u9519\u8bef\u7c7b\u578b:{},\u539f\u56e0:{}", new Object[]{e.getRequestId(), e.getErrCode(), e.getErrorType(), e.getErrMsg()});
            if (sendEmailCallBack != null) {
                sendEmailCallBack.onException(e, this.sendEmailProperties, profile);
            }
            return false;
        }
    }
}

