package com.ifourthwall.message.email.config;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.ifourthwall.message.email.SendEmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @Author: hao.dai
 * @Date: 2019/12/27 16:08
 * @Description:
 */
@ConditionalOnProperty(prefix = "ifw.email.config", name = "enable", havingValue = "true", matchIfMissing = false)
@EnableConfigurationProperties(value = {SendEmialProperty.class})
public class SendEmailConfig {
    @Autowired
    private SendEmialProperty sendEmialProperty;

    @Bean
    public SendEmailService sendEmailService() {
        SendEmailProperties sendEmailProperties = sendEmialProperty.getConfig();
        if (sendEmailProperties == null) {
            throw new IllegalArgumentException("Email相关配置不存在");
        }
        DefaultProfile profile = DefaultProfile.getProfile(sendEmailProperties.getRegionId(), sendEmailProperties.getAccessKeyId(),
                sendEmailProperties.getSecret());

        SendEmailService sendEmailService = new SendEmailService(sendEmailProperties);
        return sendEmailService;
    }
}
