package com.ifourthwall.message.email;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.ifourthwall.message.email.config.SendEmailProperties;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: hao.dai
 * @Date: 2019/12/27 16:07
 * @Description:
 */
@Slf4j
public class SendEmailService {
    private SendEmailProperties sendEmailProperties;

    public SendEmailService(SendEmailProperties sendEmailProperties) {
        this.sendEmailProperties = sendEmailProperties;
    }

    public boolean sendEmail(String toAddress, String subject, String htmlBody, String tag) {
        return sendEmail(toAddress, subject, htmlBody, tag, null);
    }

    public boolean sendEmail(String toAddress, String subject, String htmlBody, String tag, SendEmailCallBack sendEmailCallBack) {

        DefaultProfile profile = DefaultProfile.getProfile(sendEmailProperties.getRegionId(), sendEmailProperties.getAccessKeyId(),
                sendEmailProperties.getSecret());

        IAcsClient client = new DefaultAcsClient(profile);
        SingleSendMailRequest request = new SingleSendMailRequest();
        request.setRegionId(sendEmailProperties.getRegionId());
        request.setAccountName(sendEmailProperties.getAcountName());
        request.setAddressType(sendEmailProperties.getAddressType());
        request.setReplyToAddress(sendEmailProperties.isReplyToAddress());
        request.setToAddress(toAddress);
        request.setSubject(subject);
        request.setTagName(tag);
        request.setHtmlBody(htmlBody);

        try {
            if (sendEmailCallBack != null) {
                sendEmailCallBack.beforeSend(request, sendEmailProperties, profile);
            }
            SingleSendMailResponse response = client.getAcsResponse(request);
            log.info("发送Email成功: toAddress:" + toAddress + " subject:" + subject);
            if (sendEmailCallBack != null) {
                sendEmailCallBack.onSuccess(response, sendEmailProperties, profile);
            }
            return true;
        } catch (ClientException e) {
            log.warn("发送邮件失败，requestId:{},code:{}，错误类型:{},原因:{}", e.getRequestId(),
                    e.getErrCode(), e.getErrorType(), e.getErrMsg());
            if (sendEmailCallBack != null) {
                sendEmailCallBack.onException(e, sendEmailProperties, profile);
            }
            return false;
        }
    }
}
