/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka.config;

import com.ifourthwall.kafka.DataHandler;
import com.ifourthwall.kafka.KafkaDataConsumer;
import com.ifourthwall.kafka.config.IFWKafkaConsumerProperty;
import com.ifourthwall.kafka.config.IFWKafkaProperties;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.spring.TracingConsumerFactory;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.kafka.consumer", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={IFWKafkaConsumerProperty.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@AutoConfigureOrder(value=-2147480648)
public class IFWKafkaConsumerConfig {
    private static final Logger log = LoggerFactory.getLogger(IFWKafkaConsumerConfig.class);
    @Autowired
    private IFWKafkaConsumerProperty ifwKafkaConsumerProperty;
    @Autowired
    private List<DataHandler> dataHandlerList;
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void initKafkaConsumer() {
        if (CollectionUtils.isEmpty(this.ifwKafkaConsumerProperty.getConfig())) {
            throw new IllegalArgumentException("\u672a\u627e\u5230kafka\u6d88\u8d39\u8005\u914d\u7f6e");
        }
        this.ifwKafkaConsumerProperty.getConfig().stream().forEach(consumerConfigProp -> {
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("bootstrap.servers", consumerConfigProp.getBootstrapServers());
            configs.put("group.id", consumerConfigProp.getConsumerGroupId());
            configs.put("enable.auto.commit", consumerConfigProp.getConsumerEnableAutoCommit());
            configs.put("auto.commit.interval.ms", consumerConfigProp.getConsumerAutoCommitIntervalMs());
            configs.put("session.timeout.ms", consumerConfigProp.getConsumerSessionTimeoutMs());
            configs.put("max.poll.records", consumerConfigProp.getConsumerMaxPollRecords());
            configs.put("auto.offset.reset", consumerConfigProp.getConsumerAutoOffsetReset());
            configs.put("key.deserializer", StringDeserializer.class);
            configs.put("value.deserializer", StringDeserializer.class);
            configs.put("request.timeout.ms", "60000");
            TracingConsumerFactory consumerFactory = !StringUtils.equals((CharSequence)this.environment.getProperty("ifw.monitor.config.enable"), (CharSequence)"false") ? new TracingConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(configs), (Tracer)this.applicationContext.getBean(Tracer.class)) : new DefaultKafkaConsumerFactory(configs);
            String beanName = StringUtils.joinWith((String)"-", (Object[])new Object[]{ConcurrentMessageListenerContainer.class, consumerConfigProp.getKafkaTopic(), consumerConfigProp.getConsumerGroupId()});
            log.info("\u6ce8\u518cconsumer bean {}\u6210\u529f", (Object)beanName);
            this.applicationContext.registerBean(beanName, ConcurrentMessageListenerContainer.class, () -> this.lambda$null$0(consumerConfigProp, (ConsumerFactory)consumerFactory), new BeanDefinitionCustomizer[0]);
        });
    }

    private /* synthetic */ ConcurrentMessageListenerContainer lambda$null$0(IFWKafkaProperties consumerConfigProp, ConsumerFactory consumerFactory) {
        ContainerProperties containerProps = new ContainerProperties(new String[]{consumerConfigProp.getKafkaTopic()});
        containerProps.setGroupId(consumerConfigProp.getConsumerGroupId());
        containerProps.setMessageListener((Object)new KafkaDataConsumer(this.dataHandlerList));
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(consumerFactory);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer(consumerFactory, containerProps);
        container.setConcurrency(consumerConfigProp.getConcurrency());
        return container;
    }
}

