/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka.config;

import com.ifourthwall.kafka.IFWKafkaClient;
import com.ifourthwall.kafka.config.IFWKafkaProducerProperty;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.kafka.producer", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={IFWKafkaProducerProperty.class})
@AutoConfigureOrder(value=-2147480648)
public class IFWKafkaProducerConfig {
    @Autowired
    private IFWKafkaProducerProperty ifwKafkaProducerProperty;
    @Autowired
    private GenericApplicationContext applicationContext;

    @PostConstruct
    public void initKafkaProducer() {
        if (!CollectionUtils.isEmpty(this.ifwKafkaProducerProperty.getConfig())) {
            this.ifwKafkaProducerProperty.getConfig().forEach(ifwKafkaProperties -> {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("bootstrap.servers", ifwKafkaProperties.getBootstrapServers());
                props.put("key.serializer", StringSerializer.class);
                props.put("value.serializer", StringSerializer.class);
                DefaultKafkaProducerFactory defaultKafkaProducerFactory = new DefaultKafkaProducerFactory(props);
                this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{KafkaTemplate.class, ifwKafkaProperties.getKafkaTopic()}), KafkaTemplate.class, () -> new KafkaTemplate((ProducerFactory)defaultKafkaProducerFactory), new BeanDefinitionCustomizer[0]);
                this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{NewTopic.class, ifwKafkaProperties.getKafkaTopic()}), NewTopic.class, () -> new NewTopic(ifwKafkaProperties.getKafkaTopic(), ifwKafkaProperties.getNumPartition(), ifwKafkaProperties.getReplicationFactor()), new BeanDefinitionCustomizer[0]);
                this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{"IFWKafkaClient", ifwKafkaProperties.getKafkaTopic()}), IFWKafkaClient.class, () -> {
                    String beanName = StringUtils.joinWith((String)"-", (Object[])new Object[]{KafkaTemplate.class, ifwKafkaProperties.getKafkaTopic()});
                    Object kafkaTemplate = this.applicationContext.getBean(beanName);
                    if (kafkaTemplate == null) {
                        throw new IllegalStateException("\u672a\u627e\u5230name:" + beanName + "\u5bf9\u5e94\u7684Bean");
                    }
                    return new IFWKafkaClient((KafkaTemplate<String, Object>)((KafkaTemplate)kafkaTemplate), ifwKafkaProperties.getKafkaTopic());
                }, new BeanDefinitionCustomizer[0]);
            });
        }
    }
}

