/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.doc.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerUIAutoConfiguration {
    public static final String ENV_PROD = "prod";
    @Autowired
    private Environment environment;

    @Bean
    public Docket api() {
        if (ENV_PROD.equals(this.environment.getProperty("spring.profiles.active"))) {
            return new Docket(DocumentationType.SWAGGER_2).enable(false);
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.environment.getProperty("ifw.swagger.config.scanPackage"))).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.environment.getProperty("ifw.swagger.config.title")).description(this.environment.getProperty("ifw.swagger.config.description")).termsOfServiceUrl(this.environment.getProperty("ifw.swagger.config.termsOfServiceUrl")).version(this.environment.getProperty("ifw.swagger.config.version")).build();
    }
}

