/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class IFWApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(IFWApplicationContextInitializer.class);
    public static final int DEFAULT_ORDER = 0;
    public static final String PROPERTY_SOURCE_NAME = "configCenterComposite";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        log.info("handle initialize environment........");
        this.initEnvironment(applicationContext.getEnvironment());
    }

    private void initEnvironment(ConfigurableEnvironment environment) {
        String enable = environment.getProperty("nacos.config.bootstrap.enable");
        if (enable == null || !StringUtils.equals((CharSequence)"true", (CharSequence)enable)) {
            return;
        }
        if (environment.getPropertySources().contains(PROPERTY_SOURCE_NAME)) {
            return;
        }
        CompositePropertySource source = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        String configContent = this.acquireConfigContent(environment);
        if (StringUtils.isBlank((CharSequence)configContent)) {
            log.warn("nacos\u83b7\u53d6\u521d\u59cb\u5316\u5185\u5bb9\u5931\u8d25\uff0c\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configContent));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PropertiesPropertySource propertySource = new PropertiesPropertySource("configCenter", properties);
        source.addPropertySource((PropertySource)propertySource);
        environment.getPropertySources().addFirst((PropertySource)source);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private String acquireConfigContent(ConfigurableEnvironment environment) {
        String dataId = environment.getProperty("nacos.config.data-id");
        String group = environment.getProperty("nacos.config.group");
        String type = environment.getProperty("nacos.config.type");
        String serverAddr = environment.getProperty("nacos.config.serverAddr");
        String namespace = environment.getProperty("nacos.config.namespace");
        String deploySource = environment.getProperty("nacos.deploy.source");
        if (StringUtils.isBlank((CharSequence)deploySource)) {
            throw new IllegalArgumentException("nacos\u90e8\u7f72\u65b9\u5f0f\u914d\u7f6e\u6ca1\u6709\u914d\u7f6e");
        }
        if (!"properties".equals(type)) {
            throw new IllegalArgumentException("Not support type. Supported type include [properties].");
        }
        String accessKey = null;
        String secretKey = null;
        String userName = null;
        String password = null;
        Properties properties = new Properties();
        properties.put("serverAddr", serverAddr);
        properties.put("namespace", namespace);
        if ("ali".equals(deploySource)) {
            accessKey = environment.getProperty("nacos.config.access-key");
            secretKey = environment.getProperty("nacos.config.secret-key");
            properties.put("accessKey", accessKey);
            properties.put("secretKey", secretKey);
        } else if ("local".equals(deploySource)) {
            userName = environment.getProperty("nacos.config.username");
            password = environment.getProperty("nacos.config.password");
            properties.put("username", userName);
            properties.put("password", password);
        } else {
            throw new IllegalArgumentException("nacos\u90e8\u7f72\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef");
        }
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)properties);
            return configService.getConfig(dataId, group, 50000L);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        log.info("handle postProcessEnvironment........");
        this.initEnvironment(environment);
    }
}

