/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.common.base;

import com.ifourthwall.common.PlatformCodeEnum;
import java.io.Serializable;
import java.util.TimeZone;

public class BaseResponse<T>
implements Serializable {
    private String retCode;
    private String retMsg;
    private boolean flag;
    private T data;
    private String timeZone = TimeZone.getDefault().getID();

    public BaseResponse() {
        this.flag = true;
    }

    public boolean isSuccess() {
        return this.flag && PlatformCodeEnum.EXECUTE_SUCCESS.getCode().equals(this.retCode);
    }

    public BaseResponse(String retCode, String retMsg, T data) {
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.data = data;
    }

    public BaseResponse(String retCode, T data) {
        this.retCode = retCode;
        this.data = data;
    }

    public BaseResponse(String retCode, String retMsg, boolean flag, T data) {
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.flag = flag;
        this.data = data;
    }

    public static BaseResponse success(String retCode, String retMsg) {
        return new BaseResponse<Boolean>(retCode, retMsg, true);
    }

    public static <T> BaseResponse success(String retCode, String retMsg, T data) {
        return new BaseResponse<T>(retCode, retMsg, true, data);
    }

    public String getRetCode() {
        return this.retCode;
    }

    public String getRetMsg() {
        return this.retMsg;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public T getData() {
        return this.data;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$retCode = this.getRetCode();
        String other$retCode = other.getRetCode();
        if (this$retCode == null ? other$retCode != null : !this$retCode.equals(other$retCode)) {
            return false;
        }
        String this$retMsg = this.getRetMsg();
        String other$retMsg = other.getRetMsg();
        if (this$retMsg == null ? other$retMsg != null : !this$retMsg.equals(other$retMsg)) {
            return false;
        }
        if (this.isFlag() != other.isFlag()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $retCode = this.getRetCode();
        result = result * 59 + ($retCode == null ? 43 : $retCode.hashCode());
        String $retMsg = this.getRetMsg();
        result = result * 59 + ($retMsg == null ? 43 : $retMsg.hashCode());
        result = result * 59 + (this.isFlag() ? 79 : 97);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(retCode=" + this.getRetCode() + ", retMsg=" + this.getRetMsg() + ", flag=" + this.isFlag() + ", data=" + this.getData() + ", timeZone=" + this.getTimeZone() + ")";
    }
}

