/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.camera.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.vs.model.v20181212.ContinuousMoveRequest;
import com.aliyuncs.vs.model.v20181212.ContinuousMoveResponse;
import com.aliyuncs.vs.model.v20181212.StopMoveRequest;
import com.aliyuncs.vs.model.v20181212.StopMoveResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class AliyunCameraOperation {
    public static final String DEFAULT_PAN_LEFT = "0.5";
    public static final String DEFAULT_TILT_UP = "0.5";
    public static final String DEFAULT_PAN_RIGHT = "-0.5";
    public static final String DEFAULT_TILT_DOWN = "-0.5";
    public static final String DEFAULT_ZOOM_OUT = "-0.5";
    public static final String DEFAULT_ZOOM_IN = "0.5";
    @Autowired
    private IAcsClient client;

    public ContinuousMoveResponse horizontalLeftContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, "0.5", null, null);
    }

    public ContinuousMoveResponse verticalUpContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, null, "0.5", null);
    }

    public ContinuousMoveResponse horizontalRightContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, "-0.5", null, null);
    }

    public ContinuousMoveResponse verticalDownContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, null, "-0.5", null);
    }

    public ContinuousMoveResponse continuousMove(String cameraId, String pan, String tilt) {
        return this.continuousMove(cameraId, pan, tilt, null);
    }

    public ContinuousMoveResponse continuousZoomIn(String cameraId) {
        return this.continuousMove(cameraId, null, null, "0.5");
    }

    public ContinuousMoveResponse continuousZoomOut(String cameraId) {
        return this.continuousMove(cameraId, null, null, "-0.5");
    }

    public ContinuousMoveResponse continuousMove(String cameraId, String pan, String tilt, String zoom) {
        try {
            ContinuousMoveRequest request = new ContinuousMoveRequest();
            request.setId(cameraId);
            request.setActionName("ContinuousMove");
            request.setPan(pan);
            request.setTilt(tilt);
            request.setZoom(zoom);
            return (ContinuousMoveResponse)this.client.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public StopMoveResponse stopMove(String cameraId, boolean pan, boolean tilt, boolean zoom) {
        try {
            StopMoveRequest request = new StopMoveRequest();
            request.setId(cameraId);
            request.setActionName("StopMove");
            request.setPan(Boolean.valueOf(pan));
            request.setTilt(Boolean.valueOf(tilt));
            request.setZoom(Boolean.valueOf(zoom));
            return (StopMoveResponse)this.client.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public StopMoveResponse stopMovePan(String cameraId) {
        return this.stopMove(cameraId, true, false, false);
    }

    public StopMoveResponse stopMoveTilt(String cameraId) {
        return this.stopMove(cameraId, false, true, false);
    }

    public StopMoveResponse stopMoveZoom(String cameraId) {
        return this.stopMove(cameraId, false, false, true);
    }

    public StopMoveResponse stopMove(String cameraId) {
        return this.stopMove(cameraId, true, true, true);
    }
}

