package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.project.dto.*;

/**
 * @Author: WTK
 * @Date: 2021/6/17 10:25
 * @Description:
 */
public interface ProjectArchiveRecordFacade {

    /**
     * 新增项目档案记录
     * @Author: WTK
     * @Date: 2021/6/17 10:26
     * @param inseret
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertProjectArchiveRecord(UpInsertProjectArchiveRecordDTO inseret);

    /**
     * 分页查询
     * @Author: WTK
     * @Date: 2021/6/25 16:13
     * @param projectArchiveRecordPageQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.project.dto.ProjectArchiveRecordPageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<ProjectArchiveRecordPageDTO>> queryList(ProjectArchiveRecordPageQueryDTO projectArchiveRecordPageQueryDTO);

    /**
     * 详情查询
     * @Author: WTK
     * @Date: 2021/6/25 16:13
     * @param projectArchiveRecordQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.ProjectArchiveRecordDTO>
     * @throws
     */
    BaseResponse<ProjectArchiveRecordDTO> queryProjectArchiveRecord(ProjectArchiveRecordQueryDTO projectArchiveRecordQueryDTO);
}
