package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.project.dto.*;

import java.util.List;

/**
 *
 * @Author: WTK
 * @Date: 2021/6/15 16:09
 * @Description:
 */
public interface ProjectArchiveFacade {
    /**
     *新增项目档案
     * @Author: WTK
     * @Date: 2021/6/15 16:09
     * @param inseret
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<UpInsertProjectArchiveResDTO> upInsertProjectArchive(UpInsertProjectArchiveDTO inseret);

    /**
     * 项目档案查询
     * @Author: WTK
     * @Date: 2021/6/25 16:11
     * @param projectArchiveQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.ProjectArchiveDTO>
     * @throws
     */
    BaseResponse<ProjectArchiveDTO> getProjectArchiveInfo(ProjectArchiveQueryDTO projectArchiveQueryDTO);

    /**
     * 项目档案查询api接口
     * @Author: WTK
     * @Date: 2021/6/28 11:57
     * @param projectArchiveQueryApiDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.ProjectArchiveApiDTO>>
     * @throws
     */
    BaseResponse<List<ProjectArchiveApiDTO>> getProjectArchiveApi(ProjectArchiveApiQueryDTO projectArchiveQueryApiDTO);
}
