package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: WTK
 * @Date: 2021/6/17 10:26
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UpInsertProjectArchiveRecordDTO extends BaseReqDTO {

    @ApiModelProperty("类型 1.新增 2.修改")
    @NotNull(message = "记录类型不能为空")
    private String recordType;

    @ApiModelProperty("项目档案id")
    @NotNull(message = "项目档案id不能为空")
    private String projectArchiveId;

    @ApiModelProperty("项目档案记录id")
    private String archiveRecordId;

    @ApiModelProperty("json内容")
    private String jsonContent;

    @ApiModelProperty("json项目内容")
    private String jsonProject;

    @ApiModelProperty("创建者(user_id)")
    private String createBy;

}
