package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/1/2 10:19
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryAllDeptDTO implements Serializable {

    @ApiModelProperty("部门id")
    private String deptId;

    @ApiModelProperty("部门名字")
    private String deptName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目名字")
    private String projectName;

    @ApiModelProperty("项目简称")
    private String projectShortName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("负责人")
    private String projectLeaderUserId;

    @ApiModelProperty("负责人")
    private String projectLeaderUserName;

    @ApiModelProperty("状态（1:启用，2:停用）")
    private String projectStatusId;

    @ApiModelProperty("状态名")
    private String projectStatusName;

    @ApiModelProperty("观察者(0.非观察者 1.观察者)")
    private String observerId;

    @ApiModelProperty("乡镇/区id")
    private String zoneId;

    @ApiModelProperty("项目icon")
    private String projectIconUrl;

    @ApiModelProperty("省市区")
    private GetZoneListDTO regionName;
}
