package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: WTK
 * @Date: 2021/6/25 16:05
 * @Description:
 */

@Data
@ToString(callSuper = true)
public class ProjectArchiveRecordDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 项目档案id
     */
    @ApiModelProperty("项目档案id")
    private String projectArchiveId;

    /**
     * 档案记录id
     */
    @ApiModelProperty("档案记录id")
    private String archiveRecordId;

    /**
     * json内容
     */
    @ApiModelProperty("json内容")
    private String jsonContent;

    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("json项目内容")
    private String jsonProject;
}