/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.alertNumberDTO;
import com.ifourthwall.dbm.asset.dto.seer.GetLineChartDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListBySystemDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListBySystemQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListByTimeDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListByTimeQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingRepairDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryRecordingRepairQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartDTO;
import com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageQuDTO;
import com.ifourthwall.dbm.asset.facade.SentryFacade;
import com.ifourthwall.dbm.sentry.bo.AllTranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRecordingQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.TranslationDoBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.service.SentryService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.sentry.util.DateTools;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="SentryServiceImpl")
public class SentryServiceImpl
implements SentryService {
    private static final Logger log = LoggerFactory.getLogger(SentryServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Reference(version="1.0.0")
    private SentryFacade sentryFacade;

    public BaseResponse<List<QueryLineChartDTO>> queryLineChart(QueryLineChartQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            ArrayList<QueryLineChartDTO> resultList = new ArrayList<QueryLineChartDTO>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingListByTimeQuDTO queryRecording = new QueryRecordingListByTimeQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                queryRecording.setTimeTypeId("3");
            } else {
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            List recordingPage = this.monitorRepository.queryRecordingListByTime(queryRecording);
            if ("1".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u4eca\u5929");
                Date dayBegin = DataUtils.getDayBegin();
                for (int i = 0; i < 24; ++i) {
                    Date startDate = DateUtils.addHours((Date)formatHour.parse(query.getStartTime()), (int)i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("2".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb7\u5929");
                for (int i = 1; i < 8; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)now, (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb30\u5929");
                for (int i = 1; i < 31; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)formatDay.parse(query.getStartTime()), (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u6708\u4efd\u67e5\u8be2");
                Date d2 = DateTools.paraseStringToDate((String)query.getStartTime());
                List lst4 = DateTools.getAllDaysMonthByDate((Date)d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u5e74\u4efd\u67e5\u8be2");
                for (int i = 0; i < 12; ++i) {
                    Date startDate = DateUtils.addMonths((Date)formatDay.parse(query.getEndTime()), (int)(-i));
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<AlertNumberRankingByDateDTO> alertNumberRankingByDate(AlertNumberRankingByDateQuDTO rankingQuDTO, IFWUser user) {
        BaseResponse response = new BaseResponse();
        AlertNumberRankingByDateDTO result = new AlertNumberRankingByDateDTO();
        ArrayList<alertNumberDTO> resultList = new ArrayList<alertNumberDTO>();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String tenantId = CheckAccessUtils.judgeTenantId((String)rankingQuDTO.getTenantId(), (IFWUser)user);
            rankingQuDTO.setTenantId(tenantId);
            TranslationDoBO translationDoBO = new TranslationDoBO();
            translationDoBO.setLanguageCode(rankingQuDTO.getLanguageCode());
            AllTranslationDoBO allTranslationDoBO = this.assetRepository.allTranslation(translationDoBO);
            for (Map.Entry tagIds : allTranslationDoBO.getSystem().entrySet()) {
                alertNumberDTO alertNumberRanking = new alertNumberDTO();
                alertNumberRanking.setTagName((String)tagIds.getValue());
                alertNumberRanking.setTagId((String)tagIds.getKey());
                resultList.add(alertNumberRanking);
            }
            QueryRecordingQueryDoBO queryRecordingList = new QueryRecordingQueryDoBO();
            queryRecordingList.setProjectId(rankingQuDTO.getProjectId());
            queryRecordingList.setBeginTime(rankingQuDTO.getStartTime());
            queryRecordingList.setEndTime(rankingQuDTO.getEndTime());
            queryRecordingList.setLanguageCode(rankingQuDTO.getLanguageCode());
            queryRecordingList.setTenantId(rankingQuDTO.getTenantId());
            List recordingAllList = this.monitorRepository.queryRecordingList(queryRecordingList).getResult();
            for (alertNumberDTO tagId : resultList) {
                if (DataUtils.isListAvali((List)recordingAllList)) {
                    List collect = recordingAllList.stream().filter(a -> a.getAssetSystemId() != null).collect(Collectors.toList());
                    queryRecordingList.setAssetSystemId(tagId.getTagId());
                    List recordingList = this.monitorRepository.queryRecordingList(queryRecordingList).getResult();
                    if (DataUtils.isListAvali((List)recordingList)) {
                        tagId.setAlertNumber(Integer.valueOf(recordingList.size()));
                        continue;
                    }
                    tagId.setAlertNumber(Integer.valueOf(0));
                    continue;
                }
                tagId.setAlertNumber(Integer.valueOf(0));
            }
            if (DataUtils.isListAvali(resultList)) {
                List collect = resultList.stream().sorted(Comparator.comparing(alertNumberDTO::getAlertNumber).reversed()).collect(Collectors.toList());
                result.setRankInfo(collect);
            } else {
                result.setRankInfo(resultList);
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryLineChartRepairDTO>> queryLineChartRepair(QueryLineChartRepairQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            ArrayList<QueryLineChartRepairDTO> resultList = new ArrayList<QueryLineChartRepairDTO>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingRepairQuDTO queryRecording = new QueryRecordingRepairQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                queryRecording.setTimeTypeId("3");
            } else {
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            List recordingPage = this.monitorRepository.queryRecordingRepair(queryRecording);
            if ("1".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u4eca\u5929");
                Date dayBegin = DataUtils.getDayBegin();
                for (int i = 0; i < 24; ++i) {
                    Date startDate = DateUtils.addHours((Date)formatHour.parse(query.getStartTime()), (int)i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("2".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb7\u5929");
                for (int i = 1; i < 8; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)formatDay.parse(query.getStartTime()), (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb30\u5929");
                for (int i = 1; i < 31; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)formatDay.parse(query.getStartTime()), (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u6708\u4efd\u67e5\u8be2");
                Date d2 = DateTools.paraseStringToDate((String)query.getStartTime());
                List lst4 = DateTools.getAllDaysMonthByDate((Date)d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u5e74\u4efd\u67e5\u8be2");
                for (int i = 0; i < 12; ++i) {
                    Date startDate = DateUtils.addMonths((Date)formatDay.parse(query.getEndTime()), (int)(-i));
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<MonitorPercentageDTO> monitorPercentage(MonitorPercentageQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.sentryFacade.monitorPercentage(query);
    }

    public BaseResponse<QuerySeerLineChartDTO> querySeerLineChart(QuerySeerLineChartQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            QuerySeerLineChartDTO result = new QuerySeerLineChartDTO();
            ArrayList<QueryLineChartDTO> resultList = new ArrayList<QueryLineChartDTO>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingListBySystemQuDTO queryRecording = new QueryRecordingListBySystemQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            queryRecording.setAssetSystemId(query.getAssetSystemId());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                queryRecording.setTimeTypeId("3");
            } else {
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            QueryRecordingListBySystemDTO recordingInfo = this.monitorRepository.queryRecordingListBySystem(queryRecording);
            result.setAlertNumber(recordingInfo.getAlertNumber());
            result.setAssetNumber(recordingInfo.getAssetNumber());
            if ("1".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u4eca\u5929");
                Date dayBegin = DataUtils.getDayBegin();
                for (int i = 0; i < 24; ++i) {
                    Date startDate = DateUtils.addHours((Date)formatHour.parse(query.getStartTime()), (int)i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (DataUtils.isListAvali((List)recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("2".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb7\u5929");
                for (int i = 1; i < 8; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)formatDay.parse(query.getStartTime()), (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (DataUtils.isListAvali((List)recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u8fc7\u53bb30\u5929");
                for (int i = 1; i < 31; ++i) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays((Date)formatDay.parse(query.getStartTime()), (int)(-i));
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (DataUtils.isListAvali((List)recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u6708\u4efd\u67e5\u8be2");
                Date d2 = DateTools.paraseStringToDate((String)query.getStartTime());
                List lst4 = DateTools.getAllDaysMonthByDate((Date)d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (DataUtils.isListAvali((List)recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("\u67e5\u8be2\u5e74\u4efd\u67e5\u8be2");
                for (int i = 0; i < 12; ++i) {
                    Date startDate = DateUtils.addMonths((Date)formatDay.parse(query.getEndTime()), (int)(-i));
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(Integer.valueOf(0));
                    if (DataUtils.isListAvali((List)recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (!resultTime.equals(queryInfo.getCreateDate())) continue;
                            queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            result.setLineChartInfo(resultList);
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public void getLineChartInfo(GetLineChartDTO query) {
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        String time = "14:10-15:00,14:00-14:05";
        String[] split = time.split(",");
        Object send = null;
        Object one = null;
        Object two = null;
        for (String s : split) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            String[] split1 = s.split("-");
            String s2 = split1[0];
            String s3 = split1[1];
            Date parse1 = format.parse(s2);
            Date parse2 = format.parse(s3);
            Date date = format.parse(format.format(new Date()));
        }
    }
}

