/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.app.CheckMeterDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetAppFacade;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.service.SentryAppService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SentryAppServiceImpl")
public class SentryAppServiceImpl
implements SentryAppService {
    private static final Logger log = LoggerFactory.getLogger(SentryAppServiceImpl.class);
    @Reference(version="1.0.0")
    private AssetAppFacade assetAppFacade;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    public BaseResponse<List<QueryAssetAppListDTO>> queryAssetAppList(QueryAssetAppListQuDTO assetList, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)assetList.getTenantId(), (IFWUser)user);
            assetList.setTenantId(tenantId);
            List queryAssetAppListDTOS = this.assetRepository.queryAssetAppList(assetList);
            if (queryAssetAppListDTOS != null) {
                for (QueryAssetAppListDTO queryAssetAppListDTO : queryAssetAppListDTOS) {
                    if (!DataUtils.isListAvali((List)queryAssetAppListDTO.getCheckMeterInfo())) continue;
                    for (CheckMeterDTO checkMeterDTO : queryAssetAppListDTO.getCheckMeterInfo()) {
                        QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                        queryRuleAndStartBO.setDataPointId(checkMeterDTO.getDataPointId());
                        QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                        if (queryRuleAndStartDoBO == null) continue;
                        checkMeterDTO.setUnit(queryRuleAndStartDoBO.getUnit());
                    }
                }
            }
            response.setData((Object)queryAssetAppListDTOS);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}

