/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.AlertRulesDTO;
import com.ifourthwall.dbm.asset.dto.GodzillaBindingInfo;
import com.ifourthwall.dbm.asset.dto.QueryIndexRankingDTO;
import com.ifourthwall.dbm.asset.dto.QueryIndexRankingQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryIndexStatisticsBasisDTO;
import com.ifourthwall.dbm.asset.dto.QueryIndexStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.QueryIndexStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO;
import com.ifourthwall.dbm.asset.dto.QueryTagInfoListDTO;
import com.ifourthwall.dbm.asset.dto.QueryTagInfoListQuDTO;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListBasisDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentBasisQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.SeerTagMoveDTO;
import com.ifourthwall.dbm.asset.dto.seer.SqDepositSenrtyInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphBasisDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsBasisQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoBasisDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.sentry.bo.AllTranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceQueryBO;
import com.ifourthwall.dbm.sentry.bo.GodzillaInfoBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceSubListQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetListQueryBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorListDoQueryBO;
import com.ifourthwall.dbm.sentry.bo.QueryNextSonListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryNextSonListQuDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryTagInfoListQuBO;
import com.ifourthwall.dbm.sentry.bo.SeerAlarmNumBO;
import com.ifourthwall.dbm.sentry.bo.TranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.UpdateAlarmNumberBO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordDoBO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordQuDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.QueryEnvironmentListDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.QueryMonitorMetricListDoBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.CameraRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorTargetTagRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.domain.TaskRepository;
import com.ifourthwall.dbm.sentry.dto.DataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryInfoByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryMetricIdDTO;
import com.ifourthwall.dbm.sentry.service.SeerService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="SeerServiceImpl")
public class SeerServiceImpl
implements SeerService {
    private static final Logger log = LoggerFactory.getLogger(SeerServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Reference(version="1.0.0")
    private MonitorFacade monitorFacade;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="MonitorTargetTagRepository")
    private MonitorTargetTagRepository targetTagRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;
    @Resource(name="TaskRepository")
    private TaskRepository taskRepository;
    @Resource(name="CameraRepository")
    private CameraRepository cameraRepository;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;
    @Value(value="${sq.app.id}")
    private String appId;
    @Value(value="${sq.project.id}")
    private String projectId;
    @Value(value="${sq.tenant.id}")
    private String tenantId;
    @Value(value="${sq.tag.water}")
    private String waterId;
    @Value(value="${sq.tag.electricity}")
    private String electricityId;
    public static DateTimeFormatter dateTimeFormatterFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource(name="IFWKafkaClient-dbm_sentry_update_space_special_alarm_num")
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;
    private static final int FRACTION_MIN_WIDTH = 0;
    private static final int FRACTION_MAX_WIDTH = 9;
    private static final boolean ADD_DECIMAL_POINT = true;
    public static final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendZoneOrOffsetId().toFormatter();

    public BaseResponse<List<SeerQueryTagDTO>> seerQueryTag(SeerQueryTagQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long nowTime = System.currentTimeMillis();
            long Tenminute = nowTime - 300000L;
            Long timeStamp = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = sdf.format(new Date(Long.parseLong(String.valueOf(nowTime))));
            String ten = sdf.format(new Date(Long.parseLong(String.valueOf(Tenminute))));
            ArrayList<SeerQueryTagDTO> resultList = new ArrayList<SeerQueryTagDTO>();
            if (DataUtils.isListAvali((List)query.getSpaceIdList())) {
                for (String id : query.getSpaceIdList()) {
                    log.info("redis\u67e5\u8be2id\u4e3a\uff1a" + id);
                    SeerAlarmNumBO number = (SeerAlarmNumBO)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew((String)id));
                    log.info("redis\u67e5\u8be2\u6570\u636e\u4e3a\uff1a" + number);
                    SeerQueryTagDTO result = new SeerQueryTagDTO();
                    result.setSpaceId(id);
                    Integer alertNumber = 0;
                    GetSonSpaceQueryBO getSonSpaceQueryBO = new GetSonSpaceQueryBO();
                    getSonSpaceQueryBO.setSpaceId(id);
                    GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(getSonSpaceQueryBO);
                    QueryAlarmRecordQuDoBO queryCameraList = new QueryAlarmRecordQuDoBO();
                    queryCameraList.setSpaceId(sonpace.getSpaceId());
                    queryCameraList.setProjectId(query.getProjectId());
                    queryCameraList.setLanguageCode(query.getLanguageCode());
                    queryCameraList.setTenantId(tenantId);
                    queryCameraList.setStartTime(ten);
                    queryCameraList.setEndTime(now);
                    IFWPageInfo queryAlarmRecord = this.cameraRepository.queryAlarmRecord(queryCameraList);
                    if (queryAlarmRecord != null) {
                        ArrayList<String> cameraType = new ArrayList<String>();
                        Map<String, List<QueryAlarmRecordDoBO>> typeMap = queryAlarmRecord.getList().stream().filter(a -> a.getCameraEventTypeId() != null).collect(Collectors.groupingBy(QueryAlarmRecordDoBO::getCameraEventTypeId));
                        for (Map.Entry<String, List<QueryAlarmRecordDoBO>> type : typeMap.entrySet()) {
                            cameraType.add(type.getKey());
                        }
                        List cameraId = queryAlarmRecord.getList().stream().map(QueryAlarmRecordDoBO::getCameraId).distinct().collect(Collectors.toList());
                        result.setCameraId(cameraId);
                        result.setCameraInfoType(cameraType);
                    }
                    if (number == null) {
                        result.setAlarmNumber(alertNumber);
                    } else {
                        result.setAlarmNumber(number.getNumber());
                        if (DataUtils.isListAvali((List)number.getAssetIds())) {
                            result.setAssetId(number.getAssetIds());
                        }
                    }
                    resultList.add(result);
                }
            } else {
                QueryNextSonListQuDoBO queryNextSonList = new QueryNextSonListQuDoBO();
                queryNextSonList.setSpaceId(query.getSpaceId());
                queryNextSonList.setProjectId(query.getProjectId());
                queryNextSonList.setLanguageCode(query.getLanguageCode());
                queryNextSonList.setTenantId(query.getTenantId());
                QueryNextSonListDoBO nextSonList = this.spaceRepository.queryNextSonList(queryNextSonList);
                if (nextSonList != null) {
                    for (String id : nextSonList.getSpaceId()) {
                        SeerAlarmNumBO number = (SeerAlarmNumBO)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew((String)id));
                        log.info("redis\u67e5\u8be2\u7ed3\u679c\uff1a" + number);
                        SeerQueryTagDTO result = new SeerQueryTagDTO();
                        result.setSpaceId(id);
                        Integer alertNumber = 0;
                        if (number == null) {
                            result.setAlarmNumber(alertNumber);
                        } else {
                            result.setAlarmNumber(number.getNumber());
                            if (DataUtils.isListAvali((List)number.getAssetIds())) {
                                result.setAssetId(number.getAssetIds());
                            }
                        }
                        GetSonSpaceQueryBO getSonSpaceQueryBO = new GetSonSpaceQueryBO();
                        getSonSpaceQueryBO.setSpaceId(id);
                        GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(getSonSpaceQueryBO);
                        QueryAlarmRecordQuDoBO queryCameraList = new QueryAlarmRecordQuDoBO();
                        queryCameraList.setSpaceId(sonpace.getSpaceId());
                        queryCameraList.setProjectId(query.getProjectId());
                        queryCameraList.setLanguageCode(query.getLanguageCode());
                        queryCameraList.setTenantId(tenantId);
                        queryCameraList.setStartTime(ten);
                        queryCameraList.setEndTime(now);
                        IFWPageInfo queryAlarmRecord = this.cameraRepository.queryAlarmRecord(queryCameraList);
                        if (queryAlarmRecord != null) {
                            ArrayList<String> cameraType = new ArrayList<String>();
                            Map<String, List<QueryAlarmRecordDoBO>> typeMap = queryAlarmRecord.getList().stream().filter(a -> a.getCameraEventTypeId() != null).collect(Collectors.groupingBy(QueryAlarmRecordDoBO::getCameraEventTypeId));
                            for (Map.Entry<String, List<QueryAlarmRecordDoBO>> type : typeMap.entrySet()) {
                                cameraType.add(type.getKey());
                            }
                            List cameraId = queryAlarmRecord.getList().stream().map(QueryAlarmRecordDoBO::getCameraId).distinct().collect(Collectors.toList());
                            result.setCameraId(cameraId);
                            result.setCameraInfoType(cameraType);
                        }
                        resultList.add(result);
                    }
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryIndexStatisticsDTO> queryIndexStatistics(QueryIndexStatisticsQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
            QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
            queryTagInfoList.setTagId(query.getTargetTagId());
            queryTagInfoList.setLanguageCode("CN");
            List queryTagInfoListBO = this.targetTagRepository.queryTagInfoList(queryTagInfoList);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("\u4e0d\u5b58\u5728appId\uff0c\u8bf7\u7533\u8bf7!", "15");
            }
            if (DataUtils.isListAvali((List)queryTagInfoListBO)) {
                QueryIndexStatisticsDTO water;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date startTime = DataUtils.getDayBegin();
                Date endTime = DataUtils.getDayEnd();
                Date beginDayOfTomorrow = DataUtils.getBeginDayOfTomorrow();
                Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                BigDecimal number = new BigDecimal("0");
                List notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getDataPointId())).collect(Collectors.toList());
                for (QueryTagInfoListDTO queryInfo : notNullList) {
                    MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                    metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                    metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                    metricValueRecordListReqBO.setStartTime(startTime);
                    metricValueRecordListReqBO.setEndTime(endTime);
                    MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                    if (nowGodzillaInfo == null || !DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) continue;
                    GodzillaInfoBO godzillaInfoBO = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(0);
                    GodzillaInfoBO godzillaInfoBO1 = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                    BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                    BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                    log.info("\u7b2c\u4e00\u6761\u6570\u636e\u503c\u4e3a:" + vaule1);
                    log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u503c\u4e3a:" + vaule2);
                    TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                    LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                    int hour1 = isoTime1.getHour();
                    TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                    LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                    int hour2 = isoTime2.getHour();
                    if (vaule1.equals(vaule2)) {
                        number = number.add(new BigDecimal("0"));
                        continue;
                    }
                    if (vaule1.equals(vaule2)) continue;
                    if (hour1 > hour2) {
                        number = number.add(vaule1.subtract(vaule2));
                    }
                    if (hour1 >= hour2) continue;
                    number = number.add(vaule2.subtract(vaule1));
                }
                if ("1".equals(query.getType())) {
                    QueryIndexStatisticsDTO electricity = (QueryIndexStatisticsDTO)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getCameraCountInfoType((String)"1"));
                    if (electricity != null) {
                        log.info("redis\u6570\u636e\uff1a" + electricity);
                        result.setTodayIndexInfo(electricity.getTodayIndexInfo());
                        result.setYesterdayIndexInfo(electricity.getYesterdayIndexInfo());
                    }
                } else if ("2".equals(query.getType()) && (water = (QueryIndexStatisticsDTO)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getCameraCountInfoType((String)"2"))) != null) {
                    log.info("redis\u6570\u636e\uff1a" + water);
                    result.setTodayIndexInfo(water.getTodayIndexInfo());
                    result.setYesterdayIndexInfo(water.getYesterdayIndexInfo());
                }
                result.setNumber(number);
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryIndexRankingDTO>> queryIndexRanking(QueryIndexRankingQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            ArrayList<QueryIndexRankingDTO> resultList = new ArrayList<QueryIndexRankingDTO>();
            QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("\u4e0d\u5b58\u5728appId\uff0c\u8bf7\u7533\u8bf7!", "15");
            }
            TranslationDoBO translationDoBO = new TranslationDoBO();
            translationDoBO.setLanguageCode(query.getLanguageCode());
            AllTranslationDoBO allTranslationDoBO = this.assetRepository.allTranslation(translationDoBO);
            for (Map.Entry tagIds : allTranslationDoBO.getSystem().entrySet()) {
                QueryIndexRankingDTO resultDTO = new QueryIndexRankingDTO();
                resultDTO.setTargetTagId((String)tagIds.getKey());
                resultDTO.setTargetTagName((String)tagIds.getValue());
                QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
                queryTagInfoList.setTagId(query.getTargetTagId());
                queryTagInfoList.setLanguageCode("CN");
                queryTagInfoList.setAssetSystemId((String)tagIds.getKey());
                List queryTagInfoListBO = this.targetTagRepository.queryTagInfoList(queryTagInfoList);
                Date startTime = DataUtils.getDayBegin();
                Date endTime = DataUtils.getDayEnd();
                Date beginDayOfTomorrow = DataUtils.getBeginDayOfTomorrow();
                Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                BigDecimal number = new BigDecimal("0");
                List notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getDataPointId())).collect(Collectors.toList());
                if (DataUtils.isListAvali(notNullList)) {
                    for (QueryTagInfoListDTO queryInfo : notNullList) {
                        MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                        metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                        metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                        metricValueRecordListReqBO.setStartTime(startTime);
                        metricValueRecordListReqBO.setEndTime(endTime);
                        MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                        if (nowGodzillaInfo == null || !DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) continue;
                        GodzillaInfoBO godzillaInfoBO = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(0);
                        GodzillaInfoBO godzillaInfoBO1 = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                        BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                        BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                        log.info("\u7b2c\u4e00\u6761\u6570\u636e\u503c\u4e3a:" + vaule1);
                        log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u503c\u4e3a:" + vaule2);
                        TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                        LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                        int hour1 = isoTime1.getHour();
                        TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                        LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                        int hour2 = isoTime2.getHour();
                        if (vaule1.equals(vaule2)) {
                            number = number.add(new BigDecimal("0"));
                        } else if (!vaule1.equals(vaule2)) {
                            if (hour1 > hour2) {
                                number = number.add(vaule1.subtract(vaule2));
                            }
                            if (hour1 < hour2) {
                                number = number.add(vaule2.subtract(vaule1));
                            }
                        }
                        log.info("\u76f8\u89c1\u540e\u6570\u503c\u4e3a\uff1a" + number);
                    }
                }
                resultDTO.setNumber(number);
                resultList.add(resultDTO);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryEnvironmentDTO> queryEnvironment(QueryEnvironmentBasisQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        QueryEnvironmentDTO result = new QueryEnvironmentDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            Integer normalNumber = 0;
            Integer abnormalNumber = 0;
            if (DataUtils.isListAvali((List)query.getMonitorMetricTargetId())) {
                QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
                queryMonitorList.setTenantId(tenantId);
                queryMonitorList.setLanguageCode(query.getLanguageCode());
                queryMonitorList.setMonitorTargetId(query.getMonitorMetricTargetId());
                queryMonitorList.setProjectId(query.getProjectId());
                IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorList);
                if (monitorList != null) {
                    Map<String, List<QueryMonitorListDoBO>> spaceMap = monitorList.getList().stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getAssetStatus())).collect(Collectors.groupingBy(QueryMonitorListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryMonitorListDoBO>> space : spaceMap.entrySet()) {
                        List normal = space.getValue().stream().filter(a -> "2".equals(a.getAssetStatus())).collect(Collectors.toList());
                        if (DataUtils.isListAvali(normal)) {
                            abnormalNumber = abnormalNumber + 1;
                            continue;
                        }
                        normalNumber = normalNumber + 1;
                    }
                }
            }
            result.setAbnormalNumber(abnormalNumber);
            result.setNormalNumber(normalNumber);
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<EnvironmentListDTO>> queryEnvironmentList(QueryEnvironmentListQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        ArrayList<EnvironmentListDTO> resultList = new ArrayList<EnvironmentListDTO>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            if (DataUtils.isListAvali((List)query.getMonitorMetricTargetId()) || DataUtils.isListAvali((List)query.getDataPointId()) || DataUtils.isListAvali((List)query.getMonitorMetricTargetId())) {
                List environmentList = this.monitorRepository.queryMonitorMetricList((QueryMonitorMetricListDoBO)IFWBeanCopyUtil.map((Object)query, QueryMonitorMetricListDoBO.class));
                if (environmentList != null) {
                    Map<String, List<QueryEnvironmentListDoBO>> monitorMetricMap = environmentList.stream().collect(Collectors.groupingBy(QueryEnvironmentListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryEnvironmentListDoBO>> spaceInfo : monitorMetricMap.entrySet()) {
                        EnvironmentListDTO result = new EnvironmentListDTO();
                        ArrayList<EnvironmentListBasisDTO> resultBasisList = new ArrayList<EnvironmentListBasisDTO>();
                        result.setSpaceId(spaceInfo.getKey());
                        ArrayList<String> spaceIds = new ArrayList<String>();
                        spaceIds.add(spaceInfo.getKey());
                        GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                        getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                        getNewPathBatchQueryBO.setProjectId(query.getProjectId());
                        getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
                        getNewPathBatchQueryBO.setTenantId(tenantId);
                        List newPathBatch = this.spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                        if (DataUtils.isListAvali((List)newPathBatch)) {
                            result.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                        }
                        for (QueryEnvironmentListDoBO monitorMetricInfo : spaceInfo.getValue()) {
                            EnvironmentListBasisDTO resultBasis = new EnvironmentListBasisDTO();
                            resultBasis.setName(monitorMetricInfo.getMonitorMetricName());
                            resultBasis.setMonitorTargetTagPicture(monitorMetricInfo.getMonitorTargetTagPicture());
                            QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                            queryRuleAndStartBO.setDataPointId(monitorMetricInfo.getDataPointId());
                            log.info("\u67e5\u8be2\u70b9\u4f4d\uff1a" + monitorMetricInfo);
                            QueryRuleAndStartDoBO ruleAndStart = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                            log.info("\u67e5\u8be2\u6570\u636e\uff1a" + ruleAndStart);
                            if (ruleAndStart != null) {
                                resultBasis.setUnit(ruleAndStart.getUnit());
                                resultBasis.setValue(ruleAndStart.getCurrentValue());
                            }
                            if (StringUtils.isEmpty((CharSequence)monitorMetricInfo.getMonitorMetricStatusId())) {
                                resultBasis.setMonitorMetricStatusId("1");
                                result.setSpaceStatus("1");
                            } else {
                                if ("1".equals(monitorMetricInfo.getMonitorMetricStatusId())) {
                                    resultBasis.setMonitorMetricStatusId(monitorMetricInfo.getMonitorMetricStatusId());
                                    result.setSpaceStatus("1");
                                    log.info("\u8bbe\u5907\u6b63\u5e38");
                                }
                                if ("2".equals(monitorMetricInfo.getMonitorMetricStatusId())) {
                                    result.setSpaceStatus("2");
                                    if (DataUtils.isListAvali((List)ruleAndStart.getAlarmInfo())) {
                                        int rules = 0;
                                        for (AlertRulesDTO alertRulesDTO : ruleAndStart.getAlarmInfo()) {
                                            if (rules != 0) continue;
                                            BigDecimal value = new BigDecimal(ruleAndStart.getCurrentValue());
                                            BigDecimal max = new BigDecimal(alertRulesDTO.getAlarmMaximumValue());
                                            BigDecimal min = new BigDecimal(alertRulesDTO.getAlarmMinimumValue());
                                            int a = value.compareTo(max);
                                            int b = value.compareTo(min);
                                            if (a != 1) {
                                                resultBasis.setMonitorMetricStatusId("2");
                                                ++rules;
                                                log.info("\u5927\u4e8e\u9884\u503c");
                                            }
                                            if (b == -1) continue;
                                            resultBasis.setMonitorMetricStatusId("3");
                                            ++rules;
                                            log.info("\u5c0f\u4e8e\u9884\u503c");
                                        }
                                    }
                                }
                            }
                            resultBasis.setMonitorTargetTagPicture(monitorMetricInfo.getMonitorTargetTagPicture());
                            resultBasisList.add(resultBasis);
                        }
                        result.setMonitorMetricInfo(resultBasisList);
                        resultList.add(result);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)query.getSpaceName())) {
                    ProjectSpaceSubListQueryDoBO querySpaceList = new ProjectSpaceSubListQueryDoBO();
                    querySpaceList.setLanguageCode(query.getLanguageCode());
                    querySpaceList.setProjectId(query.getProjectId());
                    querySpaceList.setNameLike(query.getSpaceName());
                    querySpaceList.setTenantId(tenantId);
                    List sonSpaceList = this.spaceRepository.getSonSpaceList(querySpaceList);
                    if (sonSpaceList != null) {
                        ArrayList<EnvironmentListDTO> spaceResultList = new ArrayList<EnvironmentListDTO>();
                        for (EnvironmentListDTO result : resultList) {
                            for (ProjectSpaceBaseDoBO space : sonSpaceList) {
                                if (!StringUtils.equals((CharSequence)result.getSpaceId(), (CharSequence)space.getProjectSpaceId())) continue;
                                spaceResultList.add(result);
                            }
                        }
                        response.setData(spaceResultList);
                    } else {
                        response.setData(null);
                    }
                } else {
                    response.setData(resultList);
                }
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryInductionDTO> queryInduction(QueryInductionQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        QueryInductionDTO result = new QueryInductionDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            Integer totalNumber = 0;
            Integer noPeopelSpaceNumber = 0;
            Integer peopelSpaceNumber = 0;
            if (DataUtils.isListAvali((List)query.getMonitorMetricTargetId())) {
                QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
                queryMonitorList.setTenantId(tenantId);
                queryMonitorList.setLanguageCode(query.getLanguageCode());
                queryMonitorList.setMonitorTargetId(query.getMonitorMetricTargetId());
                queryMonitorList.setProjectId(query.getProjectId());
                IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorList);
                if (monitorList != null) {
                    Map<String, List<QueryMonitorListDoBO>> spaceMap = monitorList.getList().stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getAssetStatus())).collect(Collectors.groupingBy(QueryMonitorListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryMonitorListDoBO>> space : spaceMap.entrySet()) {
                        totalNumber = totalNumber + 1;
                        List normal = space.getValue().stream().filter(a -> "2".equals(a.getAssetStatus())).collect(Collectors.toList());
                        if (DataUtils.isListAvali(normal)) {
                            peopelSpaceNumber = peopelSpaceNumber + 1;
                            continue;
                        }
                        noPeopelSpaceNumber = noPeopelSpaceNumber + 1;
                    }
                }
            }
            result.setTotalNumber(totalNumber);
            result.setNoPeopelSpaceNumber(noPeopelSpaceNumber);
            result.setPeopelSpaceNumber(peopelSpaceNumber);
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryInductionListDTO>> queryInductionList(QueryInductionListQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        ArrayList<QueryInductionListDTO> resultList = new ArrayList<QueryInductionListDTO>();
        try {
            List environmentList;
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            if ((DataUtils.isListAvali((List)query.getMonitorMetricTargetId()) || DataUtils.isListAvali((List)query.getDataPointId()) || DataUtils.isListAvali((List)query.getMonitorMetricTargetId())) && (environmentList = this.monitorRepository.queryMonitorMetricList((QueryMonitorMetricListDoBO)IFWBeanCopyUtil.map((Object)query, QueryMonitorMetricListDoBO.class))) != null) {
                Map<String, List<QueryEnvironmentListDoBO>> monitorMetricMap = environmentList.stream().collect(Collectors.groupingBy(QueryEnvironmentListDoBO::getProjectSpaceId));
                for (Map.Entry<String, List<QueryEnvironmentListDoBO>> spaceInfo : monitorMetricMap.entrySet()) {
                    List use;
                    QueryInductionListDTO result = new QueryInductionListDTO();
                    result.setSpaceId(spaceInfo.getKey());
                    result.setTotalNumber(Integer.valueOf(spaceInfo.getValue().size()));
                    ArrayList<String> spaceIds = new ArrayList<String>();
                    spaceIds.add(spaceInfo.getKey());
                    GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                    getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                    getNewPathBatchQueryBO.setProjectId(query.getProjectId());
                    getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
                    getNewPathBatchQueryBO.setTenantId(tenantId);
                    List newPathBatch = this.spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                    if (DataUtils.isListAvali((List)newPathBatch)) {
                        result.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                    }
                    if (DataUtils.isListAvali(use = spaceInfo.getValue().stream().filter(status -> "2".equals(status.getMonitorMetricStatusId())).collect(Collectors.toList()))) {
                        result.setUseNumber(Integer.valueOf(use.size()));
                    } else {
                        result.setUseNumber(Integer.valueOf(0));
                    }
                    resultList.add(result);
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryEnergyStatisticsDTO> queryEnergyStatistics(QueryEnergyStatisticsQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        QueryEnergyStatisticsDTO result = new QueryEnergyStatisticsDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startTime = DataUtils.getDayBegin();
            Date endTime = DataUtils.getDayEnd();
            Date YesterdayStartTime = DataUtils.getBeginDayOfYesterday();
            Date YesterdayEndTime = DataUtils.getEndDayOfYesterDay();
            BigDecimal todayEnergyNumber = new BigDecimal("0");
            BigDecimal yesterdayEnergyNumber = new BigDecimal("0");
            if (DataUtils.isListAvali((List)query.getDataPointInfo())) {
                for (QueryEnergyStatisticsBasisQuDTO dataPointId : query.getDataPointInfo()) {
                    MetricValueRecordListReqBO todayQuery = new MetricValueRecordListReqBO();
                    todayQuery.setDataPointId(dataPointId.getDataPointId());
                    todayQuery.setAppId(queryAppIdBO.getAppId());
                    todayQuery.setStartTime(startTime);
                    todayQuery.setEndTime(endTime);
                    MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(todayQuery);
                    MetricValueRecordListReqBO yesterdayQuery = new MetricValueRecordListReqBO();
                    yesterdayQuery.setDataPointId(dataPointId.getDataPointId());
                    yesterdayQuery.setAppId(queryAppIdBO.getAppId());
                    yesterdayQuery.setStartTime(YesterdayStartTime);
                    yesterdayQuery.setEndTime(YesterdayEndTime);
                    MetricValueRecordListBO yesterdayInfo = this.godzillaServerRepository.queryMetricValueRecordList(yesterdayQuery);
                    if ("2".equals(dataPointId)) {
                        int hour2;
                        LocalTime isoTime2;
                        TemporalAccessor parse2;
                        int hour1;
                        LocalTime isoTime1;
                        TemporalAccessor parse1;
                        BigDecimal vaule2;
                        BigDecimal vaule1;
                        GodzillaInfoBO godzillaInfoBO1;
                        GodzillaInfoBO godzillaInfoBO;
                        if (nowGodzillaInfo != null && DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) {
                            godzillaInfoBO = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(0);
                            godzillaInfoBO1 = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                            log.info("\u7b2c\u4e00\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO);
                            log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO1);
                            vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                            vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                            log.info("\u7b2c\u4e00\u6761\u6570\u636e\u503c\u4e3a:" + vaule1);
                            log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u503c\u4e3a:" + vaule2);
                            parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                            isoTime1 = parse1.query(TemporalQueries.localTime());
                            hour1 = isoTime1.getHour();
                            parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                            isoTime2 = parse2.query(TemporalQueries.localTime());
                            hour2 = isoTime2.getHour();
                            if (vaule1.equals(vaule2)) {
                                todayEnergyNumber = todayEnergyNumber.add(vaule1);
                            } else if (!vaule1.equals(vaule2)) {
                                if (hour1 > hour2) {
                                    todayEnergyNumber = todayEnergyNumber.add(vaule1.subtract(vaule2));
                                }
                                if (hour1 < hour2) {
                                    todayEnergyNumber = todayEnergyNumber.add(vaule2.subtract(vaule1));
                                }
                            }
                        }
                        if (yesterdayInfo != null && DataUtils.isListAvali((List)yesterdayInfo.getCollectDataList())) {
                            godzillaInfoBO = (GodzillaInfoBO)yesterdayInfo.getCollectDataList().get(0);
                            godzillaInfoBO1 = (GodzillaInfoBO)yesterdayInfo.getCollectDataList().get(yesterdayInfo.getCollectDataList().size() - 1);
                            log.info("\u7b2c\u4e00\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO);
                            log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO1);
                            vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                            vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                            log.info("\u7b2c\u4e00\u6761\u6570\u636e\u503c\u4e3a:" + vaule1);
                            log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u503c\u4e3a:" + vaule2);
                            parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                            isoTime1 = parse1.query(TemporalQueries.localTime());
                            hour1 = isoTime1.getHour();
                            parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                            isoTime2 = parse2.query(TemporalQueries.localTime());
                            hour2 = isoTime2.getHour();
                            if (vaule1.equals(vaule2)) {
                                yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule1);
                            } else if (!vaule1.equals(vaule2)) {
                                if (hour1 > hour2) {
                                    yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule1.subtract(vaule2));
                                }
                                if (hour1 < hour2) {
                                    yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule2.subtract(vaule1));
                                }
                            }
                        }
                    }
                    if (!"1".equals(dataPointId)) continue;
                    if (nowGodzillaInfo != null && DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) {
                        for (GodzillaInfoBO godzillaInfoBO : nowGodzillaInfo.getCollectDataList()) {
                            log.info("\u7d2f\u52a0\u6570\u636e\u4e3a:" + godzillaInfoBO);
                            todayEnergyNumber.add(new BigDecimal(godzillaInfoBO.getValue()));
                        }
                    }
                    if (yesterdayInfo == null || !DataUtils.isListAvali((List)yesterdayInfo.getCollectDataList())) continue;
                    for (GodzillaInfoBO godzillaInfoBO : yesterdayInfo.getCollectDataList()) {
                        log.info("\u7d2f\u52a0\u6570\u636e\u4e3a:" + godzillaInfoBO);
                        yesterdayEnergyNumber.add(new BigDecimal(godzillaInfoBO.getValue()));
                    }
                }
            }
            result.setTodayEnergy(todayEnergyNumber);
            result.setYesterdayEnergy(yesterdayEnergyNumber);
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryEnergyComparedGraphDTO> queryEnergyComparedGraph(QueryEnergyComparedGraphQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            if (DataUtils.isListAvali((List)query.getDataPointId())) {
                for (String dataPointId : query.getDataPointId()) {
                    MetricValueRecordListReqBO queryList = new MetricValueRecordListReqBO();
                    queryList.setDataPointId(dataPointId);
                    queryList.setAppId(queryAppIdBO.getAppId());
                    queryList.setStartTime(query.getStartTime());
                    queryList.setEndTime(query.getEndTime());
                    MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(queryList);
                    if (nowGodzillaInfo == null || !DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) continue;
                    for (GodzillaInfoBO godzillaInfoBO : nowGodzillaInfo.getCollectDataList()) {
                        Date date = format.parse(godzillaInfoBO.getTime());
                        QueryEnergyComparedGraphBasisDTO result = new QueryEnergyComparedGraphBasisDTO();
                        if ("1".equals(query.getType())) {
                            int n = date.getHours();
                        }
                        if ("2".equals(query.getType())) {
                            // empty if block
                        }
                        if (!"3".equals(query.getType())) continue;
                    }
                }
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QuerySqEnvironmentInfoDTO>> querySqEnvironmentInfo(QuerySqEnvironmentInfoQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        ArrayList<QuerySqEnvironmentInfoDTO> resultList = new ArrayList<QuerySqEnvironmentInfoDTO>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            Date startTime = DataUtils.getDayBegin();
            Date endTime = DataUtils.getDayEnd();
            if (DataUtils.isListAvali((List)query.getTagInfo())) {
                for (QuerySqEnvironmentInfoBasisDTO queryInfo : query.getTagInfo()) {
                    QueryMonitorMetricListDoBO queryMonitorMetricListDoBO = new QueryMonitorMetricListDoBO();
                    queryMonitorMetricListDoBO.setProjectId(query.getProjectId());
                    queryMonitorMetricListDoBO.setMonitorTargetTagId(queryInfo.getMonitorTargetTagId());
                    queryMonitorMetricListDoBO.setLanguageCode(query.getLanguageCode());
                    List queryEnvironmentListDoBOS = this.monitorRepository.queryMonitorMetricList(queryMonitorMetricListDoBO);
                    if (queryEnvironmentListDoBOS == null) continue;
                    List dataPointIds = queryEnvironmentListDoBOS.stream().map(QueryEnvironmentListDoBO::getDataPointId).collect(Collectors.toList());
                    log.info("\u6570\u636e\u70b9\u4f4d\u4e3a\uff1a" + dataPointIds);
                    QuerySqEnvironmentInfoDTO result = new QuerySqEnvironmentInfoDTO();
                    result.setType(queryInfo.getType());
                    BigDecimal number = new BigDecimal(0);
                    int divisor = 0;
                    for (String dataPointId : dataPointIds) {
                        MetricValueRecordListReqBO queryList = new MetricValueRecordListReqBO();
                        queryList.setDataPointId(dataPointId);
                        queryList.setAppId(queryAppIdBO.getAppId());
                        queryList.setStartTime(startTime);
                        queryList.setEndTime(endTime);
                        MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(queryList);
                        if (nowGodzillaInfo == null || !DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) continue;
                        GodzillaInfoBO godzillaInfoBO = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(0);
                        GodzillaInfoBO godzillaInfoBO1 = (GodzillaInfoBO)nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                        log.info("\u7b2c\u4e00\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO);
                        log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u4e3a:" + godzillaInfoBO1);
                        BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                        BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                        log.info("\u7b2c\u4e00\u6761\u6570\u636e\u503c\u4e3a:" + vaule1);
                        log.info("\u6700\u540e\u4e00\u6761\u6761\u6570\u636e\u503c\u4e3a:" + vaule2);
                        TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                        LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                        int hour1 = isoTime1.getHour();
                        TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                        LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                        int hour2 = isoTime2.getHour();
                        number = number.add(vaule1);
                        ++divisor;
                    }
                    if (divisor != 0) {
                        BigDecimal resultNumber = number.divide(new BigDecimal(divisor), 2, 4);
                        result.setNumber(resultNumber);
                    }
                    resultList.add(result);
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse sqDepositSenrtyInfo(SqDepositSenrtyInfoDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            this.sqDepositSentryInfo();
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse seerTagMove(SeerTagMoveDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            QueryAssetListQueryBO queryAssetListQueryBO = new QueryAssetListQueryBO();
            queryAssetListQueryBO.setProjectId(query.getProjectId());
            queryAssetListQueryBO.setAssetStatus("2");
            queryAssetListQueryBO.setLanguageCode("CN");
            IFWPageInfo assetList = this.assetRepository.queryAssetList(queryAssetListQueryBO);
            if (assetList != null) {
                for (QueryAssetInfoBO queryAssetInfoBO : assetList.getList()) {
                    UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                    updateAlarmNumberBO.setType(Integer.valueOf(1));
                    updateAlarmNumberBO.setSpaceId(queryAssetInfoBO.getProjectSpaceId());
                    updateAlarmNumberBO.setAssetId(queryAssetInfoBO.getAssetId());
                    String sendInfo1 = JSONUtils.jacksonToJson((Object)updateAlarmNumberBO);
                    log.info("seer\u6807\u7b7e\u7edf\u8ba1\u6570\u91cf+1\uff0c\u5b58\u5165\u6570\u636e\u4e3a\uff1a" + sendInfo1);
                    this.ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                }
            }
            this.sqDepositSentryInfo();
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryTagInfoListDTO>> queryTagInfoList(QueryTagInfoListQuDTO query) {
        BaseResponse response = new BaseResponse();
        try {
            List queryTagInfoListBO = this.targetTagRepository.queryTagInfoList((QueryTagInfoListQuBO)IFWBeanCopyUtil.map((Object)query, QueryTagInfoListQuBO.class));
            if (DataUtils.isListAvali((List)queryTagInfoListBO)) {
                response.setData((Object)queryTagInfoListBO);
            } else {
                response.setData(null);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryMonitorListDTO>> queryMetricId(QueryMetricIdDTO query) {
        BaseResponse response = new BaseResponse();
        try {
            IFWPageInfo queryTagInfoListBO = this.monitorRepository.queryMonitorList((QueryMonitorListDoQueryBO)IFWBeanCopyUtil.map((Object)query, QueryMonitorListDoQueryBO.class));
            if (queryTagInfoListBO != null) {
                response.setData((Object)IFWBeanCopyUtil.mapAsList((Iterable)queryTagInfoListBO.getList(), QueryMonitorListDTO.class));
            } else {
                response.setData(null);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryInfoByDataPointDTO>> queryByDataPoint(QueryMetricIdDTO query) {
        BaseResponse response = new BaseResponse();
        try {
            IFWPageInfo queryTagInfoListBO = this.monitorRepository.queryMonitorList((QueryMonitorListDoQueryBO)IFWBeanCopyUtil.map((Object)query, QueryMonitorListDoQueryBO.class));
            if (DataUtils.isListAvali((List)queryTagInfoListBO.getList())) {
                ArrayList<QueryInfoByDataPointDTO> resultList = new ArrayList<QueryInfoByDataPointDTO>();
                List spaceIds = queryTagInfoListBO.getList().stream().map(QueryMonitorListDoBO::getProjectSpaceId).collect(Collectors.toList());
                GetNewPathBatchQueryBO queryName = new GetNewPathBatchQueryBO();
                queryName.setProjectSpaceId(spaceIds);
                queryName.setProjectId(query.getProjectId());
                queryName.setLanguageCode(query.getLanguageCode());
                queryName.setTenantId(query.getTenantId());
                List newPathBatch = this.spaceRepository.getNewPathBatch(queryName);
                for (QueryMonitorListDoBO monitorIfo : queryTagInfoListBO.getList()) {
                    QueryInfoByDataPointDTO result = new QueryInfoByDataPointDTO();
                    result.setSpaceId(monitorIfo.getProjectSpaceId());
                    ArrayList<DataPointDTO> dataPointDTOS = new ArrayList<DataPointDTO>();
                    if (DataUtils.isListAvali((List)monitorIfo.getGodzillaInfo())) {
                        for (GodzillaBindingInfo id : monitorIfo.getGodzillaInfo()) {
                            DataPointDTO dataPointDTO = new DataPointDTO();
                            dataPointDTO.setDataPointId(id.getDataPointId());
                            QueryRuleAndStartBO queryInfo = new QueryRuleAndStartBO();
                            queryInfo.setDataPointId(id.getDataPointId());
                            QueryRuleAndStartDoBO info = this.godzillaServerRepository.queryRuleAndStart(queryInfo);
                            if (info != null) {
                                if (!StringUtils.isEmpty((CharSequence)info.getUnit())) {
                                    dataPointDTO.setUnit(info.getUnit());
                                }
                                if (!StringUtils.isEmpty((CharSequence)info.getCurrentValue())) {
                                    dataPointDTO.setCurrentValue(info.getCurrentValue());
                                }
                            }
                            dataPointDTOS.add(dataPointDTO);
                        }
                    }
                    result.setDataInfo(dataPointDTOS);
                    resultList.add(result);
                }
                if (DataUtils.isListAvali((List)newPathBatch) && DataUtils.isListAvali(resultList)) {
                    for (ProjectSpacePathBO pathBatch : newPathBatch) {
                        for (QueryInfoByDataPointDTO result : resultList) {
                            if (!StringUtils.equals((CharSequence)result.getSpaceId(), (CharSequence)pathBatch.getId())) continue;
                            result.setSpaceName(pathBatch.getNameStr());
                        }
                    }
                }
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse sqDepositSentryInfo() {
        BaseResponse response = new BaseResponse();
        ArrayList<String> queryList = new ArrayList<String>();
        queryList.add(this.waterId);
        queryList.add(this.electricityId);
        try {
            for (String query : queryList) {
                QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
                QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
                queryTagInfoList.setTagId(query);
                queryTagInfoList.setLanguageCode("CN");
                List queryTagInfoListBO = this.targetTagRepository.queryTagInfoList(queryTagInfoList);
                if (!DataUtils.isListAvali((List)queryTagInfoListBO)) continue;
                ArrayList<QueryIndexStatisticsBasisDTO> resultList = new ArrayList<QueryIndexStatisticsBasisDTO>();
                ArrayList<QueryIndexStatisticsBasisDTO> resultList2 = new ArrayList<QueryIndexStatisticsBasisDTO>();
                for (int i = 0; i < 24; ++i) {
                    QueryIndexStatisticsBasisDTO resultDTO = new QueryIndexStatisticsBasisDTO();
                    resultDTO.setTime(Integer.valueOf(i));
                    resultDTO.setValue(new BigDecimal("0"));
                    QueryIndexStatisticsBasisDTO resultDTO1 = new QueryIndexStatisticsBasisDTO();
                    resultDTO1.setTime(Integer.valueOf(i));
                    resultDTO1.setValue(new BigDecimal("0"));
                    resultList.add(resultDTO);
                    resultList2.add(resultDTO1);
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date beforeYesterdayStartTime = DataUtils.getBeginDayOfBeforeYesterday();
                Date beforeYesterDayEndTime = DataUtils.getEndDayOfBeforeYesterDay();
                Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                Date DayEndTime = DataUtils.getDayEnd();
                Date DayStartTime = DataUtils.getDayBegin();
                List notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getDataPointId())).collect(Collectors.toList());
                BigDecimal beforeYesterday = new BigDecimal("0");
                BigDecimal yesterday = new BigDecimal("0");
                List todayInfo = IFWBeanCopyUtil.mapAsList(resultList, QueryIndexStatisticsBasisDTO.class);
                List YesterdayInfo = IFWBeanCopyUtil.mapAsList(resultList, QueryIndexStatisticsBasisDTO.class);
                for (QueryTagInfoListDTO queryInfo : notNullList) {
                    BigDecimal value;
                    TemporalAccessor parse;
                    MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                    metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                    metricValueRecordListReqBO.setAppId(this.appId);
                    metricValueRecordListReqBO.setStartTime(beforeYesterdayStartTime);
                    metricValueRecordListReqBO.setEndTime(beforeYesterDayEndTime);
                    log.info("\u67e5\u8be2\u524d\u5929\u6570\u636e\u5165\u53c2\uff1a" + metricValueRecordListReqBO);
                    MetricValueRecordListBO nowGodzillaInfo = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                    log.info("\u67e5\u8be2\u51fa\u6628\u65e5\u6570\u636e\uff1a" + nowGodzillaInfo);
                    MetricValueRecordListReqBO metricValueRecordListReqBOOne = new MetricValueRecordListReqBO();
                    metricValueRecordListReqBOOne.setDataPointId(queryInfo.getDataPointId());
                    metricValueRecordListReqBOOne.setAppId(this.appId);
                    metricValueRecordListReqBOOne.setStartTime(yesterDayStartTime);
                    metricValueRecordListReqBOOne.setEndTime(YesterDayEndTime);
                    log.info("\u67e5\u8be2\u6628\u65e5\u6570\u636e\u5165\u53c2\uff1a" + metricValueRecordListReqBOOne);
                    MetricValueRecordListBO godzillaInfoBOS = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBOOne);
                    log.info("\u67e5\u8be2\u51fa\u6628\u65e5\u6570\u636e\uff1a" + godzillaInfoBOS);
                    MetricValueRecordListReqBO nowQuery = new MetricValueRecordListReqBO();
                    nowQuery.setDataPointId(queryInfo.getDataPointId());
                    nowQuery.setAppId(this.appId);
                    nowQuery.setStartTime(DayStartTime);
                    nowQuery.setEndTime(DayEndTime);
                    log.info("\u67e5\u8be2\u4eca\u65e5\u6570\u636e\u5165\u53c2\uff1a" + nowQuery);
                    MetricValueRecordListBO nowGodzillaInfoBOS = this.godzillaServerRepository.queryMetricValueRecordList(nowQuery);
                    log.info("\u67e5\u8be2\u51fa\u4eca\u65e5\u6570\u636e\uff1a" + nowGodzillaInfoBOS);
                    if (nowGodzillaInfo != null && DataUtils.isListAvali((List)nowGodzillaInfo.getCollectDataList())) {
                        for (GodzillaInfoBO today : nowGodzillaInfo.getCollectDataList()) {
                            TemporalAccessor parse2 = RFC3339_FORMATTER.parse(today.getTime());
                            LocalTime isoTime = parse2.query(TemporalQueries.localTime());
                            int hour = isoTime.getHour();
                            BigDecimal value2 = new BigDecimal(today.getValue());
                            if (hour != 23) continue;
                            beforeYesterday.add(value2);
                        }
                    }
                    log.info("\u524d\u5929\u6570\u636e\uff1a" + beforeYesterday);
                    if (godzillaInfoBOS != null && DataUtils.isListAvali((List)godzillaInfoBOS.getCollectDataList())) {
                        for (int i = 0; i < 24; ++i) {
                            for (GodzillaInfoBO today : godzillaInfoBOS.getCollectDataList()) {
                                parse = RFC3339_FORMATTER.parse(today.getTime());
                                LocalTime isoTime = parse.query(TemporalQueries.localTime());
                                int hour = isoTime.getHour();
                                value = new BigDecimal(today.getValue());
                                if (hour == i) {
                                    log.info("dataPointId\u4e3a\uff1a" + today.getDataPointId() + ",\u5728\u7b2c" + hour + "\u5c0f\u65f6\u7684\u503c\u4e3a\uff1a" + value);
                                    ((QueryIndexStatisticsBasisDTO)resultList2.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList2.get(i)).getValue().add(value));
                                    log.info("dataPointId\u4e3a\uff1a" + today.getDataPointId() + "\u76f8\u52a0\u540e\u7684\u503c\u4e3a" + ((QueryIndexStatisticsBasisDTO)resultList.get(i)).getValue());
                                }
                                if (hour != 23) continue;
                                yesterday.add(value);
                            }
                            if (i == 0) {
                                if (((QueryIndexStatisticsBasisDTO)resultList2.get(i)).getValue().subtract(beforeYesterday).compareTo(new BigDecimal("0")) == -1) {
                                    ((QueryIndexStatisticsBasisDTO)YesterdayInfo.get(i)).setValue(new BigDecimal("0"));
                                    log.info("\u6570\u636e\u76f8\u51cf\u4e3a\u8d1f\u6570");
                                } else {
                                    ((QueryIndexStatisticsBasisDTO)YesterdayInfo.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList2.get(i)).getValue().subtract(beforeYesterday));
                                    log.info("\u6570\u636e\u76f8\u52a0\u4e3a\uff1a" + YesterdayInfo.get(i));
                                }
                            } else if (((QueryIndexStatisticsBasisDTO)resultList2.get(i)).getValue().subtract(((QueryIndexStatisticsBasisDTO)resultList2.get(i - 1)).getValue()).compareTo(new BigDecimal("0")) == -1) {
                                ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).setValue(new BigDecimal("0"));
                                log.info("\u6570\u636e\u76f8\u51cf\u4e3a\u8d1f\u6570");
                            } else {
                                ((QueryIndexStatisticsBasisDTO)YesterdayInfo.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList2.get(i)).getValue().subtract(((QueryIndexStatisticsBasisDTO)resultList2.get(i - 1)).getValue()));
                                log.info("\u6570\u636e\u76f8\u52a0\u4e3a\uff1a" + YesterdayInfo.get(i));
                                log.info("\u6570\u636e\u70b9\uff1a" + queryInfo.getDataPointId());
                            }
                            log.info("\u7b2c" + i + "\u5c0f\u65f6\u8ba1\u7b97\u7ed3\u675f\uff0c\u503c\u4e3a" + ((QueryIndexStatisticsBasisDTO)YesterdayInfo.get(i)).getValue());
                        }
                    }
                    if (nowGodzillaInfoBOS == null || !DataUtils.isListAvali((List)nowGodzillaInfoBOS.getCollectDataList())) continue;
                    for (int i = 0; i < 24; ++i) {
                        for (GodzillaInfoBO today : nowGodzillaInfoBOS.getCollectDataList()) {
                            parse = RFC3339_FORMATTER.parse(today.getTime());
                            LocalTime isoTime = parse.query(TemporalQueries.localTime());
                            int hour = isoTime.getHour();
                            value = new BigDecimal(today.getValue());
                            if (hour != i) continue;
                            log.info("dataPointId\u4e3a\uff1a" + today.getDataPointId() + ",\u5728\u7b2c" + hour + "\u5c0f\u65f6\u7684\u503c\u4e3a\uff1a" + value);
                            ((QueryIndexStatisticsBasisDTO)resultList.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList.get(i)).getValue().add(value));
                            log.info("dataPointId\u4e3a\uff1a" + today.getDataPointId() + "\u76f8\u52a0\u540e\u7684\u503c\u4e3a" + ((QueryIndexStatisticsBasisDTO)resultList.get(i)).getValue());
                        }
                        if (i == 0) {
                            if (((QueryIndexStatisticsBasisDTO)resultList.get(0)).getValue().subtract(yesterday).compareTo(new BigDecimal("0")) == -1) {
                                ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).setValue(new BigDecimal("0"));
                                log.info("\u6570\u636e\u76f8\u51cf\u4e3a\u8d1f\u6570");
                            } else {
                                ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList.get(0)).getValue().subtract(yesterday));
                                log.info("\u6570\u636e\u76f8\u52a0\u4e3a\uff1a" + todayInfo.get(i));
                            }
                        } else if (((QueryIndexStatisticsBasisDTO)resultList.get(i)).getValue().subtract(((QueryIndexStatisticsBasisDTO)resultList.get(i - 1)).getValue()).compareTo(new BigDecimal("0")) == -1) {
                            ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).setValue(new BigDecimal("0"));
                            log.info("\u6570\u636e\u76f8\u51cf\u4e3a\u8d1f\u6570");
                        } else {
                            ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).setValue(((QueryIndexStatisticsBasisDTO)resultList.get(i)).getValue().subtract(((QueryIndexStatisticsBasisDTO)resultList.get(i - 1)).getValue()));
                            log.info("\u6570\u636e\u76f8\u52a0\u4e3a\uff1a" + todayInfo.get(i));
                            log.info("\u6570\u636e\u70b9\uff1a" + queryInfo.getDataPointId());
                        }
                        log.info("\u7b2c" + i + "\u5c0f\u65f6\u8ba1\u7b97\u7ed3\u675f\uff0c\u503c\u4e3a" + ((QueryIndexStatisticsBasisDTO)todayInfo.get(i)).getValue());
                    }
                }
                result.setTodayIndexInfo(todayInfo);
                result.setYesterdayIndexInfo(YesterdayInfo);
                if (query.equals(this.electricityId)) {
                    this.redisTemplate.opsForValue().set((Object)RedisKeyPrefixUtil.getCameraCountInfoType((String)"1"), (Object)result);
                    log.info("\u5b58\u5165\u7528\u7535\u91cf\u6210\u529f\uff01" + result);
                }
                if (!query.equals(this.waterId)) continue;
                this.redisTemplate.opsForValue().set((Object)RedisKeyPrefixUtil.getCameraCountInfoType((String)"2"), (Object)result);
                log.info("\u5b58\u5165\u7528\u6c34\u91cf\u6210\u529f\uff01" + result);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long nowTime = System.currentTimeMillis();
        long Tenminute = nowTime - 600000L;
        Long timeStamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = sdf.format(new Date(Long.parseLong(String.valueOf(nowTime))));
        String ten = sdf.format(new Date(Long.parseLong(String.valueOf(Tenminute))));
        System.out.println(now);
        System.out.println(ten);
    }
}

