/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.AlertIndexInfoDTO;
import com.ifourthwall.dbm.asset.dto.AlertIndexListDTO;
import com.ifourthwall.dbm.asset.dto.AlertListDTO;
import com.ifourthwall.dbm.asset.dto.AlertListQueryDTO;
import com.ifourthwall.dbm.asset.dto.AlertRulesDTO;
import com.ifourthwall.dbm.asset.dto.DeleteMonitorDTO;
import com.ifourthwall.dbm.asset.dto.DeleteTagQuDTO;
import com.ifourthwall.dbm.asset.dto.GetAppIdDTO;
import com.ifourthwall.dbm.asset.dto.GodzillaBindingInfo;
import com.ifourthwall.dbm.asset.dto.GodzillaDatapointInfo;
import com.ifourthwall.dbm.asset.dto.GodzillaInfoQuDTO;
import com.ifourthwall.dbm.asset.dto.InsertTagQuDTO;
import com.ifourthwall.dbm.asset.dto.InsetAlertNoticeDTO;
import com.ifourthwall.dbm.asset.dto.MetricValueRecordListDTO;
import com.ifourthwall.dbm.asset.dto.MonitorInfoDTO;
import com.ifourthwall.dbm.asset.dto.MonitorMetricBasisDTO;
import com.ifourthwall.dbm.asset.dto.MonitorRankingDTO;
import com.ifourthwall.dbm.asset.dto.MonitorSpaceDTO;
import com.ifourthwall.dbm.asset.dto.MonitorSpaceQuDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.QueryAlertDTO;
import com.ifourthwall.dbm.asset.dto.QueryAlertInfoDTO;
import com.ifourthwall.dbm.asset.dto.QueryAllByStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.QueryAllByStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryAppIdDTO;
import com.ifourthwall.dbm.asset.dto.QueryAppIdQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorInfoDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorInfoQueryBasisDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorListQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorTagListDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorTagListQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorTranslationDTO;
import com.ifourthwall.dbm.asset.dto.QueryRecordingListDTO;
import com.ifourthwall.dbm.asset.dto.QueryRecordingQueryBasisDTO;
import com.ifourthwall.dbm.asset.dto.QuerySentryInfoAssetDTO;
import com.ifourthwall.dbm.asset.dto.QuerySentryInfoDTO;
import com.ifourthwall.dbm.asset.dto.QuerySentryInfoQueryDTO;
import com.ifourthwall.dbm.asset.dto.QuerySentryInfoSevenDayDTO;
import com.ifourthwall.dbm.asset.dto.SeerQuerySentryInfoDTO;
import com.ifourthwall.dbm.asset.dto.SeerQuerySentryInfoQuDTO;
import com.ifourthwall.dbm.asset.dto.SeerTagListDTO;
import com.ifourthwall.dbm.asset.dto.SentryInfoIntactDTO;
import com.ifourthwall.dbm.asset.dto.SentryInfoQuBasisDTO;
import com.ifourthwall.dbm.asset.dto.SentryInfoRankingDTO;
import com.ifourthwall.dbm.asset.dto.SentryMonitorRankingDTO;
import com.ifourthwall.dbm.asset.dto.SentryMonitorRankingQuDTO;
import com.ifourthwall.dbm.asset.dto.SentryQueryTaskQuDTO;
import com.ifourthwall.dbm.asset.dto.SentryRankDTO;
import com.ifourthwall.dbm.asset.dto.TagFaultPercentDTO;
import com.ifourthwall.dbm.asset.dto.TagFaultPercentQuDTO;
import com.ifourthwall.dbm.asset.dto.TagInfoDTO;
import com.ifourthwall.dbm.asset.dto.TagInfoQuDTO;
import com.ifourthwall.dbm.asset.dto.TransferNumberDTO;
import com.ifourthwall.dbm.asset.dto.TransferNumberQuDTO;
import com.ifourthwall.dbm.asset.dto.TranslationDTO;
import com.ifourthwall.dbm.asset.dto.UpAlertNoticeDTO;
import com.ifourthwall.dbm.asset.dto.UpInGodzillaMonitor;
import com.ifourthwall.dbm.asset.dto.UpInsertMonitorBasisDTO;
import com.ifourthwall.dbm.asset.dto.UpInsertMonitorDTO;
import com.ifourthwall.dbm.asset.dto.UpInsertTagQuDTO;
import com.ifourthwall.dbm.asset.dto.UpMonitorRecordDTO;
import com.ifourthwall.dbm.asset.dto.UpdateTagQuDTO;
import com.ifourthwall.dbm.asset.dto.alertNumberDTO;
import com.ifourthwall.dbm.asset.dto.alertNumberRanking;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.monitorSeerInfoDTO;
import com.ifourthwall.dbm.asset.dto.monitorSeerInfoQuDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.common.util.MathUtils;
import com.ifourthwall.dbm.project.dto.GetSonSpaceQueryDTO;
import com.ifourthwall.dbm.sentry.bo.AddMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.AllTranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.AssetInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.CreateTaskQueryDTO;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.GetProjectSpaceInfoQueryBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceQueryBO;
import com.ifourthwall.dbm.sentry.bo.InsertAppIdQuDoBO;
import com.ifourthwall.dbm.sentry.bo.KafkaAlertBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceSubListQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAlarmRuleDetailBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryDataByMonitorDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryDataByMonitorQuDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorInfoQueryBasisDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorListDoQueryBO;
import com.ifourthwall.dbm.sentry.bo.QueryProjectPagePO;
import com.ifourthwall.dbm.sentry.bo.QueryRecordingListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRecordingQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskInsertDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskKafkaBO;
import com.ifourthwall.dbm.sentry.bo.TaskSpaceInsertBO;
import com.ifourthwall.dbm.sentry.bo.TransferNumberDoBO;
import com.ifourthwall.dbm.sentry.bo.TransferNumberQuDoBO;
import com.ifourthwall.dbm.sentry.bo.TranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.UpInsertMonitorDoBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleInsertBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleListReqBO;
import com.ifourthwall.dbm.sentry.bo.alarm.DatapointAndAlarmRuleBindReqBO;
import com.ifourthwall.dbm.sentry.bo.app.AppReqBO;
import com.ifourthwall.dbm.sentry.bo.app.AppRespBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.ProjectRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.domain.TaskRepository;
import com.ifourthwall.dbm.sentry.domain.UserRepository;
import com.ifourthwall.dbm.sentry.service.MonitorService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.user.dto.ServiceWetherPurchaseReqDTO;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="MonitorServiceImpl")
public class MonitorServiceImpl
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    public static final String ENABLE_ALARM = "1";
    public static final String DISABLE_ALARM = "0";
    @Autowired
    private RedisTemplate redisTemplate;
    @Reference(version="1.0.0")
    private MonitorFacade monitorFacade;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="ProjectRepository")
    private ProjectRepository projectRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;
    @Resource(name="TaskRepository")
    private TaskRepository taskRepository;
    @Resource(name="UserRepository")
    private UserRepository userRepository;
    @Value(value="${robot.system.id}")
    private String robotId;
    @Value(value="${callback.url}")
    private String callbackUrl;
    @Value(value="${callback.token}")
    private String callbackToken;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Value(value="${ifw.sentry.service.id}")
    private String sentryServiceId;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;
    @Resource(name="IFWKafkaClient-dbm_sentry_alert_create_task")
    private IFWKafkaClient ifwKafkaClientCreateTask;
    @Resource(name="IFWKafkaClient-dbm_sentry_update_space_special_alarm_num")
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse upInsertMonitor(UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)upInsertMonitor.getTenantId(), (IFWUser)user);
            upInsertMonitor.setTenantId(tenantId);
            UpInsertMonitorDTO upInsert = new UpInsertMonitorDTO();
            BeanUtils.copyProperties((Object)upInsertMonitor, (Object)upInsert);
            upInsert.setTenantId(tenantId);
            if (upInsert.getType() == 1) {
                upInsert.setCreateBy(user.getUserId());
            }
            if (upInsert.getType() == 2) {
                upInsert.setUpdateBy(user.getUserId());
            }
            UpInsertMonitorDoBO query = (UpInsertMonitorDoBO)IFWBeanCopyUtil.map((Object)upInsert, UpInsertMonitorDoBO.class);
            this.monitorRepository.upInsertMonitor(query);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    @Transactional
    public BaseResponse upInsertIndex(UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)upInsertMonitor.getTenantId(), (IFWUser)user);
            upInsertMonitor.setTenantId(tenantId);
            if (DataUtils.isListAvali((List)upInsertMonitor.getMonitorMetricInfo())) {
                GetProjectSpaceInfoQueryBO queryProjectName = new GetProjectSpaceInfoQueryBO();
                queryProjectName.setTenantId(upInsertMonitor.getTenantId());
                queryProjectName.setProjectId(upInsertMonitor.getProjectId());
                queryProjectName.setLanguageCode(upInsertMonitor.getLanguageCode());
                QueryProjectPagePO projectSpaceInfo = this.projectRepository.getProjectSpaceInfo(queryProjectName);
                if (projectSpaceInfo != null) {
                    UpInGodzillaMonitor upInGodzillaMonitor = new UpInGodzillaMonitor();
                    ArrayList<GodzillaDatapointInfo> godzillaDataPoint = new ArrayList<GodzillaDatapointInfo>();
                    AssetInfoQueryDoBO assetInfoQueryDoBO = new AssetInfoQueryDoBO();
                    assetInfoQueryDoBO.setLanguageCode(upInsertMonitor.getLanguageCode());
                    assetInfoQueryDoBO.setAssetId(upInsertMonitor.getAssetId());
                    assetInfoQueryDoBO.setProjectId(upInsertMonitor.getProjectId());
                    QueryAssetInfoDoBO queryAssetInfoDoBO = this.assetRepository.queryAssetInfo(assetInfoQueryDoBO);
                    if (queryAssetInfoDoBO != null) {
                        GetNewPathBatchQueryBO queryName = new GetNewPathBatchQueryBO();
                        ArrayList<String> ids = new ArrayList<String>();
                        ids.add(queryAssetInfoDoBO.getProjectSpaceId());
                        queryName.setProjectSpaceId(ids);
                        queryName.setProjectId(upInsertMonitor.getProjectId());
                        queryName.setLanguageCode(upInsertMonitor.getLanguageCode());
                        queryName.setTenantId(tenantId);
                        List newPathBatch = this.spaceRepository.getNewPathBatch(queryName);
                        if (DataUtils.isListAvali((List)newPathBatch)) {
                            ArrayList<String> ruleIds = new ArrayList<String>();
                            ruleIds.add(upInsertMonitor.getAlarmRuleId());
                            QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                            queryAppIdQueryDoBO.setTenantId(tenantId);
                            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
                            if (queryAppIdBO != null && queryAppIdBO.getDefaultAlarmRuleId() == null) {
                                AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
                                insert.setAppId(queryAppIdBO.getAppId());
                                insert.setCallbackUrl(this.callbackUrl);
                                insert.setCallbackToken(this.callbackToken);
                                insert.setAlarmChannel("callback");
                                insert.setAlarmRuleName("sentry\u9ed8\u8ba4\u544a\u8b66\u6a21\u677f-" + user.getOrganizationName());
                                insert.setAlarmCycle(DISABLE_ALARM);
                                log.info("addAlarmRule\u5165\u53c2\uff1a" + insert);
                                String ruleId = this.godzillaServerRepository.addAlarmRule(insert);
                                UpdateAppIdQuDTO updateAppIdQuDTO = new UpdateAppIdQuDTO();
                                updateAppIdQuDTO.setTenantId(tenantId);
                                updateAppIdQuDTO.setRuleId(ruleId);
                                this.monitorRepository.updateAppId(updateAppIdQuDTO);
                                ruleIds.add(ruleId);
                            } else {
                                ruleIds.add(queryAppIdBO.getDefaultAlarmRuleId());
                            }
                            for (MonitorMetricBasisDTO monitorMetric : upInsertMonitor.getMonitorMetricInfo()) {
                                DatapointAndAlarmRuleBindReqBO datapointAndAlarmRuleBindReqBO = new DatapointAndAlarmRuleBindReqBO();
                                QueryDataByMonitorQuDoBO queryDataByMonitorQuDoBO = new QueryDataByMonitorQuDoBO();
                                queryDataByMonitorQuDoBO.setDataPointId(monitorMetric.getDataPointId());
                                queryDataByMonitorQuDoBO.setTenantId(tenantId);
                                QueryDataByMonitorDoBO queryDataByMonitorDoBO = this.monitorRepository.queryDataByMonitor(queryDataByMonitorQuDoBO);
                                if (queryDataByMonitorDoBO.getMonitorId() == null) continue;
                                GodzillaDatapointInfo godzillaInfo = new GodzillaDatapointInfo();
                                godzillaInfo.setDataPointId(monitorMetric.getDataPointId());
                                StringBuilder godzillaName = new StringBuilder();
                                if ("CN".equals(upInsertMonitor.getLanguageCode())) {
                                    godzillaName.append(upInsertMonitor.getAssetName() + ",\u76d1\u6d4b\u6307\u6807:" + monitorMetric.getMonitorMetricName() + ",\u9879\u76ee\u540d\u79f0:" + projectSpaceInfo.getProjectName() + ",\u7a7a\u95f4\u4f4d\u7f6e\uff1a" + ((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                                }
                                if ("JP".equals(upInsertMonitor.getLanguageCode())) {
                                    godzillaName.append(upInsertMonitor.getAssetName() + ",\u30e2\u30cb\u30bf\u30ea\u30f3\u30b0\u6307\u6a19:" + monitorMetric.getMonitorMetricName() + ",\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d:" + projectSpaceInfo.getProjectName() + ",\u7a7a\u9593\u4f4d\u7f6e\uff1a" + ((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                                }
                                if ("EN".equals(upInsertMonitor.getLanguageCode())) {
                                    godzillaName.append(upInsertMonitor.getAssetName() + ",Monitor Metric Name:" + monitorMetric.getMonitorMetricName() + ",Project Name:" + projectSpaceInfo.getProjectName() + ",Space Name\uff1a" + ((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                                }
                                godzillaInfo.setDataPointName(godzillaName.toString());
                                godzillaInfo.setUnit(monitorMetric.getUnit());
                                if (upInsertMonitor.getAutoAlert() == 1) {
                                    datapointAndAlarmRuleBindReqBO.setAliasEnableAlarm(ENABLE_ALARM);
                                }
                                if (upInsertMonitor.getAutoAlert() == 0) {
                                    datapointAndAlarmRuleBindReqBO.setAliasEnableAlarm(DISABLE_ALARM);
                                }
                                godzillaDataPoint.add(godzillaInfo);
                                datapointAndAlarmRuleBindReqBO.setAlarmRuleIds(String.join((CharSequence)",", ruleIds));
                                datapointAndAlarmRuleBindReqBO.setDataPointId(monitorMetric.getDataPointId());
                                this.godzillaServerRepository.bindDatapointAndAlarmRule(datapointAndAlarmRuleBindReqBO);
                                if (!DataUtils.isListAvali((List)monitorMetric.getAlarmInfo())) continue;
                                for (AlertRulesDTO alertRulesDTO : monitorMetric.getAlarmInfo()) {
                                    AddMaxAndMinBO updateMaxAndMinBO = new AddMaxAndMinBO();
                                    updateMaxAndMinBO.setAlarmMaximumValue(alertRulesDTO.getAlarmMaximumValue());
                                    updateMaxAndMinBO.setAlarmMinimumValue(alertRulesDTO.getAlarmMinimumValue());
                                    updateMaxAndMinBO.setDataPointId(monitorMetric.getDataPointId());
                                    updateMaxAndMinBO.setCompareTarget(monitorMetric.getDataPointId());
                                    updateMaxAndMinBO.setCompareDuration(Integer.valueOf(alertRulesDTO.getCompareDuration() * 60 * 1000));
                                    this.godzillaServerRepository.addMaxAndMin(updateMaxAndMinBO);
                                }
                            }
                        }
                    } else {
                        throw new BizException(PlatformCodeEnum.ASSET_IS_NULL.getDesc(), PlatformCodeEnum.ASSET_IS_NULL.getCode());
                    }
                    upInGodzillaMonitor.setDatapointList(godzillaDataPoint);
                    this.godzillaServerRepository.updateDataPointName(upInGodzillaMonitor);
                }
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(PlatformCodeEnum.CREATE_FAILED.getCode());
            response.setRetMsg(PlatformCodeEnum.CREATE_FAILED.getDesc());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryMonitorInfoDTO> queryMonitorInfo(QueryMonitorInfoQueryBasisDTO monitorInfo, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)monitorInfo.getTenantId(), (IFWUser)user);
            monitorInfo.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            QueryMonitorInfoQueryBasisDoBO query = new QueryMonitorInfoQueryBasisDoBO();
            query.setAssetId(monitorInfo.getAssetId());
            query.setTenantId(tenantId);
            query.setProjectId(monitorInfo.getProjectId());
            query.setLanguageCode(monitorInfo.getLanguageCode());
            QueryMonitorInfoDoBO queryMonitorInfoDoBOPageDTO = this.monitorRepository.queryMonitorInfo(query);
            if (queryMonitorInfoDoBOPageDTO == null) {
                return response;
            }
            QueryMonitorInfoDTO result = (QueryMonitorInfoDTO)IFWBeanCopyUtil.map((Object)queryMonitorInfoDoBOPageDTO, QueryMonitorInfoDTO.class);
            GetNewPathBatchQueryBO querySpaceName = new GetNewPathBatchQueryBO();
            ArrayList<String> spaceId = new ArrayList<String>();
            spaceId.add(queryMonitorInfoDoBOPageDTO.getSpaceId());
            querySpaceName.setProjectId(monitorInfo.getProjectId());
            querySpaceName.setProjectSpaceId(spaceId);
            querySpaceName.setLanguageCode(monitorInfo.getLanguageCode());
            List newPathBatch = this.spaceRepository.getNewPathBatch(querySpaceName);
            if (!DataUtils.isListAvali((List)newPathBatch)) {
                result.setSpaceName("");
            } else {
                result.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
            }
            if (DataUtils.isListAvali((List)result.getMonitorMetricInfo())) {
                for (MonitorInfoDTO monitorInfoDTO : result.getMonitorMetricInfo()) {
                    if (StringUtils.isEmpty((CharSequence)monitorInfoDTO.getDataPointId())) continue;
                    QueryRuleAndStartBO godzillaResult = new QueryRuleAndStartBO();
                    godzillaResult.setDataPointId(monitorInfoDTO.getDataPointId());
                    QueryRuleAndStartDoBO godzillaInfo = this.godzillaServerRepository.queryRuleAndStart(godzillaResult);
                    if (godzillaInfo == null) continue;
                    if (!StringUtils.isEmpty((CharSequence)godzillaInfo.getAlarmRuleId())) {
                        String[] split;
                        for (String ruleId : split = godzillaInfo.getAlarmRuleId().split(",")) {
                            if (ruleId.equals(queryAppIdBO.getDefaultAlarmRuleId())) continue;
                            result.setAlarmRuleId(ruleId);
                        }
                    }
                    monitorInfoDTO.setUnit(godzillaInfo.getUnit());
                    result.setAlarmRuleName(godzillaInfo.getAlarmRuleName());
                    result.setAliasEnableAlarm(godzillaInfo.getAliasEnableAlarm());
                }
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<PageDTO<QueryMonitorListDTO>> queryMonitorList(QueryMonitorListQueryDTO monitorList, IFWUser user) {
        BaseResponse response = new BaseResponse();
        PageDTO resultPage = new PageDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)monitorList.getTenantId(), (IFWUser)user);
            monitorList.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
            if (!StringUtils.isEmpty((CharSequence)monitorList.getSpaceName())) {
                ProjectSpaceSubListQueryDoBO queryName = new ProjectSpaceSubListQueryDoBO();
                queryName.setProjectId(monitorList.getProjectId());
                queryName.setNameLike(monitorList.getSpaceName());
                queryName.setLanguageCode(monitorList.getLanguageCode());
                queryName.setTenantId(monitorList.getTenantId());
                List sonSpaceList = this.spaceRepository.getSonSpaceList(queryName);
                if (sonSpaceList != null) {
                    List ids = sonSpaceList.stream().map(ProjectSpaceBaseDoBO::getProjectSpaceId).collect(Collectors.toList());
                    queryMonitorList.setSpaceId(ids);
                }
            }
            if (ENABLE_ALARM.equals(monitorList.getIsOrNot()) && monitorList.getSpaceId() != null) {
                GetSonSpaceQueryDTO querySpace = new GetSonSpaceQueryDTO();
                querySpace.setSpaceId(monitorList.getSpaceId());
                GetSonSpaceBO allSpace = this.spaceRepository.getSonpace((GetSonSpaceQueryBO)IFWBeanCopyUtil.map((Object)querySpace, GetSonSpaceQueryBO.class));
                if (!DataUtils.isListAvali((List)allSpace.getSpaceId())) {
                    return response;
                }
                allSpace.getSpaceId().add(monitorList.getSpaceId());
                queryMonitorList.setSpaceId(allSpace.getSpaceId());
            }
            if ("2".equals(monitorList.getIsOrNot()) && !StringUtils.isEmpty((CharSequence)monitorList.getSpaceId())) {
                ArrayList<String> spaceIds = new ArrayList<String>();
                spaceIds.add(monitorList.getSpaceId());
                queryMonitorList.setSpaceId(spaceIds);
            }
            queryMonitorList.setTenantId(tenantId);
            BeanUtils.copyProperties((Object)monitorList, (Object)queryMonitorList);
            IFWPageInfo monitorPage = this.monitorRepository.queryMonitorList(queryMonitorList);
            if (monitorPage == null) {
                return response;
            }
            BeanUtils.copyProperties((Object)monitorPage, (Object)resultPage, (String[])new String[]{"result"});
            List resultList = IFWBeanCopyUtil.mapAsList((Iterable)monitorPage.getList(), QueryMonitorListDTO.class);
            GetNewPathBatchQueryBO querySpaceName = new GetNewPathBatchQueryBO();
            ArrayList<String> spaceId = new ArrayList<String>();
            for (QueryMonitorListDTO monitor : resultList) {
                spaceId.add(monitor.getProjectSpaceId());
            }
            querySpaceName.setProjectId(monitorList.getProjectId());
            querySpaceName.setProjectSpaceId(spaceId);
            querySpaceName.setLanguageCode(monitorList.getLanguageCode());
            List newPathBatch = this.spaceRepository.getNewPathBatch(querySpaceName);
            if (DataUtils.isListAvali((List)newPathBatch)) {
                for (QueryMonitorListDTO monitor : resultList) {
                    for (ProjectSpacePathBO spaceName : newPathBatch) {
                        if (!monitor.getProjectSpaceId().equals(spaceName.getId())) continue;
                        monitor.setProjectSpaceName(spaceName.getNameStr());
                    }
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    if (!DataUtils.isListAvali((List)monitor.getGodzillaInfo())) continue;
                    for (GodzillaBindingInfo godzillaBindingInfo : monitor.getGodzillaInfo()) {
                        queryRuleAndStartBO.setDataPointId(godzillaBindingInfo.getDataPointId());
                        QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                        if (queryRuleAndStartDoBO == null) continue;
                        godzillaBindingInfo.setUnit(queryRuleAndStartDoBO.getUnit());
                        godzillaBindingInfo.setCurrentValue(queryRuleAndStartDoBO.getCurrentValue());
                    }
                }
            }
            resultPage.setResult(resultList);
            response.setData((Object)resultPage);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryMonitorTranslationDTO> queryMonitorTranslation(TranslationDTO translationDTO) {
        return this.monitorFacade.queryMonitorTranslation(translationDTO);
    }

    public BaseResponse<PageDTO<QueryRecordingListDTO>> queryRecordingList(QueryRecordingQueryBasisDTO recording, IFWUser user) {
        BaseResponse response = new BaseResponse();
        PageDTO resultPage = new PageDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)recording.getTenantId(), (IFWUser)user);
            recording.setTenantId(tenantId);
            QueryRecordingQueryDoBO queryRecord = new QueryRecordingQueryDoBO();
            if (recording.getSpaceId() != null) {
                GetSonSpaceQueryDTO querySpace = new GetSonSpaceQueryDTO();
                querySpace.setSpaceId(recording.getSpaceId());
                GetSonSpaceBO allSpace = this.spaceRepository.getSonpace((GetSonSpaceQueryBO)IFWBeanCopyUtil.map((Object)querySpace, GetSonSpaceQueryBO.class));
                if (!DataUtils.isListAvali((List)allSpace.getSpaceId())) {
                    return response;
                }
                allSpace.getSpaceId().add(recording.getSpaceId());
                queryRecord.setSpaceId(allSpace.getSpaceId());
            }
            queryRecord.setTenantId(tenantId);
            BeanUtils.copyProperties((Object)recording, (Object)queryRecord);
            PageDTO monitorPage = this.monitorRepository.queryRecordingList(queryRecord);
            if (!DataUtils.isListAvali((List)monitorPage.getResult())) {
                return response;
            }
            BeanUtils.copyProperties((Object)monitorPage, (Object)resultPage, (String[])new String[]{"result"});
            List resultList = IFWBeanCopyUtil.mapAsList((Iterable)monitorPage.getResult(), QueryRecordingListDTO.class);
            GetNewPathBatchQueryBO querySpaceName = new GetNewPathBatchQueryBO();
            ArrayList<String> spaceId = new ArrayList<String>();
            for (QueryRecordingListDTO monitor : resultList) {
                spaceId.add(monitor.getProjectSpaceId());
            }
            querySpaceName.setProjectId(recording.getProjectId());
            querySpaceName.setProjectSpaceId(spaceId);
            querySpaceName.setLanguageCode(recording.getLanguageCode());
            List newPathBatch = this.spaceRepository.getNewPathBatch(querySpaceName);
            if (DataUtils.isListAvali((List)newPathBatch)) {
                for (QueryRecordingListDTO monitor : resultList) {
                    for (ProjectSpacePathBO spaceName : newPathBatch) {
                        if (!monitor.getProjectSpaceId().equals(spaceName.getId())) continue;
                        monitor.setProjectSpaceName(spaceName.getNameStr());
                    }
                }
            }
            resultPage.setResult(resultList);
            response.setData((Object)resultPage);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse generateTaks() {
        BaseResponse response = new BaseResponse();
        try {
            Set keys = this.redisTemplate.opsForHash().keys((Object)"dbm:sentry:autocreate:worksheet");
            log.info("\u81ea\u52a8\u521b\u5efa\u521b\u5efa\u5de5\u5355\uff1a" + keys);
            if (!keys.isEmpty()) {
                for (Object key : keys) {
                    TaskKafkaBO kafka = (TaskKafkaBO)this.redisTemplate.opsForHash().get((Object)"dbm:sentry:autocreate:worksheet", key);
                    if (kafka.getAuto() != 1) continue;
                    KafkaAlertBO kafkaAlertBO = new KafkaAlertBO();
                    CreateTaskQueryDTO query = new CreateTaskQueryDTO();
                    TaskInsertDoBO taskQuery = new TaskInsertDoBO();
                    ArrayList<TaskSpaceInsertBO> taskSpaceInfo = new ArrayList<TaskSpaceInsertBO>();
                    TaskSpaceInsertBO taskSpace = new TaskSpaceInsertBO();
                    taskSpace.setSpaceId(kafka.getSpaceId());
                    taskSpaceInfo.add(taskSpace);
                    ArrayList<String> operatingId = new ArrayList<String>();
                    operatingId.add(this.robotPositionId);
                    taskQuery.setCreateByPositionId(this.robotPositionId);
                    taskQuery.setTenantId(kafka.getTenantId());
                    taskQuery.setProjectId(kafka.getProjectId());
                    taskQuery.setTaskTypeId(ENABLE_ALARM);
                    taskQuery.setCreateBy(this.robotId);
                    taskQuery.setTaskTemplateId(kafka.getTaskTemplateId());
                    taskQuery.setTaskName("sentry\u81ea\u52a8\u62a5\u8b66");
                    taskQuery.setTaskDescription("\u4f4d\u7f6e:" + kafka.getSpaceName() + "; \u62a5\u8b66\u8bbe\u5907/\u8bbe\u65bd:" + kafka.getAssetName() + "; \u62a5\u8b66\u5185\u5bb9:" + kafka.getMessage() + "; \u62a5\u8b66\u65f6\u95f4:" + kafka.getCollectTime());
                    taskQuery.setCreateByPositionId(this.robotPositionId);
                    query.setTask(taskQuery);
                    kafkaAlertBO.setAlertId(key.toString());
                    kafkaAlertBO.setTaskBO(query);
                    kafkaAlertBO.getTaskBO().setTaskSpaceList(taskSpaceInfo);
                    String sendInfo = JSONUtils.jacksonToJson((Object)kafkaAlertBO);
                    log.info("\u81ea\u52a8\u521b\u5efa\u5de5\u5355\uff0ckafka\u53d1\u9001\u6570\u636e" + sendInfo);
                    this.ifwKafkaClientCreateTask.syncProduce(sendInfo);
                }
                this.redisTemplate.delete((Object)"dbm:sentry:autocreate:worksheet");
            }
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse updateDataPoint(UpMonitorRecordDTO upMonitorRecordDTO) {
        BaseResponse response = new BaseResponse();
        return response;
    }

    public BaseResponse insetAlertNotice(InsetAlertNoticeDTO insetAlertNotice, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)insetAlertNotice.getTenantId(), (IFWUser)user);
            insetAlertNotice.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("\u4e0d\u5b58\u5728appId\uff0c\u8bf7\u7533\u8bf7!", "15");
            }
            AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
            ArrayList<String> ruleList = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)insetAlertNotice.getAlarmChannel())) {
                String[] split;
                for (String rule : split = insetAlertNotice.getAlarmChannel().split(",")) {
                    if ("callback".equals(rule)) continue;
                    ruleList.add(rule);
                }
            }
            if (DataUtils.isListAvali(ruleList)) {
                insert.setAlarmChannel(String.join((CharSequence)",", ruleList));
            }
            insert.setAppId(queryAppIdBO.getAppId());
            insert.setAlarmRuleName(insetAlertNotice.getAlarmRuleName());
            insert.setSmsPhoneNumbers(insetAlertNotice.getSmsPhoneNumbers());
            insert.setEmailToAddresses(insetAlertNotice.getEmailToAddresses());
            insert.setVoiceToPhoneNumber(insetAlertNotice.getVoiceToPhoneNumber());
            insert.setValidTime(insetAlertNotice.getValidTime());
            insert.setAlarmCycle(insetAlertNotice.getAlarmCycle());
            this.godzillaServerRepository.addAlarmRule(insert);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<PageDTO<AlertListDTO>> alertList(AlertListQueryDTO alertList, IFWUser user) {
        BaseResponse response = new BaseResponse();
        PageDTO resultPage = new PageDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)alertList.getTenantId(), (IFWUser)user);
            alertList.setTenantId(tenantId);
            AlarmRuleListReqBO query = new AlarmRuleListReqBO();
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO appid = this.monitorRepository.queryAppId(queryAppId);
            if (StringUtils.isEmpty((CharSequence)appid.getAppId())) {
                throw new BizException("\u65e0appId,\u8bf7\u7533\u8bf7appId", PlatformCodeEnum.SYS_ERROR.getCode());
            }
            BeanUtils.copyProperties((Object)alertList, (Object)query);
            query.setAppId(appid.getAppId());
            query.setPageSize(alertList.getPageSize().intValue());
            query.setPageNum(alertList.getPageIndex().intValue());
            PageDTO alarmRuleBOS = this.godzillaServerRepository.queryAlarmRuleList(query);
            if (alarmRuleBOS != null) {
                BeanUtils.copyProperties((Object)alarmRuleBOS, (Object)resultPage);
                List resultList = IFWBeanCopyUtil.mapAsList((Iterable)alarmRuleBOS.getResult(), AlertListDTO.class);
                resultPage.setResult(resultList);
            }
            response.setData((Object)resultPage);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse updateAlert(UpAlertNoticeDTO updateAlert, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)updateAlert.getTenantId(), (IFWUser)user);
            updateAlert.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppIdQueryDTO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDTO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDTO);
            if (StringUtils.isEmpty((CharSequence)queryAppIdBO.getAppId())) {
                throw new BizException("\u65e0appId,\u8bf7\u7533\u8bf7appId", PlatformCodeEnum.SYS_ERROR.getCode());
            }
            AlarmRuleInsertBO alarmRuleBO = new AlarmRuleInsertBO();
            BeanUtils.copyProperties((Object)updateAlert, (Object)alarmRuleBO);
            alarmRuleBO.setAppId(queryAppIdBO.getAppId());
            AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
            ArrayList<String> ruleList = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)alarmRuleBO.getAlarmChannel())) {
                String[] split;
                for (String rule : split = alarmRuleBO.getAlarmChannel().split(",")) {
                    if ("callback".equals(rule)) continue;
                    ruleList.add(rule);
                }
            }
            if (DataUtils.isListAvali(ruleList)) {
                alarmRuleBO.setAlarmChannel(String.join((CharSequence)",", ruleList));
            } else {
                alarmRuleBO.setAlarmChannel(null);
            }
            this.godzillaServerRepository.updateAlarmRule(alarmRuleBO);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryAlertInfoDTO> queryAlert(QueryAlertDTO alertInfo, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)alertInfo.getTenantId(), (IFWUser)user);
            QueryAppIdQueryDoBO queryAppIdQueryDTO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDTO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDTO);
            QueryAlarmRuleDetailBO query = new QueryAlarmRuleDetailBO();
            query.setAlarmRuleId(alertInfo.getAlarmRuleId());
            AlarmRuleBO alarmRuleBO = this.godzillaServerRepository.queryAlarmRuleDetail(query);
            QueryAlertInfoDTO result = (QueryAlertInfoDTO)IFWBeanCopyUtil.map((Object)alarmRuleBO, QueryAlertInfoDTO.class);
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse deleteAlert(QueryAlertDTO alertInfo, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            this.godzillaServerRepository.deleteAlarmRule(alertInfo.getAlarmRuleId());
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse getAppId(GetAppIdDTO appIdDTO, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            AppRespBO app;
            String tenantId = CheckAccessUtils.judgeTenantId((String)appIdDTO.getTenantId(), (IFWUser)user);
            QueryAppIdQueryDoBO queryAppIdQueryDTO = new QueryAppIdQueryDoBO();
            ServiceWetherPurchaseReqDTO serviceWetherPurchaseReqDTO = new ServiceWetherPurchaseReqDTO();
            serviceWetherPurchaseReqDTO.setTenantId(tenantId);
            serviceWetherPurchaseReqDTO.setServiceId(this.sentryServiceId);
            boolean buy = this.userRepository.queryTenantWhetherPurchaseService(serviceWetherPurchaseReqDTO);
            if (buy) {
                queryAppIdQueryDTO.setTenantId(tenantId);
                QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDTO);
                if (queryAppIdBO.getAppId() != null) {
                    throw new BizException("\u8bf7\u52ff\u91cd\u590d\u521b\u5efaAppId!", "14");
                }
                AppReqBO creatApp = new AppReqBO();
                creatApp.setAppName("sentry-" + user.getOrganizationName());
                app = this.godzillaServerRepository.createApp(creatApp);
                if (app == null || app.getAppId() == null) {
                    throw new BizException("\u65e0\u6cd5\u83b7\u53d6appId\uff0c\u8bf7\u91cd\u8bd5!", "15");
                }
            } else {
                throw new BizException(PlatformCodeEnum.TENANT_NOT_BUY_SERVICE.getDesc(), PlatformCodeEnum.TENANT_NOT_BUY_SERVICE.getCode());
            }
            AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
            insert.setAppId(app.getAppId());
            insert.setCallbackUrl(this.callbackUrl);
            insert.setCallbackToken(this.callbackToken);
            insert.setAlarmChannel("callback");
            insert.setAlarmRuleName("sentry\u9ed8\u8ba4\u544a\u8b66\u6a21\u677f-" + user.getOrganizationName());
            insert.setAlarmCycle(DISABLE_ALARM);
            log.info("addAlarmRule\u5165\u53c2\uff1a" + insert);
            String ruleId = this.godzillaServerRepository.addAlarmRule(insert);
            InsertAppIdQuDoBO insertAppIdQuDoBO = new InsertAppIdQuDoBO();
            insertAppIdQuDoBO.setTenantId(tenantId);
            insertAppIdQuDoBO.setGodzillaAppId(app.getAppId());
            insertAppIdQuDoBO.setCreateTime(new Date());
            insertAppIdQuDoBO.setCreateBy(user.getUserId());
            insertAppIdQuDoBO.setDefaultAlarmRuleId(ruleId);
            this.monitorRepository.insertAppId(insertAppIdQuDoBO);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QueryAppIdDTO> queryAppId(QueryAppIdQueryDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.monitorFacade.queryAppId(query);
    }

    public BaseResponse<AlertIndexInfoDTO> sentryInfo(SentryInfoQuBasisDTO sentryInfo, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
            sentryInfo.setTenantId(tenantId);
            QueryMonitorInfoQueryBasisDoBO query = new QueryMonitorInfoQueryBasisDoBO();
            query.setAssetId(sentryInfo.getAssetId());
            query.setTenantId(tenantId);
            query.setProjectId(sentryInfo.getProjectId());
            query.setLanguageCode(sentryInfo.getLanguageCode());
            QueryMonitorInfoDoBO queryMonitorInfoDoBOPageDTO = this.monitorRepository.queryMonitorInfo(query);
            if (queryMonitorInfoDoBOPageDTO == null) {
                return response;
            }
            AlertIndexInfoDTO resultDTO = (AlertIndexInfoDTO)IFWBeanCopyUtil.map((Object)queryMonitorInfoDoBOPageDTO, AlertIndexInfoDTO.class);
            QueryRecordingQueryDoBO queryRecord = new QueryRecordingQueryDoBO();
            queryRecord.setProjectId(sentryInfo.getProjectId());
            queryRecord.setMonitorTargetId(sentryInfo.getMonitorTargetId());
            queryRecord.setLanguageCode("CN");
            queryRecord.setTenantId(tenantId);
            PageDTO monitorPage = this.monitorRepository.queryRecordingList(queryRecord);
            if (!DataUtils.isListAvali((List)monitorPage.getResult())) {
                response.setData((Object)resultDTO);
                return response;
            }
            List alertIndexListDTOS = IFWBeanCopyUtil.mapAsList((Iterable)monitorPage.getResult(), AlertIndexListDTO.class);
            resultDTO.setAlertRecording(alertIndexListDTOS);
            response.setData((Object)resultDTO);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<MetricValueRecordListDTO> godzillaInfo(GodzillaInfoQuDTO godzillaInfoQu, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)godzillaInfoQu.getTenantId(), (IFWUser)user);
            godzillaInfoQu.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("\u4e0d\u5b58\u5728appId\uff0c\u8bf7\u7533\u8bf7!", "15");
            }
            ArrayList resultList = new ArrayList();
            MetricValueRecordListReqBO querygodzilla = new MetricValueRecordListReqBO();
            BeanUtils.copyProperties((Object)godzillaInfoQu, (Object)querygodzilla);
            querygodzilla.setAppId(queryAppIdBO.getAppId());
            MetricValueRecordListBO queryInfo = this.godzillaServerRepository.queryMetricValueRecordList(querygodzilla);
            if (queryInfo != null) {
                MetricValueRecordListDTO result = (MetricValueRecordListDTO)IFWBeanCopyUtil.map((Object)queryInfo, MetricValueRecordListDTO.class);
                QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                queryRuleAndStartBO.setDataPointId(godzillaInfoQu.getDataPointId());
                QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                if (queryRuleAndStartDoBO != null) {
                    result.setUnit(queryRuleAndStartDoBO.getUnit());
                }
                response.setData((Object)result);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<QuerySentryInfoDTO> querySentryInfo(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.querySentryInfo(sentryInfo);
    }

    public BaseResponse<QuerySentryInfoAssetDTO> querySentryInfoAsset(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.querySentryInfoAsset(sentryInfo);
    }

    public BaseResponse<QuerySentryInfoSevenDayDTO> querySentryInfoSevenDay(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.querySentryInfoSevenDay(sentryInfo);
    }

    public BaseResponse<SentryInfoRankingDTO> querySentryInfoRanking(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.querySentryInfoRanking(sentryInfo);
    }

    public BaseResponse<SentryInfoIntactDTO> querySentryInfoIntact(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.querySentryInfoIntact(sentryInfo);
    }

    public BaseResponse<IFWPageInfo<SeerTagListDTO>> seerTagList(QuerySentryInfoQueryDTO sentryInfo, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)sentryInfo.getTenantId(), (IFWUser)user);
        sentryInfo.setTenantId(tenantId);
        return this.monitorFacade.seerTagList(sentryInfo);
    }

    public BaseResponse<SentryMonitorRankingDTO> sentryMonitor(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user) {
        BaseResponse response = new BaseResponse();
        SentryMonitorRankingDTO result = new SentryMonitorRankingDTO();
        try {
            IFWPageInfo monitorList;
            Date startTime = null;
            Date endTime = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (ENABLE_ALARM.equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getDayBegin();
                endTime = DataUtils.getDayEnd();
            }
            if ("2".equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getBeginDayOfWeek();
                endTime = DataUtils.getEndDayOfWeek();
            }
            if ("3".equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getBeginDayOfMonth();
                endTime = DataUtils.getEndDayOfMonth();
            }
            ArrayList spaceIds = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                GetSonSpaceQueryBO querySpace = new GetSonSpaceQueryBO();
                querySpace.setSpaceId(rankingQuDTO.getSpaceId());
                GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(querySpace);
                spaceIds.addAll(sonpace.getSpaceId());
            }
            String tenantId = CheckAccessUtils.judgeTenantId((String)rankingQuDTO.getTenantId(), (IFWUser)user);
            rankingQuDTO.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorListDoQueryBO = new QueryMonitorListDoQueryBO();
            queryMonitorListDoQueryBO.setProjectId(rankingQuDTO.getProjectId());
            queryMonitorListDoQueryBO.setTenantId(tenantId);
            queryMonitorListDoQueryBO.setLanguageCode(rankingQuDTO.getLanguageCode());
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                queryMonitorListDoQueryBO.setSpaceId(spaceIds);
            }
            if ((monitorList = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO)) != null) {
                QueryRecordingQueryDoBO queryRecordingQueryDoBO = new QueryRecordingQueryDoBO();
                queryRecordingQueryDoBO.setProjectId(rankingQuDTO.getProjectId());
                queryRecordingQueryDoBO.setLanguageCode(rankingQuDTO.getLanguageCode());
                queryRecordingQueryDoBO.setTenantId(tenantId);
                queryRecordingQueryDoBO.setBeginTime(formatter.format(startTime));
                queryRecordingQueryDoBO.setEndTime(formatter.format(endTime));
                if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                    queryRecordingQueryDoBO.setSpaceId(spaceIds);
                }
                Integer faultNumber = 0;
                Integer normalNumber = 0;
                ArrayList faultAssetList = new ArrayList();
                ArrayList normalAssetList = new ArrayList();
                Map<String, List<QueryMonitorListDoBO>> assetStatusMap = monitorList.getList().stream().filter(a -> a.getAssetStatus() != null).collect(Collectors.groupingBy(QueryMonitorListDoBO::getAssetStatus));
                for (Map.Entry<String, List<QueryMonitorListDoBO>> assetStatus : assetStatusMap.entrySet()) {
                    if (ENABLE_ALARM.equals(assetStatus.getKey())) {
                        normalNumber = assetStatus.getValue().size();
                        normalAssetList.addAll(assetStatus.getValue());
                    }
                    if (!"2".equals(assetStatus.getKey())) continue;
                    faultNumber = assetStatus.getValue().size();
                    faultAssetList.addAll(assetStatus.getValue());
                }
                result.setAssetNumber(Integer.valueOf(monitorList.getList().size()));
                if (faultNumber == 0) {
                    result.setNormalProportion(new BigDecimal("100"));
                    result.setFaultProportion(new BigDecimal(DISABLE_ALARM));
                    result.setAssetFaultedNumber(Integer.valueOf(0));
                } else {
                    result.setAssetFaultedNumber(faultNumber);
                    result.setFaultProportion(MathUtils.divideGetPercent((Object)faultNumber, (Object)monitorList.getList().size(), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                    result.setNormalProportion(MathUtils.divideGetPercent((Object)normalNumber, (Object)monitorList.getList().size(), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                }
                PageDTO recordingList1 = this.monitorRepository.queryRecordingList(queryRecordingQueryDoBO);
                if (DataUtils.isListAvali((List)recordingList1.getResult())) {
                    Integer faultReNumber = 0;
                    Map<String, List<QueryRecordingListDoBO>> monitorTargetMap = recordingList1.getResult().stream().collect(Collectors.groupingBy(QueryRecordingListDoBO::getMonitorTargetId));
                    List monitorTargetList = recordingList1.getResult().stream().map(QueryRecordingListDoBO::getMonitorTargetId).distinct().collect(Collectors.toList());
                    for (QueryMonitorListDoBO monitorListDoBO : normalAssetList) {
                        if (!monitorTargetList.contains(monitorListDoBO.getMonitorTargetId())) continue;
                        Integer n = faultReNumber;
                        Integer n2 = faultReNumber = Integer.valueOf(faultReNumber + 1);
                    }
                    result.setRepairProportion(MathUtils.divideGetPercent((Object)faultReNumber, (Object)monitorTargetList.size(), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                } else {
                    result.setRepairProportion(new BigDecimal(DISABLE_ALARM));
                }
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<SentryRankDTO> sentryRanking(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user) {
        BaseResponse response = new BaseResponse();
        SentryRankDTO result = new SentryRankDTO();
        ArrayList<MonitorRankingDTO> resultList = new ArrayList<MonitorRankingDTO>();
        try {
            String key = null;
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                key = RedisKeyPrefixUtil.getAssetCountInfoType((String)(rankingQuDTO.getProjectId() + rankingQuDTO.getTime() + rankingQuDTO.getSpaceId() + rankingQuDTO.getLanguageCode()));
            }
            if (StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                key = RedisKeyPrefixUtil.getAssetCountInfoType((String)(rankingQuDTO.getProjectId() + rankingQuDTO.getTime() + rankingQuDTO.getLanguageCode()));
            }
            Date startTime = null;
            Date endTime = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (ENABLE_ALARM.equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getDayBegin();
                endTime = DataUtils.getDayEnd();
            }
            if ("2".equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getBeginDayOfWeek();
                endTime = DataUtils.getEndDayOfWeek();
            }
            if ("3".equals(rankingQuDTO.getTime())) {
                startTime = DataUtils.getBeginDayOfMonth();
                endTime = DataUtils.getEndDayOfMonth();
            }
            String tenantId = CheckAccessUtils.judgeTenantId((String)rankingQuDTO.getTenantId(), (IFWUser)user);
            rankingQuDTO.setTenantId(tenantId);
            TranslationDoBO translationDoBO = new TranslationDoBO();
            translationDoBO.setLanguageCode(rankingQuDTO.getLanguageCode());
            AllTranslationDoBO allTranslationDoBO = this.assetRepository.allTranslation(translationDoBO);
            for (Map.Entry tagIds : allTranslationDoBO.getSystem().entrySet()) {
                MonitorRankingDTO resultDTO = new MonitorRankingDTO();
                resultDTO.setTagName((String)tagIds.getValue());
                resultDTO.setTagId((String)tagIds.getKey());
                resultList.add(resultDTO);
            }
            result.setRankInfo(resultList);
            ArrayList spaceIds = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                GetSonSpaceQueryBO querySpace = new GetSonSpaceQueryBO();
                querySpace.setSpaceId(rankingQuDTO.getSpaceId());
                GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(querySpace);
                spaceIds.addAll(sonpace.getSpaceId());
            }
            QueryMonitorListDoQueryBO queryMonitorListDoQueryBO = new QueryMonitorListDoQueryBO();
            queryMonitorListDoQueryBO.setProjectId(rankingQuDTO.getProjectId());
            queryMonitorListDoQueryBO.setTenantId(tenantId);
            queryMonitorListDoQueryBO.setLanguageCode(rankingQuDTO.getLanguageCode());
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                queryMonitorListDoQueryBO.setSpaceId(spaceIds);
            }
            IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO);
            queryMonitorListDoQueryBO.setAssetStatus("2");
            IFWPageInfo monitorList1 = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO);
            if (monitorList != null) {
                List faultNumber = null;
                if (monitorList1 != null) {
                    faultNumber = monitorList1.getList();
                    result.setTotal(Integer.valueOf(monitorList1.getList().size()));
                } else {
                    result.setTotal(Integer.valueOf(0));
                }
                List notNullList = monitorList.getList().stream().filter(a -> a.getAssetSystemId() != null).collect(Collectors.toList());
                if (DataUtils.isListAvali(notNullList)) {
                    Map<String, List<QueryMonitorListDoBO>> tagIdMap = notNullList.stream().collect(Collectors.groupingBy(QueryMonitorListDoBO::getAssetSystemId));
                    for (MonitorRankingDTO resultDTO : result.getRankInfo()) {
                        for (Map.Entry<String, List<QueryMonitorListDoBO>> tagId : tagIdMap.entrySet()) {
                            PageDTO recordingList;
                            if (!StringUtils.equals((CharSequence)resultDTO.getTagId(), (CharSequence)tagId.getKey()) || !DataUtils.isListAvali(tagId.getValue())) continue;
                            int normal = 0;
                            QueryRecordingQueryDoBO queryRecording = new QueryRecordingQueryDoBO();
                            queryRecording.setBeginTime(formatter.format(startTime));
                            queryRecording.setEndTime(formatter.format(endTime));
                            queryRecording.setProjectId(rankingQuDTO.getProjectId());
                            queryRecording.setLanguageCode(rankingQuDTO.getLanguageCode());
                            queryRecording.setTenantId(tenantId);
                            queryRecording.setAssetSystemId(tagId.getKey());
                            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                                queryRecording.setSpaceId(spaceIds);
                            }
                            if (DataUtils.isListAvali((List)(recordingList = this.monitorRepository.queryRecordingList(queryRecording)).getResult())) {
                                List ids = recordingList.getResult().stream().map(QueryRecordingListDoBO::getAssetId).distinct().collect(Collectors.toList());
                                for (QueryMonitorListDoBO monitor : tagId.getValue()) {
                                    if (ids.contains(monitor.getAssetId())) continue;
                                    ++normal;
                                }
                                resultDTO.setNormalNumber(Integer.valueOf(normal));
                                if (DataUtils.isListAvali((List)faultNumber)) {
                                    resultDTO.setFaultNumber(Integer.valueOf(faultNumber.size()));
                                    resultDTO.setFixNumber(Integer.valueOf(tagId.getValue().size() - faultNumber.size() - normal));
                                    continue;
                                }
                                resultDTO.setFaultNumber(Integer.valueOf(0));
                                resultDTO.setFixNumber(Integer.valueOf(tagId.getValue().size() - normal));
                                continue;
                            }
                            resultDTO.setFaultNumber(Integer.valueOf(0));
                            resultDTO.setFixNumber(Integer.valueOf(0));
                            resultDTO.setNormalNumber(Integer.valueOf(tagId.getValue().size()));
                        }
                    }
                }
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<TagInfoDTO>> tagInfo(TagInfoQuDTO tagQuery, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            List notNullList;
            String tenantId = CheckAccessUtils.judgeTenantId((String)tagQuery.getTenantId(), (IFWUser)user);
            tagQuery.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorListDoQueryBO = new QueryMonitorListDoQueryBO();
            queryMonitorListDoQueryBO.setProjectId(tagQuery.getProjectId());
            queryMonitorListDoQueryBO.setTenantId(tenantId);
            queryMonitorListDoQueryBO.setLanguageCode(tagQuery.getLanguageCode());
            IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO);
            ArrayList<TagInfoDTO> resultList = new ArrayList<TagInfoDTO>();
            if (monitorList != null && DataUtils.isListAvali(notNullList = monitorList.getList().stream().filter(monitor -> monitor.getAssetSystemId() != null).collect(Collectors.toList()))) {
                Map<String, List<QueryMonitorListDoBO>> tagMap = notNullList.stream().collect(Collectors.groupingBy(QueryMonitorListDoBO::getAssetSystemId));
                for (Map.Entry<String, List<QueryMonitorListDoBO>> tagId : tagMap.entrySet()) {
                    TagInfoDTO result = new TagInfoDTO();
                    result.setTagId(tagId.getKey());
                    result.setTagName(tagId.getValue().get(0).getSystemName());
                    int normalNumber = 0;
                    int abnormalNumber = 0;
                    Map<String, List<QueryMonitorListDoBO>> assetStatusMap = tagId.getValue().stream().filter(a -> a.getAssetStatus() != null).collect(Collectors.groupingBy(QueryMonitorListDoBO::getAssetStatus));
                    for (Map.Entry<String, List<QueryMonitorListDoBO>> assetStatus : assetStatusMap.entrySet()) {
                        if (ENABLE_ALARM.equals(assetStatus.getKey())) {
                            normalNumber = assetStatus.getValue().size();
                        }
                        if (!"2".equals(assetStatus.getKey())) continue;
                        abnormalNumber = assetStatus.getValue().size();
                    }
                    result.setAbnormalNumber(Integer.valueOf(abnormalNumber));
                    result.setNormalNumber(Integer.valueOf(normalNumber));
                    resultList.add(result);
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<TagFaultPercentDTO> tagFaultPercent(TagFaultPercentQuDTO percentQuery, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)percentQuery.getTenantId(), (IFWUser)user);
            percentQuery.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorListDoQueryBO = new QueryMonitorListDoQueryBO();
            queryMonitorListDoQueryBO.setProjectId(percentQuery.getProjectId());
            queryMonitorListDoQueryBO.setTenantId(tenantId);
            queryMonitorListDoQueryBO.setLanguageCode(percentQuery.getLanguageCode());
            queryMonitorListDoQueryBO.setAssetSystemId(percentQuery.getTagId());
            IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO);
            if (monitorList != null) {
                TagFaultPercentDTO result = new TagFaultPercentDTO();
                result.setTagId(((QueryMonitorListDoBO)monitorList.getList().get(0)).getAssetSystemId());
                result.setTagName(((QueryMonitorListDoBO)monitorList.getList().get(0)).getSystemName());
                result.setAssetNumber(Integer.valueOf(monitorList.getList().size()));
                int norma = 0;
                for (QueryMonitorListDoBO monitorListDoBO : monitorList.getList()) {
                    if ("2".equals(monitorListDoBO.getAssetStatus())) continue;
                    ++norma;
                }
                BigDecimal oneHundred = new BigDecimal("100");
                BigDecimal normaBig = new BigDecimal(norma);
                BigDecimal normaPercent = MathUtils.divideGetPercent((Object)normaBig, (Object)monitorList.getList().size(), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                result.setFaultPercent(oneHundred.subtract(normaPercent));
                result.setNormalPercent(normaPercent);
                response.setData((Object)result);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<MonitorSpaceDTO>> monitorSpace(MonitorSpaceQuDTO spaceQu, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            IFWPageInfo monitorList;
            String tenantId = CheckAccessUtils.judgeTenantId((String)spaceQu.getTenantId(), (IFWUser)user);
            spaceQu.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorListDoQueryBO = new QueryMonitorListDoQueryBO();
            queryMonitorListDoQueryBO.setProjectId(spaceQu.getProjectId());
            queryMonitorListDoQueryBO.setTenantId(tenantId);
            queryMonitorListDoQueryBO.setLanguageCode(spaceQu.getLanguageCode());
            if (!StringUtils.isEmpty((CharSequence)spaceQu.getSpaceId())) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(spaceQu.getSpaceId());
                queryMonitorListDoQueryBO.setSpaceId(ids);
            }
            if ((monitorList = this.monitorRepository.queryMonitorList(queryMonitorListDoQueryBO)) != null) {
                ArrayList<MonitorSpaceDTO> resultList = new ArrayList<MonitorSpaceDTO>();
                ArrayList<String> spaceIds = new ArrayList<String>();
                Map<String, List<QueryMonitorListDoBO>> spaceMap = monitorList.getList().stream().collect(Collectors.groupingBy(QueryMonitorListDoBO::getProjectSpaceId));
                for (Map.Entry<String, List<QueryMonitorListDoBO>> spaceId : spaceMap.entrySet()) {
                    spaceIds.add(spaceId.getKey());
                    MonitorSpaceDTO result = new MonitorSpaceDTO();
                    result.setSpaceId(spaceId.getKey());
                    result.setAssetNumber(Integer.valueOf(spaceId.getValue().size()));
                    int norma = 0;
                    List collect = spaceId.getValue().stream().filter(a -> !"2".equals(a.getAssetStatus())).collect(Collectors.toList());
                    if (DataUtils.isListAvali(collect)) {
                        norma = collect.size();
                    }
                    result.setAbnormalNumber(Integer.valueOf(spaceId.getValue().size() - norma));
                    result.setNormalNumber(Integer.valueOf(norma));
                    BigDecimal normalPercent = MathUtils.divideGetPercent((Object)norma, (Object)spaceId.getValue().size(), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                    result.setNormalPercent(normalPercent);
                    BigDecimal bigDecimal = new BigDecimal("100");
                    result.setAbnormalPercent(bigDecimal.subtract(normalPercent));
                    resultList.add(result);
                }
                GetNewPathBatchQueryBO queryName = new GetNewPathBatchQueryBO();
                queryName.setProjectSpaceId(spaceIds);
                queryName.setProjectId(spaceQu.getProjectId());
                queryName.setLanguageCode(spaceQu.getLanguageCode());
                queryName.setTenantId(spaceQu.getTenantId());
                List spaceName = this.spaceRepository.getNewPathBatch(queryName);
                if (DataUtils.isListAvali((List)spaceName)) {
                    for (MonitorSpaceDTO result : resultList) {
                        for (ProjectSpacePathBO name : spaceName) {
                            if (!StringUtils.equals((CharSequence)result.getSpaceId(), (CharSequence)name.getId())) continue;
                            result.setSpaceName(name.getNameStr());
                        }
                    }
                }
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse insertTag(InsertTagQuDTO insertTag, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)insertTag.getTenantId(), (IFWUser)user);
        insertTag.setTenantId(tenantId);
        UpInsertTagQuDTO upInsertTagQuDTO = (UpInsertTagQuDTO)IFWBeanCopyUtil.map((Object)insertTag, UpInsertTagQuDTO.class);
        upInsertTagQuDTO.setCreateBy(user.getUserId());
        upInsertTagQuDTO.setType(Integer.valueOf(1));
        return this.monitorFacade.upInsertTag(upInsertTagQuDTO);
    }

    public BaseResponse updateTag(UpdateTagQuDTO updateTag, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)updateTag.getTenantId(), (IFWUser)user);
        updateTag.setTenantId(tenantId);
        UpInsertTagQuDTO upInsertTagQuDTO = (UpInsertTagQuDTO)IFWBeanCopyUtil.map((Object)updateTag, UpInsertTagQuDTO.class);
        upInsertTagQuDTO.setUpdateBy(user.getUserId());
        upInsertTagQuDTO.setType(Integer.valueOf(2));
        return this.monitorFacade.upInsertTag(upInsertTagQuDTO);
    }

    public BaseResponse deleteTag(DeleteTagQuDTO deleteTag, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)deleteTag.getTenantId(), (IFWUser)user);
        deleteTag.setTenantId(tenantId);
        deleteTag.setUpdateBy(user.getUserId());
        return this.monitorFacade.deleteTag(deleteTag);
    }

    public BaseResponse<TransferNumberDTO> transferNumber(TransferNumberQuDTO appId, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)appId.getTenantId(), (IFWUser)user);
            appId.setTenantId(tenantId);
            TransferNumberQuDoBO transferNumberQuDoBO = new TransferNumberQuDoBO();
            TransferNumberDoBO query = this.godzillaServerRepository.transferNumber((TransferNumberQuDoBO)IFWBeanCopyUtil.map((Object)appId, TransferNumberQuDoBO.class));
            TransferNumberDTO result = (TransferNumberDTO)IFWBeanCopyUtil.map((Object)query, TransferNumberDTO.class);
            result.setApiLastNumber(Integer.valueOf(query.getApiNumber() - query.getApiUseNumber()));
            result.setCallbackLastNumber(Integer.valueOf(query.getCallbackNumber() - query.getCallbackUseNumber()));
            result.setEmailLastNumber(Integer.valueOf(query.getEmailNumber() - query.getEmailUseNumber()));
            result.setSmsLastNumber(Integer.valueOf(query.getSmsNumber() - query.getSmsUseNumber()));
            result.setVoiceLastNumber(Integer.valueOf(query.getVoiceNumber() - query.getVoiceUseNumber()));
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse deleteMonitor(DeleteMonitorDTO delete, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)delete.getTenantId(), (IFWUser)user);
        delete.setTenantId(tenantId);
        delete.setUpdateBy(user.getUserId());
        return this.monitorFacade.deleteMonitor(delete);
    }

    public BaseResponse<IFWPageInfo<QueryMonitorTagListDTO>> queryTagList(QueryMonitorTagListQuDTO queryList, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)queryList.getTenantId(), (IFWUser)user);
        queryList.setTenantId(tenantId);
        return this.monitorFacade.queryTagList(queryList);
    }

    public BaseResponse<alertNumberRanking> alertNumberRanking(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user) {
        BaseResponse response = new BaseResponse();
        alertNumberRanking result = new alertNumberRanking();
        ArrayList<alertNumberDTO> resultList = new ArrayList<alertNumberDTO>();
        try {
            alertNumberRanking queryRedis;
            String key = null;
            if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                key = RedisKeyPrefixUtil.getAssetCountInfoType((String)(rankingQuDTO.getProjectId() + rankingQuDTO.getTime() + rankingQuDTO.getSpaceId() + rankingQuDTO.getLanguageCode()));
            }
            if (StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                key = RedisKeyPrefixUtil.getAssetCountInfoType((String)(rankingQuDTO.getProjectId() + rankingQuDTO.getTime() + rankingQuDTO.getLanguageCode()));
            }
            if ((queryRedis = (alertNumberRanking)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getSentrySeerAlertNumberRanking(key))) == null) {
                Date startTime = null;
                Date endTime = null;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (ENABLE_ALARM.equals(rankingQuDTO.getTime())) {
                    startTime = DataUtils.getDayBegin();
                    endTime = DataUtils.getDayEnd();
                }
                if ("2".equals(rankingQuDTO.getTime())) {
                    startTime = DataUtils.getBeginDayOfWeek();
                    endTime = DataUtils.getEndDayOfWeek();
                }
                if ("3".equals(rankingQuDTO.getTime())) {
                    startTime = DataUtils.getBeginDayOfMonth();
                    endTime = DataUtils.getEndDayOfMonth();
                }
                String tenantId = CheckAccessUtils.judgeTenantId((String)rankingQuDTO.getTenantId(), (IFWUser)user);
                rankingQuDTO.setTenantId(tenantId);
                ArrayList spaceIds = new ArrayList();
                if (!StringUtils.isEmpty((CharSequence)rankingQuDTO.getSpaceId())) {
                    GetSonSpaceQueryBO querySpace = new GetSonSpaceQueryBO();
                    querySpace.setSpaceId(rankingQuDTO.getSpaceId());
                    GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(querySpace);
                    spaceIds.addAll(sonpace.getSpaceId());
                }
                TranslationDoBO translationDoBO = new TranslationDoBO();
                translationDoBO.setLanguageCode(rankingQuDTO.getLanguageCode());
                AllTranslationDoBO allTranslationDoBO = this.assetRepository.allTranslation(translationDoBO);
                for (Map.Entry tagIds : allTranslationDoBO.getSystem().entrySet()) {
                    alertNumberDTO alertNumberRanking2 = new alertNumberDTO();
                    alertNumberRanking2.setTagName((String)tagIds.getValue());
                    alertNumberRanking2.setTagId((String)tagIds.getKey());
                    resultList.add(alertNumberRanking2);
                }
                QueryRecordingQueryDoBO queryRecordingList = new QueryRecordingQueryDoBO();
                queryRecordingList.setProjectId(rankingQuDTO.getProjectId());
                queryRecordingList.setSpaceId(spaceIds);
                queryRecordingList.setBeginTime(formatter.format(startTime));
                queryRecordingList.setEndTime(formatter.format(endTime));
                queryRecordingList.setLanguageCode(rankingQuDTO.getLanguageCode());
                queryRecordingList.setTenantId(rankingQuDTO.getTenantId());
                List recordingAllList = this.monitorRepository.queryRecordingList(queryRecordingList).getResult();
                for (alertNumberDTO tagId : resultList) {
                    if (DataUtils.isListAvali((List)recordingAllList)) {
                        List collect = recordingAllList.stream().filter(a -> a.getAssetSystemId() != null).collect(Collectors.toList());
                        result.setTotal(Integer.valueOf(collect.size()));
                        queryRecordingList.setAssetSystemId(tagId.getTagId());
                        List recordingList = this.monitorRepository.queryRecordingList(queryRecordingList).getResult();
                        if (DataUtils.isListAvali((List)recordingList)) {
                            tagId.setAlertNumber(Integer.valueOf(recordingList.size()));
                            continue;
                        }
                        tagId.setAlertNumber(Integer.valueOf(0));
                        continue;
                    }
                    tagId.setAlertNumber(Integer.valueOf(0));
                    result.setTotal(Integer.valueOf(0));
                }
            }
            if (DataUtils.isListAvali(resultList)) {
                List collect = resultList.stream().sorted(Comparator.comparing(alertNumberDTO::getAlertNumber).reversed()).collect(Collectors.toList());
                result.setRankInfo(collect);
            } else {
                result.setRankInfo(resultList);
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<monitorSeerInfoDTO> monitorSeerInfo(monitorSeerInfoQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        monitorSeerInfoDTO result = new monitorSeerInfoDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
            queryMonitorList.setProjectId(query.getProjectId());
            queryMonitorList.setLanguageCode(query.getLanguageCode());
            queryMonitorList.setTenantId(query.getTenantId());
            List monitorList = this.monitorRepository.queryMonitorList(queryMonitorList).getList();
            if (monitorList != null) {
                result.setTotal(Integer.valueOf(monitorList.size()));
                Map<String, List<QueryMonitorListDoBO>> status = monitorList.stream().filter(a -> a.getAssetStatus() != null).collect(Collectors.groupingBy(QueryMonitorListDoBO::getAssetStatus));
                for (Map.Entry<String, List<QueryMonitorListDoBO>> statusId : status.entrySet()) {
                    if ("2".equals(statusId.getKey())) {
                        result.setFaultAsset(Integer.valueOf(statusId.getValue().size()));
                        continue;
                    }
                    result.setNormalAsset(Integer.valueOf(statusId.getValue().size()));
                }
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<SeerQuerySentryInfoDTO> seerQuerySentryInfo(SeerQuerySentryInfoQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        SeerQuerySentryInfoDTO result = new SeerQuerySentryInfoDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
            ArrayList spaceIds = new ArrayList();
            if (StringUtils.isEmpty((CharSequence)query.getSpaceId())) {
                GetSonSpaceQueryBO querySapceId = new GetSonSpaceQueryBO();
                querySapceId.setSpaceId(query.getSpaceId());
                GetSonSpaceBO sonpace = this.spaceRepository.getSonpace(querySapceId);
                if (DataUtils.isListAvali((List)sonpace.getSpaceId())) {
                    spaceIds.addAll(sonpace.getSpaceId());
                }
                queryMonitorList.setSpaceId(spaceIds);
            }
            queryMonitorList.setProjectId(query.getProjectId());
            queryMonitorList.setAssetStatus("2");
            IFWPageInfo monitorList = this.monitorRepository.queryMonitorList(queryMonitorList);
            if (monitorList != null) {
                result.setAlertNumber(Integer.valueOf(monitorList.getList().size()));
            }
            result.setSpaceId(query.getSpaceId());
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<Boolean> sentryQueryTask(SentryQueryTaskQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.monitorFacade.sentryQueryTask(query);
    }

    public BaseResponse<QueryAllByStatisticsDTO> queryAllByStatistics(QueryAllByStatisticsQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.monitorFacade.queryAllByStatistics(query);
    }

    public BaseResponse<queryDataPointIdDTO> queryDataPointId(queryDataPointIdQuDTO upMonitorRecordDTO) {
        return this.monitorFacade.queryDataPointId(upMonitorRecordDTO);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(IFWUUIDUtils.randomUUID());
        }
    }
}

