/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.godzilla.AddMaxAndMinDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.DeleteMaxAndMinDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.QueryMaxAndMinDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.QueryMaxAndMinQuDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.UpdateMaxAndMinDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO;
import com.ifourthwall.dbm.sentry.bo.AddMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.DeleteMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.UpdateMaxAndMinBO;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.service.MonitorGodzillaService;
import java.text.ParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MonitorGodzillaServiceImpl")
public class MonitorGodzillaServiceImpl
implements MonitorGodzillaService {
    private static final Logger log = LoggerFactory.getLogger(MonitorGodzillaServiceImpl.class);
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    public BaseResponse addMaxAndMin(AddMaxAndMinDTO add, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)add.getTenantId(), (IFWUser)user);
            AddMaxAndMinBO addINfo = (AddMaxAndMinBO)IFWBeanCopyUtil.map((Object)add, AddMaxAndMinBO.class);
            addINfo.setCompareDuration(Integer.valueOf(add.getCompareDuration() * 60 * 1000));
            this.godzillaServerRepository.addMaxAndMin(addINfo);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse updateMaxAndMin(UpdateMaxAndMinDTO update, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)update.getTenantId(), (IFWUser)user);
            UpdateMaxAndMinBO updateInfo = (UpdateMaxAndMinBO)IFWBeanCopyUtil.map((Object)update, UpdateMaxAndMinBO.class);
            updateInfo.setCompareDuration(Integer.valueOf(update.getCompareDuration() * 60 * 1000));
            this.godzillaServerRepository.updateMaxAndMin(updateInfo);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse deleteMaxAndMin(DeleteMaxAndMinDTO delete, IFWUser user) {
        BaseResponse response = new BaseResponse();
        QueryInductionDTO result = new QueryInductionDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)delete.getTenantId(), (IFWUser)user);
            this.godzillaServerRepository.deleteMaxAndMin((DeleteMaxAndMinBO)IFWBeanCopyUtil.map((Object)delete, DeleteMaxAndMinBO.class));
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryMaxAndMinDTO>> queryMaxAndMin(QueryMaxAndMinQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            List queryRuleBOS = this.godzillaServerRepository.queryRule((QueryRuleAndStartBO)IFWBeanCopyUtil.map((Object)query, QueryRuleAndStartBO.class));
            if (queryRuleBOS != null) {
                List resultList = IFWBeanCopyUtil.mapAsList((Iterable)queryRuleBOS, QueryMaxAndMinDTO.class);
                for (QueryMaxAndMinDTO result : resultList) {
                    int i = result.getCompareDuration() / 60000;
                    if (i < 0) continue;
                    result.setCompareDuration(Integer.valueOf(result.getCompareDuration() / 60000));
                }
                response.setData((Object)resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public static void main(String[] args) throws ParseException {
        String a = "\u0000";
        if (a == null) {
            System.out.println("\u4e3a\u7a7a");
        } else {
            System.out.println("\u4e0d\u4e3a\u7a7a");
        }
    }
}

