/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardMetricListDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardQueryDataDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardQueryDataQuDTO;
import com.ifourthwall.dbm.asset.facade.DashboardFacade;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.domain.DashboardRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.service.DashboardDataService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DashboardDataServiceImpl")
public class DashboardDataServiceImpl
implements DashboardDataService {
    private static final Logger log = LoggerFactory.getLogger(DashboardDataServiceImpl.class);
    @Reference(version="1.0.0")
    private DashboardFacade dashboardFacade;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    public BaseResponse<DashboardQueryDataDTO> queryData(DashboardQueryDataQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            DashboardQueryDataDTO result = new DashboardQueryDataDTO();
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startTime = null;
            Date endTime = null;
            if ("1".equals(query.getTime())) {
                startTime = DataUtils.getDayBegin();
                endTime = DataUtils.getDayEnd();
            }
            ArrayList<DashboardMetricListDTO> dataList = new ArrayList<DashboardMetricListDTO>();
            for (String dataPointId : query.getDataPointId()) {
                MetricValueRecordListReqBO querygodzilla = new MetricValueRecordListReqBO();
                querygodzilla.setEndTime(endTime);
                querygodzilla.setStartTime(startTime);
                querygodzilla.setDataPointId(dataPointId);
                querygodzilla.setAppId(queryAppIdBO.getAppId());
                MetricValueRecordListBO queryInfo = this.godzillaServerRepository.queryMetricValueRecordList(querygodzilla);
                if (queryInfo == null) continue;
                DashboardMetricListDTO dateInfo = (DashboardMetricListDTO)IFWBeanCopyUtil.map((Object)queryInfo, DashboardMetricListDTO.class);
                queryDataPointIdQuBO queryDataPointIdQuBO2 = new queryDataPointIdQuBO();
                queryDataPointIdQuBO2.setDataPointId(dataPointId);
                queryDataPointIdBO queryDataPointIdBO2 = this.monitorRepository.queryDataPointId(queryDataPointIdQuBO2);
                dateInfo.setDataPointId(queryDataPointIdBO2.getDataPointId());
                dateInfo.setDataPointName(queryDataPointIdBO2.getMonitorMetricName());
                dataList.add(dateInfo);
            }
            if ("2".equals(query.getType())) {
                result.setDataPointId(dataList);
            }
            if (!"1".equals(query.getType()) || "1".equals(query.getSumType()) || "2".equals(query.getSumType())) {
                // empty if block
            }
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public static void main(String[] args) {
    }
}

