/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.security.dto.QueryAlarmRecordQuDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListQuDTO;
import com.ifourthwall.dbm.security.facade.CameraFacade;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordDoBO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordQuDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository(value="CameraRepository")
public class CameraRepository {
    private static final Logger log = LoggerFactory.getLogger(CameraRepository.class);
    @Reference(version="1.0.0")
    private CameraFacade cameraFacade;

    public IFWPageInfo<QueryCameraListDTO> queryCameraList(QueryCameraListQuDTO query) {
        log.info("\u63a5\u53e3 queryCameraList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.cameraFacade.queryCameraList(query);
        log.info("\u63a5\u53e3 queryCameraList ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((IFWPageInfo)response.getData()).getList())) {
            return (IFWPageInfo)response.getData();
        }
        return null;
    }

    public IFWPageInfo<QueryAlarmRecordDoBO> queryAlarmRecord(QueryAlarmRecordQuDoBO map) {
        IFWPageInfo resultPage = new IFWPageInfo();
        log.info("\u63a5\u53e3 queryAlarmRecord ,\u63a5\u53d7\u53c2\u6570:{}", (Object)map);
        BaseResponse response = this.cameraFacade.queryAlarmRecord((QueryAlarmRecordQuDTO)IFWBeanCopyUtil.map((Object)map, QueryAlarmRecordQuDTO.class));
        log.info("\u63a5\u53e3 queryAlarmRecord ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((IFWPageInfo)response.getData()).getList())) {
            BeanUtils.copyProperties((Object)response.getData(), (Object)resultPage, (String[])new String[]{"list"});
            resultPage.setList(IFWBeanCopyUtil.mapAsList((Iterable)((IFWPageInfo)response.getData()).getList(), QueryAlarmRecordDoBO.class));
            return resultPage;
        }
        return null;
    }
}

