/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetInfoQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryTagListQuDTO;
import com.ifourthwall.dbm.asset.dto.TranslationDTO;
import com.ifourthwall.dbm.asset.dto.UpAssetStatusDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetAppFacade;
import com.ifourthwall.dbm.asset.facade.AssetFacade;
import com.ifourthwall.dbm.sentry.bo.AllTranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.AssetInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetListQueryBO;
import com.ifourthwall.dbm.sentry.bo.QueryTagListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryTagListQuDoBO;
import com.ifourthwall.dbm.sentry.bo.TranslationDoBO;
import com.ifourthwall.dbm.sentry.bo.UpAssetStatusDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository(value="AssetRepository")
public class AssetRepository {
    private static final Logger log = LoggerFactory.getLogger(AssetRepository.class);
    @Reference(version="1.0.0")
    private AssetFacade assetFacade;
    @Reference(version="1.0.0")
    private AssetAppFacade assetAppFacade;

    public QueryAssetInfoDoBO queryAssetInfo(AssetInfoQueryDoBO assetInfo) {
        QueryAssetInfoDoBO resultBO = new QueryAssetInfoDoBO();
        QueryAssetInfoQueryDTO queryAsset = new QueryAssetInfoQueryDTO();
        BeanUtils.copyProperties((Object)assetInfo, (Object)queryAsset);
        log.info("\u63a5\u53e3 queryAssetInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)assetInfo);
        BaseResponse response = this.assetFacade.queryAssetInfo(queryAsset);
        log.info("\u63a5\u53e3 queryAssetInfo ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            BeanUtils.copyProperties((Object)response.getData(), (Object)resultBO);
            return resultBO;
        }
        return resultBO;
    }

    public IFWPageInfo<QueryAssetInfoBO> queryAssetList(QueryAssetListQueryBO assetList) {
        IFWPageInfo resultPage = new IFWPageInfo();
        log.info("\u63a5\u53e3 queryAssetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)assetList);
        BaseResponse pageInfoBaseResponse = this.assetFacade.queryAssetList((QueryAssetListQueryDTO)IFWBeanCopyUtil.map((Object)assetList, QueryAssetListQueryDTO.class));
        log.info("\u63a5\u53e3 queryAssetList ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)pageInfoBaseResponse);
        if (!pageInfoBaseResponse.isFlag()) {
            throw new BizException(pageInfoBaseResponse.getRetMsg(), pageInfoBaseResponse.getRetCode());
        }
        BeanUtils.copyProperties((Object)pageInfoBaseResponse.getData(), (Object)resultPage, (String[])new String[]{"list"});
        if (DataUtils.isListAvali((List)((IFWPageInfo)pageInfoBaseResponse.getData()).getList())) {
            List resultList = IFWBeanCopyUtil.mapAsList((Iterable)((IFWPageInfo)pageInfoBaseResponse.getData()).getList(), QueryAssetInfoBO.class);
            resultPage.setList(resultList);
            return resultPage;
        }
        return null;
    }

    public void upAssetStatus(UpAssetStatusDoBO upInsertAsset) {
        log.info("\u63a5\u53e3 UpAssetStatusDoBO ,\u63a5\u53d7\u53c2\u6570:{}", (Object)upInsertAsset);
        BaseResponse response = this.assetFacade.upAssetStatus((UpAssetStatusDTO)IFWBeanCopyUtil.map((Object)upInsertAsset, UpAssetStatusDTO.class));
        log.info("\u63a5\u53e3 UpAssetStatusDoBO ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
    }

    public PageDTO<QueryTagListDoBO> queryAssetTag(QueryTagListQuDoBO assetTag) {
        PageDTO resultPage = new PageDTO();
        QueryTagListQuDTO queryAssetTag = new QueryTagListQuDTO();
        BeanUtils.copyProperties((Object)assetTag, (Object)queryAssetTag);
        log.info("\u63a5\u53e3 queryAssetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)assetTag);
        BaseResponse response = this.assetFacade.queryTagList(queryAssetTag);
        log.info("\u63a5\u53e3 queryAssetList ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((PageDTO)response.getData()).getResult())) {
            BeanUtils.copyProperties((Object)response.getData(), (Object)resultPage, (String[])new String[]{"result"});
            resultPage.setResult(IFWBeanCopyUtil.mapAsList((Iterable)((PageDTO)response.getData()).getResult(), QueryTagListDoBO.class));
        }
        return resultPage;
    }

    public AllTranslationDoBO allTranslation(TranslationDoBO translation) {
        log.info("\u63a5\u53e3 translation ,\u63a5\u53d7\u53c2\u6570:{}", (Object)translation);
        BaseResponse response = this.assetFacade.allTranslation((TranslationDTO)IFWBeanCopyUtil.map((Object)translation, TranslationDTO.class));
        log.info("\u63a5\u53e3 translation ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        return (AllTranslationDoBO)IFWBeanCopyUtil.map((Object)response.getData(), AllTranslationDoBO.class);
    }

    public List<QueryAssetAppListDTO> queryAssetAppList(QueryAssetAppListQuDTO assetList) {
        log.info("\u63a5\u53e3 queryAssetAppList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)assetList);
        BaseResponse response = this.assetAppFacade.queryAssetAppList(assetList);
        log.info("\u63a5\u53e3 queryAssetAppList ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((List)response.getData()))) {
            return (List)response.getData();
        }
        return null;
    }
}

