/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.dbm.asset.dto.file.SeerFileQuDTO;
import com.ifourthwall.dbm.sentry.bo.FileExportBO;
import com.ifourthwall.dbm.sentry.bo.SeerFileQuBO;
import com.ifourthwall.dbm.sentry.service.SentryFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Sentry\u8868\u683c\u76f8\u5173\u63a5\u53e3"}, value="SeerFileController")
@RequestMapping(value={"/dbm/sentry/file"})
public class SentryFileController {
    private static final Logger log = LoggerFactory.getLogger(SentryFileController.class);
    @Resource(name="SentryFileServiceImpl")
    private SentryFileService fileService;

    @ApiOperation(value="seer\u4e0b\u8f7d\u6570\u636e\u70b9\u4f4d", notes="\u6768\u9e4f")
    @PostMapping(value={"/download"})
    public ResponseEntity<BaseResponse<String>> download(@Valid @RequestBody SeerFileQuDTO query, IFWUser user, HttpServletResponse response) {
        log.info("\u63a5\u53e3 download \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        FileExportBO filePath = this.fileService.download(query, user);
        String fileName = filePath.getFilename() + ".xls";
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setHeader("Access-Control-Allow-Origin", "*");
            ServletOutputStream os = response.getOutputStream();
            filePath.getFile().write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse result = new BaseResponse();
        try {
            result.setData((Object)filePath.getFilename());
            result.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            result.setRetCode(bizException.getCode());
            result.setRetMsg(bizException.getMessage());
            result.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            result.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            result.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            result.setFlag(false);
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="seer\u901a\u8fc7\u70b9\u4f4d\u4e0b\u8f7d\u6570\u636e\u70b9\u4f4d", notes="\u6768\u9e4f")
    @PostMapping(value={"/download/by/datapoint/id"})
    public ResponseEntity<BaseResponse<String>> downloadByDataPoint(@Valid @RequestBody SeerFileQuBO query, IFWUser user, HttpServletResponse response) {
        log.info("\u63a5\u53e3 downloadByDataPoint \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        FileExportBO filePath = this.fileService.downloadByDataPoint(query, user);
        String fileName = filePath.getFilename() + ".xls";
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setHeader("Access-Control-Allow-Origin", "*");
            ServletOutputStream os = response.getOutputStream();
            filePath.getFile().write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse result = new BaseResponse();
        try {
            result.setData((Object)filePath.getFilename());
            result.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            result.setRetCode(bizException.getCode());
            result.setRetMsg(bizException.getMessage());
            result.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            result.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            result.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            result.setFlag(false);
        }
        return ResponseEntity.ok((Object)result);
    }
}

